/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.map.canvas;

import com.google.common.primitives.Bytes;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.minecraft.world.storage.MapData;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.map.MapCanvas;
import org.spongepowered.api.map.color.MapColor;
import org.spongepowered.api.map.color.MapColorTypes;
import org.spongepowered.common.map.canvas.SpongeMapCanvas;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MapUtil;

public final class SpongeMapByteCanvas
implements SpongeMapCanvas {
    public final byte[] canvas;

    public SpongeMapByteCanvas(byte[] canvas) {
        this.canvas = canvas;
    }

    @Override
    public void applyToMapData(MapData mapData) {
        mapData.field_76198_e = (byte[])this.canvas.clone();
        mapData.func_76185_a();
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Constants.Map.MAP_CANVAS, Bytes.asList((byte[])this.canvas));
    }

    @Override
    public MapColor color(int x, int y) {
        if (!MapUtil.isInCanvasBounds(x)) {
            throw new IllegalStateException("x (" + x + ") is out of bounds");
        }
        if (!MapUtil.isInCanvasBounds(y)) {
            throw new IllegalStateException("y (" + y + ") is out of bounds");
        }
        return this.getColor(y * 128 + x);
    }

    public MapColor getColor(int pos) {
        return MapUtil.getMapColorFromPixelValue(this.canvas[pos]).orElseThrow(() -> new IllegalStateException("Tried to get a color that didn't exist! pixel value: " + this.canvas[pos]));
    }

    @Override
    public Image toImage() {
        BufferedImage image = new BufferedImage(128, 128, 1);
        int pos = 0;
        int y = 0;
        while (y < 128) {
            int x = 0;
            while (x < 128) {
                image.setRGB(x, y, this.color(x, y).color().rgb());
                ++x;
                ++pos;
            }
            ++y;
            pos += 128;
        }
        return image;
    }

    @Override
    public Image toImage(Color color) {
        BufferedImage image = new BufferedImage(128, 128, 2);
        int pos = 0;
        int y = 0;
        while (y < 128) {
            int x = 0;
            while (x < 128) {
                MapColor foundColor = this.color(x, y);
                Color paintColor = foundColor.type() == MapColorTypes.NONE.get() ? color : foundColor.color().asJavaColor();
                image.setRGB(x, y, paintColor.getRGB());
                ++x;
                ++pos;
            }
            ++y;
            pos += 128;
        }
        return image;
    }

    @Override
    public MapCanvas.Builder toBuilder() {
        return MapCanvas.builder().from(this);
    }
}

