/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.map.canvas;

import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.map.MapCanvas;
import org.spongepowered.common.map.canvas.SpongeMapByteCanvas;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MapUtil;

public final class SpongeMapCanvasDataBuilder
extends AbstractDataBuilder<MapCanvas> {
    public SpongeMapCanvasDataBuilder() {
        super(MapCanvas.class, 1);
    }

    @Override
    protected Optional<MapCanvas> buildContent(DataView container) throws InvalidDataException {
        Objects.requireNonNull(container, "container cannot be null");
        if (!container.contains(Constants.Map.MAP_CANVAS)) {
            return Optional.empty();
        }
        byte[] canvas = MapUtil.getMapCanvasFromContainer(container);
        return Optional.of(new SpongeMapByteCanvas(canvas));
    }
}

