/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.map.decoration;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.world.storage.MapDecoration;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.map.decoration.MapDecoration;
import org.spongepowered.api.map.decoration.MapDecorationType;
import org.spongepowered.api.map.decoration.orientation.MapDecorationOrientation;
import org.spongepowered.api.map.decoration.orientation.MapDecorationOrientations;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.storage.MapDecorationBridge;
import org.spongepowered.common.map.decoration.SpongeMapDecorationType;
import org.spongepowered.common.map.decoration.orientation.SpongeMapDecorationOrientation;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MapUtil;
import org.spongepowered.math.vector.Vector2i;

public final class SpongeMapDecorationBuilder
implements MapDecoration.Builder {
    private @Nullable MapDecorationType type = null;
    private int x;
    private int y;
    private MapDecorationOrientation rot = MapDecorationOrientations.NORTH.get();
    private @Nullable Component customName = null;

    @Override
    public MapDecoration.Builder type(MapDecorationType type) {
        this.type = type;
        return this;
    }

    @Override
    public MapDecoration.Builder reset() {
        this.type = null;
        this.x = 0;
        this.y = 0;
        this.rot = MapDecorationOrientations.NORTH.get();
        this.customName = null;
        return this;
    }

    @Override
    public MapDecoration.Builder from(org.spongepowered.api.map.decoration.MapDecoration value) {
        Preconditions.checkNotNull((Object)value, (Object)"MapDecoration cannot be null");
        this.type = value.type();
        this.x = value.position().x();
        this.y = value.position().y();
        this.rot = value.rotation();
        return this;
    }

    @Override
    public MapDecoration.Builder rotation(MapDecorationOrientation rot) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)rot, (Object)"Orientation cannot be null");
        this.rot = rot;
        return this;
    }

    @Override
    public MapDecoration.Builder position(Vector2i position) throws IllegalArgumentException {
        Objects.requireNonNull(position, "position cannot be null");
        if (!MapUtil.isInMapDecorationBounds(position.x())) {
            throw new IllegalArgumentException("x not in bounds");
        }
        if (!MapUtil.isInMapDecorationBounds(position.y())) {
            throw new IllegalArgumentException("y not in bounds");
        }
        this.x = position.x();
        this.y = position.y();
        return this;
    }

    @Override
    public MapDecoration.Builder customName(Component customName) {
        this.customName = customName;
        return this;
    }

    @Override
    public MapDecoration.Builder fromContainer(DataView container) {
        if (!container.contains(Constants.Map.DECORATION_TYPE, Constants.Map.DECORATION_ROTATION)) {
            return this;
        }
        this.reset();
        byte type = this.getByteFromContainer(container, Constants.Map.DECORATION_TYPE);
        byte rot = this.getByteFromContainer(container, Constants.Map.DECORATION_ROTATION);
        MapDecoration.Type[] decorations = MapDecoration.Type.values();
        int possibleTypes = decorations.length;
        if (type < 0 || type > possibleTypes) {
            throw new InvalidDataException(Constants.Map.DECORATION_TYPE + ", is out of bounds. Should be 0-" + (possibleTypes - 1));
        }
        MapDecorationType mapDecorationType = SpongeMapDecorationType.toSpongeType(decorations[type]).orElseThrow(() -> new IllegalStateException("Missing a MapDecorationType, could not find one for Minecraft's MapDecoration.Type: " + decorations[type].toString()));
        this.type(mapDecorationType);
        int intRot = MapUtil.normalizeDecorationOrientation(rot);
        this.rotation(MapUtil.getMapRotById(intRot));
        if (container.contains(Constants.Map.DECORATION_X, Constants.Map.DECORATION_Y)) {
            byte x = this.getByteFromContainer(container, Constants.Map.DECORATION_X);
            byte y = this.getByteFromContainer(container, Constants.Map.DECORATION_Y);
            this.position(Vector2i.from((int)x, (int)y));
        }
        if (container.contains(Constants.Map.NAME)) {
            Component component = GsonComponentSerializer.gson().deserialize((Object)container.getString(Constants.Map.NAME).orElseThrow(() -> new InvalidDataException("Invalid data type for " + Constants.Map.NAME + ". Should be String")));
            this.customName(component);
        }
        return this;
    }

    private byte getByteFromContainer(DataView container, DataQuery query) throws InvalidDataException {
        return container.getByte(query).orElseThrow(() -> new InvalidDataException("Invalid data type for " + query + ". Should be byte"));
    }

    @Override
    public org.spongepowered.api.map.decoration.MapDecoration build() throws IllegalStateException {
        Objects.requireNonNull(this.type, "Type has not been set");
        org.spongepowered.api.map.decoration.MapDecoration decoration = (org.spongepowered.api.map.decoration.MapDecoration)new MapDecoration(((SpongeMapDecorationType)this.type).getType(), (byte)this.x, (byte)this.y, (byte)((SpongeMapDecorationOrientation)this.rot).getOrientationNumber(), this.customName == null ? null : SpongeAdventure.asVanilla(this.customName));
        ((MapDecorationBridge)((Object)decoration)).bridge$setPersistent(true);
        return decoration;
    }
}

