/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.commands.arguments.selector;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.MinMaxBoundsWrapped;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.command.selector.Selector;
import org.spongepowered.api.command.selector.SelectorSortAlgorithm;
import org.spongepowered.api.command.selector.SelectorType;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.advancements.critereon.MinMaxBounds_FloatsAccessor;
import org.spongepowered.common.accessor.advancements.critereon.MinMaxBounds_IntsAccessor;
import org.spongepowered.common.bridge.commands.arguments.selector.EntitySelectorParserBridge;
import org.spongepowered.common.command.selector.SpongeSelectorSortAlgorithm;

@Mixin(value={EntitySelectorParser.class})
public abstract class EntitySelectorParserMixin_API
implements Selector.Builder {
    @Shadow
    @Final
    private StringReader field_197417_j;
    @Shadow
    private int field_197418_k;
    @Shadow
    private BiConsumer<Vector3d, List<? extends net.minecraft.entity.Entity>> field_197432_y;
    @Shadow
    private MinMaxBounds.FloatBound field_197421_n;
    @Shadow
    private MinMaxBounds.IntBound field_197422_o;
    @Shadow
    private boolean field_197419_l;
    @Shadow
    private boolean field_197420_m;
    @Shadow
    private @Nullable Double field_197423_p;
    @Shadow
    private @Nullable Double field_197424_q;
    @Shadow
    private @Nullable Double field_197425_r;
    @Shadow
    private @Nullable Double field_197426_s;
    @Shadow
    private @Nullable Double field_197427_t;
    @Shadow
    private @Nullable Double field_197428_u;
    @Shadow
    private MinMaxBoundsWrapped field_197429_v = MinMaxBoundsWrapped.field_207926_a;
    @Shadow
    private MinMaxBoundsWrapped field_197430_w = MinMaxBoundsWrapped.field_207926_a;
    @Shadow
    private Predicate<net.minecraft.entity.Entity> field_197431_x;
    @Shadow
    private boolean field_197433_z;
    @Shadow
    private @Nullable String field_197406_A;
    @Shadow
    private int field_201999_C;
    @Shadow
    private @Nullable UUID field_197407_B;
    @Shadow
    private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> field_201354_D;
    @Shadow
    private boolean field_202000_F;
    @Shadow
    private boolean field_202001_G;
    @Shadow
    private boolean field_202002_H;
    @Shadow
    private boolean field_202003_I;
    @Shadow
    private boolean field_202004_J;
    @Shadow
    private boolean field_202005_K;
    @Shadow
    private boolean field_202006_L;
    @Shadow
    private boolean field_202007_M;
    @Shadow
    private @Nullable net.minecraft.entity.EntityType<?> field_202008_N;
    @Shadow
    private boolean field_202009_O;
    @Shadow
    private boolean field_202010_P;
    @Shadow
    private boolean field_202011_Q;
    @Shadow
    private boolean field_210327_T;
    private @Nullable Map<String, Range<@NonNull Integer>> api$scores;
    private @Nullable Object2BooleanOpenHashMap<String> api$advancement;
    private @Nullable Map<String, Object2BooleanOpenHashMap<String>> api$criterion;
    private boolean api$forceSelf;

    @Shadow
    public abstract void shadow$func_201979_e(boolean var1);

    @Shadow
    public abstract void shadow$func_201986_f(boolean var1);

    @Shadow
    public abstract void shadow$func_197384_a(double var1);

    @Shadow
    public abstract void shadow$func_197395_b(double var1);

    @Shadow
    public abstract void shadow$func_197372_c(double var1);

    @Shadow
    public abstract void shadow$func_197377_d(double var1);

    @Shadow
    public abstract void shadow$func_197391_e(double var1);

    @Shadow
    public abstract void shadow$func_197405_f(double var1);

    @Shadow
    public abstract void shadow$func_197373_a(boolean var1);

    @Shadow
    public abstract EntitySelector shadow$func_197400_a();

    @Shadow
    public abstract void shadow$func_197401_a(Predicate<net.minecraft.entity.Entity> var1);

    @Override
    public @NonNull Selector.Builder applySelectorType(Supplier<? extends SelectorType> selectorType) {
        return this.applySelectorType(selectorType.get());
    }

    @Override
    public @NonNull Selector.Builder applySelectorType(@NonNull SelectorType selectorType) {
        try {
            ((EntitySelectorParserBridge)((Object)this)).bridge$parseSelector(selectorType);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new IllegalArgumentException("Could not parse provided SelectorType", commandSyntaxException);
        }
        return this;
    }

    @Override
    public @NonNull Selector.Builder includeSelf() {
        this.api$forceSelf = true;
        return this;
    }

    @Override
    public @NonNull Selector.Builder limit(int limit) {
        this.field_197418_k = limit;
        this.shadow$func_201979_e(limit != Integer.MAX_VALUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder distance(@NonNull Range<@NonNull Double> range) {
        if (range.min() != null && range.min() < 0.0) {
            throw new IllegalArgumentException("min must be non-negative");
        }
        if (range.max() != null && range.max() < 0.0) {
            throw new IllegalArgumentException("max must be non-negative");
        }
        this.field_197421_n = MinMaxBounds_FloatsAccessor.invoker$new(this.api$floatFromDouble(range.min(), Function.identity()), this.api$floatFromDouble(range.max(), Function.identity()));
        return this;
    }

    @Override
    public @NonNull Selector.Builder volume(@NonNull org.spongepowered.math.vector.Vector3d corner1, @NonNull org.spongepowered.math.vector.Vector3d corner2) {
        org.spongepowered.math.vector.Vector3d minPoint = corner1.min(corner2);
        org.spongepowered.math.vector.Vector3d distance = corner1.max(corner2).sub(minPoint);
        this.shadow$func_197384_a(minPoint.x());
        this.shadow$func_197395_b(minPoint.y());
        this.shadow$func_197372_c(minPoint.z());
        this.shadow$func_197377_d(distance.x());
        this.shadow$func_197391_e(distance.y());
        this.shadow$func_197405_f(distance.z());
        return this;
    }

    @Override
    public @NonNull Selector.Builder sortAlgorithm(@NonNull Supplier<? extends SelectorSortAlgorithm> algorithm) {
        return this.sortAlgorithm(algorithm.get());
    }

    @Override
    public @NonNull Selector.Builder sortAlgorithm(@NonNull SelectorSortAlgorithm algorithm) {
        Preconditions.checkArgument((boolean)(algorithm instanceof SpongeSelectorSortAlgorithm), (Object)"Must be a SpongeSelectorSortAlgorithm");
        this.shadow$func_201986_f(true);
        this.field_197432_y = ((SpongeSelectorSortAlgorithm)algorithm).getSortAlgorithm();
        return this;
    }

    @Override
    public @NonNull Selector.Builder addAdvancement(@NonNull Advancement advancement) {
        return this.api$advancement(advancement, false);
    }

    @Override
    public @NonNull Selector.Builder addNotAdvancement(@NonNull Advancement advancement) {
        return this.api$advancement(advancement, true);
    }

    @Override
    public @NonNull Selector.Builder addAdvancementCriterion(@NonNull Advancement advancement, @NonNull AdvancementCriterion criterion) {
        return this.api$advancementCriterion(advancement, criterion, false);
    }

    @Override
    public @NonNull Selector.Builder addNotAdvancementCriterion(@NonNull Advancement advancement, @NonNull AdvancementCriterion criterion) {
        return this.api$advancementCriterion(advancement, criterion, true);
    }

    @Override
    public @NonNull Selector.Builder dataView(@NonNull DataView view) {
        try {
            String json = DataFormats.JSON.get().write(view);
            this.api$handle("nbt", json);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create JSON representation of DataView", e);
        }
    }

    @Override
    public @NonNull Selector.Builder addNotEntityType(@NonNull Supplier<@NonNull EntityType<@NonNull ?>> type) {
        return this.addNotEntityType(type.get());
    }

    @Override
    public @NonNull Selector.Builder addNotEntityType(@NonNull EntityType<@NonNull ?> type) {
        ResourceKey key = (ResourceKey)Registry.field_212629_r.func_177774_c((Object)((net.minecraft.entity.EntityType)type));
        this.api$handle("type", "!" + key.asString());
        return this;
    }

    @Override
    public @NonNull Selector.Builder addEntityType(@NonNull Supplier<@NonNull EntityType<@NonNull ?>> type, boolean inherit) {
        return this.addEntityType(type.get(), inherit);
    }

    @Override
    public @NonNull Selector.Builder addEntityType(@NonNull EntityType<@NonNull ?> type, boolean inherit) {
        ResourceKey key = (ResourceKey)Registry.field_212629_r.func_177774_c((Object)((net.minecraft.entity.EntityType)type));
        this.api$handle("type", String.format("%s%s", inherit ? "#" : "", key.asString()));
        return this;
    }

    @Override
    public @NonNull Selector.Builder experienceLevel(@NonNull Range<@NonNull Integer> range) {
        Preconditions.checkArgument((range.min() == null || range.min() >= 0 ? 1 : 0) != 0, (Object)"min must be non-negative");
        Preconditions.checkArgument((range.max() == null || range.max() >= 0 ? 1 : 0) != 0, (Object)"max must be non-negative");
        this.field_197422_o = MinMaxBounds_IntsAccessor.invoker$new(range.min(), range.max());
        this.shadow$func_197373_a(false);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addGameMode(@NonNull Supplier<? extends GameMode> mode) {
        return this.addGameMode(mode.get());
    }

    @Override
    public @NonNull Selector.Builder addGameMode(@NonNull GameMode mode) {
        ResourceKey key = Sponge.game().registry(RegistryTypes.GAME_MODE).valueKey(mode);
        this.api$handle("gamemode", key.value(), Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addNotGameMode(@NonNull Supplier<? extends GameMode> mode) {
        return this.addNotGameMode(mode.get());
    }

    @Override
    public @NonNull Selector.Builder addNotGameMode(@NonNull GameMode mode) {
        ResourceKey key = Sponge.game().registry(RegistryTypes.GAME_MODE).valueKey(mode);
        this.api$handle("gamemode", key.value(), Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder noTeam() {
        this.api$handle("team", "", Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder anyTeam() {
        this.api$handle("team", "", Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addTeam(@NonNull Team team) {
        this.api$handle("team", team.name(), Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addNotTeam(@NonNull Team team) {
        this.api$handle("team", team.name(), Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addName(@NonNull String name) {
        this.api$handle("name", name, Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addNotName(@NonNull String name) {
        this.api$handle("name", name, Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addObjective(@NonNull Objective objective, @NonNull Range<@NonNull Integer> range) {
        if (this.api$scores == null) {
            this.api$scores = new HashMap<String, Range<Integer>>();
        }
        this.api$scores.put(objective.name(), range);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addTag(@NonNull String tag) {
        this.api$handle("tag", tag, Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addNotTag(@NonNull String tag) {
        this.api$handle("tag", tag, Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder pitch(@NonNull Range<@NonNull Double> range) {
        this.field_197429_v = this.api$getWrappedBounds(range);
        return this;
    }

    @Override
    public @NonNull Selector.Builder yaw(@NonNull Range<@NonNull Double> range) {
        this.field_197430_w = this.api$getWrappedBounds(range);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addFilter(@NonNull Predicate<@NonNull Entity> filter) {
        this.shadow$func_197401_a(filter);
        return this;
    }

    @Override
    public @NonNull Selector build() throws IllegalStateException {
        ArrayList entries;
        if (this.api$advancement != null || this.api$criterion != null) {
            entries = new ArrayList();
            if (this.api$advancement != null) {
                this.api$advancement.object2BooleanEntrySet().fastForEach(x -> entries.add((String)x.getKey() + "=" + x.getBooleanValue()));
            }
            if (this.api$criterion != null) {
                this.api$criterion.forEach((key, value) -> value.object2BooleanEntrySet().fastForEach(x -> entries.add(key + "={" + (String)x.getKey() + "=" + x.getBooleanValue() + "}")));
            }
            this.api$handle("advancements", "{" + String.join((CharSequence)",", entries) + "}");
            this.api$advancement = null;
            this.api$criterion = null;
        }
        if (this.api$scores != null) {
            entries = new ArrayList();
            this.api$scores.forEach((key, range) -> entries.add(key + "=" + this.api$intRangeToStringRepresentation((Range<Integer>)range)));
            this.api$handle("scores", "{" + String.join((CharSequence)",", entries) + "}");
            this.api$scores = null;
        }
        if (this.api$forceSelf) {
            this.field_197433_z = true;
        }
        return (Selector)this.shadow$func_197400_a();
    }

    @Override
    public @NonNull Selector.Builder reset() {
        this.field_197432_y = EntitySelectorParser.field_197413_f;
        this.field_197421_n = MinMaxBounds.FloatBound.field_211359_e;
        this.field_197422_o = MinMaxBounds.IntBound.field_211347_e;
        this.field_197419_l = false;
        this.field_197420_m = false;
        this.field_197423_p = null;
        this.field_197424_q = null;
        this.field_197425_r = null;
        this.field_197426_s = null;
        this.field_197427_t = null;
        this.field_197428_u = null;
        this.field_197429_v = MinMaxBoundsWrapped.field_207926_a;
        this.field_197430_w = MinMaxBoundsWrapped.field_207926_a;
        this.field_197431_x = x -> true;
        this.field_197433_z = false;
        this.field_197406_A = null;
        this.field_201999_C = 0;
        this.field_197407_B = null;
        this.field_202000_F = false;
        this.field_202001_G = false;
        this.field_202002_H = false;
        this.field_202003_I = false;
        this.field_202004_J = false;
        this.field_202005_K = false;
        this.field_202006_L = false;
        this.field_202007_M = false;
        this.field_202008_N = null;
        this.field_202009_O = false;
        this.field_202010_P = false;
        this.field_202011_Q = false;
        this.field_210327_T = false;
        this.field_197417_j.setCursor(0);
        this.field_201354_D = EntitySelectorParser.field_201355_j;
        this.api$forceSelf = false;
        return this;
    }

    private @NonNull Selector.Builder api$advancement(@NonNull Advancement advancement, boolean inverted) {
        if (this.api$advancement == null) {
            this.api$advancement = new Object2BooleanOpenHashMap();
        }
        this.api$advancement.put((Object)advancement.key().asString(), inverted);
        return this;
    }

    private @NonNull Selector.Builder api$advancementCriterion(@NonNull Advancement advancement, @NonNull AdvancementCriterion criterion, boolean inverted) {
        if (this.api$criterion == null) {
            this.api$criterion = new HashMap<String, Object2BooleanOpenHashMap<String>>();
        }
        this.api$criterion.computeIfAbsent(advancement.key().toString(), k -> new Object2BooleanOpenHashMap()).put((Object)criterion.name(), inverted);
        return this;
    }

    private void api$handle(@NonNull String name, @NonNull String value) {
        this.api$handle(name, value, Tristate.UNDEFINED);
    }

    private void api$handle(@NonNull String name, @NonNull String value, @NonNull Tristate invert) {
        try {
            ((EntitySelectorParserBridge)((Object)this)).bridge$handleValue(name, value, invert);
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException(String.format("Could not create selector criteria based on input (name = '%s', value = '%s', invert = %s)", name, value, invert.name()), ex);
        }
    }

    private @Nullable Float api$floatFromDouble(@Nullable Double d, Function<Float, Float> mapping) {
        if (d == null) {
            return null;
        }
        return mapping.apply(Float.valueOf(d.floatValue()));
    }

    private MinMaxBoundsWrapped api$getWrappedBounds(Range<@NonNull Double> range) {
        Float a = this.api$floatFromDouble(range.min(), MathHelper::func_76142_g);
        Float b = this.api$floatFromDouble(range.max(), MathHelper::func_76142_g);
        if (a == null) {
            return new MinMaxBoundsWrapped(null, b);
        }
        if (b == null) {
            return new MinMaxBoundsWrapped(a, null);
        }
        if (a.floatValue() <= b.floatValue()) {
            return new MinMaxBoundsWrapped(a, b);
        }
        return new MinMaxBoundsWrapped(b, a);
    }

    private String api$intRangeToStringRepresentation(@NonNull Range<@NonNull Integer> range) {
        if (range.min() != null && range.max() != null && range.min().intValue() == range.max().intValue()) {
            return String.valueOf(range.max());
        }
        return String.format("%s..%s", range.min() == null ? "" : String.valueOf(range.min()), range.max() == null ? "" : String.valueOf(range.max()));
    }
}

