/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.core;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.ValueNotFoundException;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.core.RegistryBridge;

@Mixin(value={net.minecraft.util.registry.Registry.class})
@Implements(value={@Interface(iface=Registry.class, prefix="registry$", remap=Interface.Remap.NONE)})
public abstract class RegistryMixin_API<T>
implements Registry<T> {
    @Shadow
    public abstract RegistryKey<? extends net.minecraft.util.registry.Registry<T>> shadow$func_243578_f();

    @Shadow
    @Nullable
    public abstract ResourceLocation shadow$func_177774_c(T var1);

    @Shadow
    public abstract Optional<T> shadow$func_241873_b(@Nullable ResourceLocation var1);

    @Override
    public RegistryType<T> type() {
        return ((RegistryBridge)((Object)this)).bridge$type();
    }

    @Override
    public ResourceKey valueKey(T value) {
        Objects.requireNonNull(value, "value");
        ResourceLocation key = this.shadow$func_177774_c(value);
        if (key == null) {
            throw new IllegalStateException(String.format("No key was found for '%s'!", value));
        }
        return (ResourceKey)key;
    }

    @Override
    public Optional<ResourceKey> findValueKey(T value) {
        Objects.requireNonNull(value, "value");
        return Optional.ofNullable(this.shadow$func_177774_c(value)).map(l -> (ResourceKey)l);
    }

    @Override
    public <V extends T> Optional<RegistryEntry<V>> findEntry(ResourceKey key) {
        return ((RegistryBridge)((Object)this)).bridge$get(Objects.requireNonNull(key, "key"));
    }

    @Override
    public <V extends T> Optional<V> findValue(ResourceKey key) {
        return this.shadow$func_241873_b((ResourceLocation)Objects.requireNonNull(key, "key"));
    }

    @Override
    public <V extends T> V value(ResourceKey key) {
        return (V)this.shadow$func_241873_b((ResourceLocation)Objects.requireNonNull(key, "key")).orElseThrow(() -> new ValueNotFoundException(String.format("No value was found for key '%s'!", key)));
    }

    @Override
    public Stream<RegistryEntry<T>> streamEntries() {
        return ((RegistryBridge)((Object)this)).bridge$streamEntries();
    }

    @Intrinsic
    public Stream<T> registry$stream() {
        return ((RegistryBridge)((Object)this)).bridge$streamEntries().map(RegistryEntry::value);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public <V extends T> Optional<RegistryEntry<V>> register(ResourceKey key, V value) {
        return Optional.empty();
    }
}

