/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.map;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.storage.MapDecoration;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.map.decoration.MapDecoration;
import org.spongepowered.api.map.decoration.MapDecorationType;
import org.spongepowered.api.map.decoration.orientation.MapDecorationOrientation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.storage.MapDecorationBridge;
import org.spongepowered.common.map.decoration.SpongeMapDecorationType;
import org.spongepowered.common.map.decoration.orientation.SpongeMapDecorationOrientation;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MapUtil;
import org.spongepowered.math.vector.Vector2i;

@Mixin(value={net.minecraft.world.storage.MapDecoration.class})
public abstract class MapDecorationMixin_API
implements MapDecoration {
    @Shadow
    @Final
    private MapDecoration.Type field_191181_a;
    @Shadow
    private byte field_176115_b;
    @Shadow
    private byte field_176116_c;
    @Shadow
    private byte field_176114_d;

    @Shadow
    @Nullable
    public abstract ITextComponent shadow$func_204309_g();

    @Override
    public MapDecorationType type() {
        return SpongeMapDecorationType.toSpongeType(this.field_191181_a).orElseThrow(() -> new IllegalStateException("Tried to get MapDecoration type but it didn't exist in Sponge's registries! Have MC Decoration types been missed?"));
    }

    @Override
    public Vector2i position() {
        return new Vector2i((int)this.field_176115_b, (int)this.field_176116_c);
    }

    @Override
    public void setPosition(Vector2i position) {
        Preconditions.checkState((boolean)MapUtil.isInMapDecorationBounds(position.x()), (Object)"x position out of bounds");
        Preconditions.checkState((boolean)MapUtil.isInMapDecorationBounds(position.y()), (Object)"y position out of bounds");
        this.field_176115_b = (byte)position.x();
        this.field_176116_c = (byte)position.y();
        ((MapDecorationBridge)((Object)this)).bridge$markAllDirty();
    }

    @Override
    public void setRotation(MapDecorationOrientation dir) {
        this.field_176114_d = (byte)((SpongeMapDecorationOrientation)dir).getOrientationNumber();
        ((MapDecorationBridge)((Object)this)).bridge$markAllDirty();
    }

    @Override
    public MapDecorationOrientation rotation() {
        int rot = MapUtil.normalizeDecorationOrientation(this.field_176114_d);
        return MapUtil.getMapRotById(rot);
    }

    @Override
    public boolean isPersistent() {
        return ((MapDecorationBridge)((Object)this)).bridge$isPersistent();
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer data = DataContainer.createNew().set(Constants.Map.DECORATION_TYPE, this.field_191181_a.func_191163_a()).set(Constants.Map.DECORATION_ID, ((MapDecorationBridge)((Object)this)).bridge$getKey()).set(Constants.Map.DECORATION_X, this.field_176115_b).set(Constants.Map.DECORATION_Y, this.field_176116_c).set(Constants.Map.DECORATION_ROTATION, (byte)MapUtil.normalizeDecorationOrientation(this.field_176114_d));
        if (this.shadow$func_204309_g() != null) {
            data.set(Constants.Map.NAME, ITextComponent.Serializer.func_150696_a((ITextComponent)this.shadow$func_204309_g()));
        }
        return data;
    }
}

