/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.map;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BannerBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldSavedData;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.map.MapInfo;
import org.spongepowered.api.map.decoration.MapDecoration;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.storage.MapItemSavedDataBridge;
import org.spongepowered.common.data.holder.SpongeMutableDataHolder;
import org.spongepowered.common.util.Constants;

@Mixin(value={MapData.class})
public abstract class MapInfoMixin_API
extends WorldSavedData
implements MapInfo,
SpongeMutableDataHolder {
    public MapInfoMixin_API(String name) {
        super(name);
    }

    @Shadow
    public abstract void func_204269_a(IWorld var1, BlockPos var2);

    @Override
    public boolean isLinked(ItemStack itemStack) {
        return itemStack.type() == ItemTypes.FILLED_MAP.get() && itemStack.get(Keys.MAP_INFO).isPresent() && itemStack.get(Keys.MAP_INFO).get() == this;
    }

    @Override
    public void addBannerDecoration(ServerLocation bannerLocation) throws IllegalArgumentException {
        BlockType bannerType = bannerLocation.block().type();
        Preconditions.checkArgument((boolean)(bannerType instanceof BannerBlock), (Object)"Location must have a banner!");
        this.func_204269_a((IWorld)bannerLocation.world(), new BlockPos(bannerLocation.blockX(), bannerLocation.blockY(), bannerLocation.blockZ()));
        this.func_76185_a();
    }

    @Override
    public UUID uniqueId() {
        return ((MapItemSavedDataBridge)((Object)this)).bridge$getUniqueId();
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        ArrayList decorationList = new ArrayList();
        ((Set)this.require(Keys.MAP_DECORATIONS)).stream().filter(MapDecoration::isPersistent).forEach(decorationList::add);
        return DataContainer.createNew().set(Constants.Map.MAP_UNSAFE_ID, ((MapItemSavedDataBridge)((Object)this)).bridge$getMapId()).set(Constants.Map.MAP_DATA, DataContainer.createNew().set(Constants.Map.MAP_LOCATION, this.require(Keys.MAP_LOCATION))).set(Constants.Map.MAP_WORLD, this.require(Keys.MAP_WORLD)).set(Constants.Map.MAP_TRACKS_PLAYERS, this.require(Keys.MAP_TRACKS_PLAYERS)).set(Constants.Map.MAP_UNLIMITED_TRACKING, this.require(Keys.MAP_UNLIMITED_TRACKING)).set(Constants.Map.MAP_SCALE, this.require(Keys.MAP_SCALE)).set(Constants.Map.MAP_CANVAS, this.require(Keys.MAP_CANVAS)).set(Constants.Map.MAP_LOCKED, this.require(Keys.MAP_LOCKED)).set(Constants.Map.MAP_DECORATIONS, decorationList);
    }
}

