/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.command.Commands;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Game;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.recipe.RecipeManager;
import org.spongepowered.api.map.MapStorage;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.resource.ResourceManager;
import org.spongepowered.api.resource.pack.PackRepository;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.service.ServiceProvider;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.api.world.teleport.TeleportHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.commands.CommandsBridge;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.map.SpongeMapStorage;
import org.spongepowered.common.profile.SpongeGameProfileManager;
import org.spongepowered.common.registry.RegistryHolderLogic;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.scheduler.ServerScheduler;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.UsernameCache;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.storage.SpongePlayerDataManager;
import org.spongepowered.common.world.teleport.SpongeTeleportHelper;

@Mixin(value={MinecraftServer.class})
@Implements(value={@Interface(iface=Server.class, prefix="server$", remap=Interface.Remap.NONE)})
public abstract class MinecraftServerMixin_API
implements SpongeServer,
SpongeRegistryHolder {
    @Shadow
    @Final
    public long[] field_71311_j;
    @Shadow
    @Final
    protected IServerConfiguration field_240768_i_;
    @Shadow
    private DataPackRegistries field_195576_ac;
    private Iterable<? extends Audience> audiences;
    private ServerScheduler api$scheduler;
    private SpongeTeleportHelper api$teleportHelper;
    private SpongePlayerDataManager api$playerDataHandler;
    private UsernameCache api$usernameCache;
    private Audience api$broadcastAudience;
    private ServerScoreboard api$scoreboard;
    private SpongeGameProfileManager api$profileManager;
    private MapStorage api$mapStorage;
    private RegistryHolderLogic api$registryHolder;
    private SpongeUserManager api$userManager;

    @Shadow
    public abstract net.minecraft.item.crafting.RecipeManager shadow$func_199529_aN();

    @Shadow
    public abstract PlayerList shadow$func_184103_al();

    @Shadow
    public abstract boolean shadow$func_71266_T();

    @Shadow
    public abstract String shadow$func_71273_Y();

    @Shadow
    public abstract int shadow$func_71259_af();

    @Shadow
    public abstract void shadow$func_71263_m(boolean var1);

    @Shadow
    public abstract int shadow$func_143007_ar();

    @Shadow
    public abstract void shadow$func_143006_e(int var1);

    @Shadow
    public abstract boolean shadow$func_71199_h();

    @Shadow
    public abstract boolean shadow$func_104056_am();

    @Shadow
    public abstract boolean shadow$func_71219_W();

    @Shadow
    public abstract boolean shadow$func_82356_Z();

    @Shadow
    protected abstract boolean shadow$func_230536_N_();

    @Shadow
    public abstract boolean shadow$func_230537_U_();

    @Shadow
    public abstract boolean shadow$func_71255_r();

    @Shadow
    public abstract Commands shadow$func_195571_aL();

    @Shadow
    public abstract ResourcePackList shadow$func_195561_aH();

    @Inject(method={"<init>(Ljava/lang/Thread;Lnet/minecraft/util/registry/DynamicRegistries$Impl;Lnet/minecraft/world/storage/SaveFormat$LevelSave;Lnet/minecraft/world/storage/IServerConfiguration;Lnet/minecraft/resources/ResourcePackList;Ljava/net/Proxy;Lcom/mojang/datafixers/DataFixer;Lnet/minecraft/resources/DataPackRegistries;Lcom/mojang/authlib/minecraft/MinecraftSessionService;Lcom/mojang/authlib/GameProfileRepository;Lnet/minecraft/server/management/PlayerProfileCache;Lnet/minecraft/world/chunk/listener/IChunkStatusListenerFactory;)V"}, at={@At(value="TAIL")})
    public void api$initializeSpongeFields(Thread p_i232576_1_, DynamicRegistries.Impl p_i232576_2_, SaveFormat.LevelSave p_i232576_3_, IServerConfiguration p_i232576_4_, ResourcePackList p_i232576_5_, Proxy p_i232576_6_, DataFixer p_i232576_7_, DataPackRegistries p_i232576_8_, MinecraftSessionService p_i232576_9_, GameProfileRepository p_i232576_10_, PlayerProfileCache p_i232576_11_, IChunkStatusListenerFactory p_i232576_12_, CallbackInfo ci) {
        this.api$scheduler = new ServerScheduler();
        this.api$playerDataHandler = new SpongePlayerDataManager(this);
        this.api$teleportHelper = new SpongeTeleportHelper();
        this.api$mapStorage = new SpongeMapStorage();
        this.api$registryHolder = new RegistryHolderLogic((DynamicRegistries)p_i232576_2_);
        this.api$userManager = new SpongeUserManager((MinecraftServer)this);
    }

    @Override
    public RecipeManager recipeManager() {
        return (RecipeManager)this.shadow$func_199529_aN();
    }

    public @NonNull Iterable<? extends Audience> audiences() {
        if (this.audiences == null) {
            this.audiences = Iterables.concat((Iterable)this.shadow$func_184103_al().func_181057_v(), Collections.singleton(Sponge.game().systemSubject()));
        }
        return this.audiences;
    }

    @Override
    public ChunkLayout chunkLayout() {
        return SpongeChunkLayout.INSTANCE;
    }

    @Override
    public Audience broadcastAudience() {
        if (this.api$broadcastAudience == null) {
            this.api$broadcastAudience = this;
        }
        return this.api$broadcastAudience;
    }

    @Override
    public void setBroadcastAudience(Audience channel) {
        this.api$broadcastAudience = Objects.requireNonNull(channel, "channel");
    }

    @Override
    public Optional<InetSocketAddress> boundAddress() {
        return Optional.empty();
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.shadow$func_184103_al().func_72383_n();
    }

    @Override
    public void setHasWhitelist(boolean enabled) {
        this.shadow$func_184103_al().func_72371_a(enabled);
    }

    @Override
    public boolean isOnlineModeEnabled() {
        return this.shadow$func_71266_T();
    }

    @Override
    public boolean isHardcoreModeEnabled() {
        return this.shadow$func_71199_h();
    }

    @Override
    public Difficulty difficulty() {
        return (Difficulty)this.field_240768_i_.func_176130_y();
    }

    @Override
    public GameMode gameMode() {
        return (GameMode)this.field_240768_i_.func_76077_q();
    }

    @Override
    public boolean isGameModeEnforced() {
        return this.shadow$func_104056_am();
    }

    @Override
    public boolean isPVPEnabled() {
        return this.shadow$func_71219_W();
    }

    @Override
    public boolean areCommandBlocksEnabled() {
        return this.shadow$func_82356_Z();
    }

    @Override
    public boolean isMonsterSpawnsEnabled() {
        return this.shadow$func_230536_N_();
    }

    @Override
    public boolean isAnimalSpawnsEnabled() {
        return this.shadow$func_230537_U_();
    }

    @Override
    public boolean isMultiWorldEnabled() {
        return this.shadow$func_71255_r();
    }

    @Override
    public SpongeUserManager userManager() {
        return this.api$userManager;
    }

    @Override
    public TeleportHelper teleportHelper() {
        return this.api$teleportHelper;
    }

    @Override
    public Collection<ServerPlayer> onlinePlayers() {
        if (this.shadow$func_184103_al() == null || this.shadow$func_184103_al().func_181057_v() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.shadow$func_184103_al().func_181057_v());
    }

    @Override
    public Optional<ServerPlayer> player(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        if (this.shadow$func_184103_al() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ServerPlayer)this.shadow$func_184103_al().func_177451_a(uniqueId));
    }

    @Override
    public Optional<ServerPlayer> player(String name) {
        if (this.shadow$func_184103_al() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ServerPlayer)this.shadow$func_184103_al().func_152612_a(name));
    }

    @Override
    public Component motd() {
        return LegacyComponentSerializer.legacySection().deserialize(this.shadow$func_71273_Y());
    }

    @Override
    public int maxPlayers() {
        if (this.shadow$func_184103_al() == null) {
            return 0;
        }
        return this.shadow$func_184103_al().func_72352_l();
    }

    @Override
    public @NonNull Ticks runningTimeTicks() {
        return Ticks.of(this.shadow$func_71259_af());
    }

    @Override
    public double ticksPerSecond() {
        return 1000.0 / Math.max(50.0, this.averageTickTime());
    }

    @Override
    public double averageTickTime() {
        return MathHelper.func_76127_a((long[])this.field_71311_j) / 1000000.0;
    }

    @Override
    public int targetTicksPerSecond() {
        return 20;
    }

    @Override
    public void shutdown() {
        this.shadow$func_71263_m(false);
    }

    @Override
    public void shutdown(Component kickMessage) {
        Objects.requireNonNull(kickMessage, "kickMessage");
        for (ServerPlayer player : this.onlinePlayers()) {
            player.kick(kickMessage);
        }
        this.shadow$func_71263_m(false);
    }

    @Override
    public GameProfileManager gameProfileManager() {
        if (this.api$profileManager == null) {
            this.api$profileManager = new SpongeGameProfileManager(this);
        }
        return this.api$profileManager;
    }

    @Override
    public SpongeGameProfileManager gameProfileManagerIfPresent() {
        return this.api$profileManager;
    }

    @Override
    public SpongeCommandManager commandManager() {
        return ((CommandsBridge)this.shadow$func_195571_aL()).bridge$commandManager();
    }

    public Optional<ResourcePack> server$resourcePack() {
        return Optional.ofNullable(((MinecraftServerBridge)((Object)this)).bridge$getResourcePack());
    }

    public Optional<Scoreboard> serverScoreboard() {
        if (this.api$scoreboard == null) {
            ServerWorld world = SpongeCommon.server().func_241755_D_();
            if (world == null) {
                return Optional.empty();
            }
            this.api$scoreboard = world.func_96441_U();
        }
        return Optional.of((Scoreboard)this.api$scoreboard);
    }

    @Intrinsic
    public int server$playerIdleTimeout() {
        return this.shadow$func_143007_ar();
    }

    @Intrinsic
    public void server$setPlayerIdleTimeout(int timeout) {
        this.shadow$func_143006_e(timeout);
    }

    @Override
    public Game game() {
        return Sponge.game();
    }

    @Override
    public CauseStackManager causeStackManager() {
        return PhaseTracker.getCauseStackManager();
    }

    @Override
    public PackRepository packRepository() {
        return (PackRepository)this.shadow$func_195561_aH();
    }

    @Override
    public ResourceManager resourceManager() {
        return (ResourceManager)this.field_195576_ac.func_240970_h_();
    }

    @Override
    public ServerScheduler scheduler() {
        return this.api$scheduler;
    }

    @Override
    public boolean onMainThread() {
        return ((MinecraftServer)this).func_213162_bc();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public SpongePlayerDataManager getPlayerDataManager() {
        return this.api$playerDataHandler;
    }

    @Override
    public UsernameCache getUsernameCache() {
        if (this.api$usernameCache == null) {
            this.api$usernameCache = new UsernameCache(this);
        }
        return this.api$usernameCache;
    }

    public void sendMessage(Identity identity, Component message, MessageType type) {
        this.shadow$func_184103_al().func_232641_a_(SpongeAdventure.asVanilla(message), SpongeAdventure.asVanilla(type), identity.uuid());
    }

    @Override
    public ServiceProvider.ServerScoped serviceProvider() {
        return ((MinecraftServerBridge)((Object)this)).bridge$getServiceProvider();
    }

    @Override
    public MapStorage mapStorage() {
        return this.api$mapStorage;
    }

    @Override
    public RegistryHolderLogic registryHolder() {
        return this.api$registryHolder;
    }
}

