/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.util.registry.SimpleRegistry;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.accessor.world.scores.ScoreboardAccessor;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.scoreboard.SpongeObjective;

@Mixin(value={ServerScoreboard.class})
public abstract class ServerScoreboardMixin_API
implements Scoreboard {
    @Override
    public Optional<Objective> objective(String name) {
        Objects.requireNonNull(name);
        ScoreObjective objective = ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().get(name);
        return Optional.ofNullable(objective == null ? null : ((ObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    @Override
    public Optional<Objective> objective(DisplaySlot slot) {
        SimpleRegistry registry = (SimpleRegistry)Sponge.game().registry(RegistryTypes.DISPLAY_SLOT);
        ScoreObjective objective = ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives()[registry.func_148757_b((Object)slot)];
        if (objective != null) {
            return Optional.of(((ObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return Optional.empty();
    }

    @Override
    public Set<Objective> objectivesByCriterion(Criterion criterion) {
        if (((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().containsKey(criterion)) {
            return ((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().get(criterion).stream().map(objective -> ((ObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
        }
        return new HashSet<Objective>();
    }

    @Override
    public void addObjective(Objective objective) throws IllegalArgumentException {
        Objects.requireNonNull(objective);
        ((ServerScoreboardBridge)((Object)this)).bridge$addObjective(objective);
    }

    @Override
    public void updateDisplaySlot(@Nullable Objective objective, DisplaySlot displaySlot) throws IllegalStateException {
        Objects.requireNonNull(displaySlot);
        ((ServerScoreboardBridge)((Object)this)).bridge$updateDisplaySlot(objective, displaySlot);
    }

    @Override
    public Set<Objective> objectives() {
        return ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().values().stream().map(objective -> ((ObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
    }

    @Override
    public void removeObjective(Objective objective) {
        Objects.requireNonNull(objective);
        ((ServerScoreboardBridge)((Object)this)).bridge$removeObjective(objective);
    }

    @Override
    public Set<Score> scores() {
        HashSet<Score> scores = new HashSet<Score>();
        for (ScoreObjective objective : ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().values()) {
            scores.addAll(((ObjectiveBridge)objective).bridge$getSpongeObjective().scores().values());
        }
        return scores;
    }

    @Override
    public Set<Score> scores(Component name) {
        Objects.requireNonNull(name);
        HashSet<Score> scores = new HashSet<Score>();
        for (ScoreObjective objective : ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().values()) {
            ((ObjectiveBridge)objective).bridge$getSpongeObjective().findScore(name).ifPresent(scores::add);
        }
        return scores;
    }

    @Override
    public void removeScores(Component name) {
        Objects.requireNonNull(name);
        for (ScoreObjective objective : ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().values()) {
            SpongeObjective spongeObjective = ((ObjectiveBridge)objective).bridge$getSpongeObjective();
            spongeObjective.findScore(name).ifPresent(spongeObjective::removeScore);
        }
    }

    @Override
    @Intrinsic
    public Optional<Team> team(String name) {
        Objects.requireNonNull(name);
        return Optional.ofNullable((Team)((ScoreboardAccessor)((Object)this)).accessor$teamsByName().get(name));
    }

    @Override
    public void registerTeam(Team team) throws IllegalArgumentException {
        Objects.requireNonNull(team);
        ((ServerScoreboardBridge)((Object)this)).bridge$registerTeam(team);
    }

    @Override
    public Set<Team> teams() {
        return new HashSet<ScorePlayerTeam>(((ScoreboardAccessor)((Object)this)).accessor$teamsByName().values());
    }

    @Override
    public Optional<Team> memberTeam(Component member) {
        Objects.requireNonNull(member);
        return Optional.ofNullable((Team)((ScoreboardAccessor)((Object)this)).accessor$teamsByPlayer().get(LegacyComponentSerializer.legacySection().serialize(member)));
    }
}

