/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.level;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.world.server.ChunkManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.ChunkRegenerateFlag;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.Ticket;
import org.spongepowered.api.world.server.TicketType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.server.ChunkMapBridge;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ChunkManager.class})
public abstract class ChunkMapMixin_API
implements org.spongepowered.api.world.server.ChunkManager {
    @Shadow
    @Final
    private net.minecraft.world.server.ServerWorld field_219255_i;

    @Override
    public @NonNull ServerWorld world() {
        return (ServerWorld)this.field_219255_i;
    }

    @Override
    public boolean valid(@NonNull Ticket<?> ticket) {
        return ((ChunkMapBridge)((Object)this)).bridge$distanceManager().bridge$checkTicketValid(ticket);
    }

    @Override
    public @NonNull Ticks timeLeft(@NonNull Ticket<?> ticket) {
        return ((ChunkMapBridge)((Object)this)).bridge$distanceManager().bridge$timeLeft(ticket);
    }

    @Override
    public <T> @NonNull Optional<Ticket<T>> requestTicket(@NonNull TicketType<T> type, @NonNull Vector3i chunkPosition, @NonNull T value, int radius) {
        if (!(type instanceof net.minecraft.world.server.TicketType)) {
            throw new IllegalArgumentException("TicketType must be a Minecraft TicketType");
        }
        if (radius < 1) {
            throw new IllegalArgumentException("The radius must be positive.");
        }
        return ((ChunkMapBridge)((Object)this)).bridge$distanceManager().bridge$registerTicket(this.world(), type, chunkPosition, value, radius);
    }

    @Override
    public boolean renewTicket(@NonNull Ticket<?> ticket) {
        return ((ChunkMapBridge)((Object)this)).bridge$distanceManager().bridge$renewTicket(ticket);
    }

    @Override
    public boolean releaseTicket(@NonNull Ticket<?> ticket) {
        return ((ChunkMapBridge)((Object)this)).bridge$distanceManager().bridge$releaseTicket(ticket);
    }

    @Override
    public <T> @NonNull Collection<Ticket<T>> findTickets(@NonNull TicketType<T> type) {
        return ((ChunkMapBridge)((Object)this)).bridge$distanceManager().bridge$tickets(type);
    }

    @Override
    public @NonNull CompletableFuture<Boolean> regenerateChunk(int cx, int cy, int cz, @NonNull ChunkRegenerateFlag flag) {
        CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
        cf.completeExceptionally(new MissingImplementationException("ServerWorld", "regenerateChunk"));
        return cf;
    }
}

