/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointers;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.raid.RaidManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerWorldInfo;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.scheduler.ScheduledUpdateList;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.server.ChunkManager;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.entity.raid.RaidsAccessor;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.data.holder.SpongeLocationBaseDataHolder;
import org.spongepowered.common.mixin.api.minecraft.world.level.LevelMixin_API;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeWorldTemplate;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={net.minecraft.world.server.ServerWorld.class})
public abstract class ServerLevelMixin_API
extends LevelMixin_API<ServerWorld, ServerLocation>
implements ServerWorld,
SpongeLocationBaseDataHolder {
    @Shadow
    @Final
    private ServerTickList<Block> field_94579_S;
    @Shadow
    @Final
    private ServerTickList<Fluid> field_205342_P;
    @Shadow
    @Final
    private Int2ObjectMap<net.minecraft.entity.Entity> field_217498_x;
    @Shadow
    @Final
    private IServerWorldInfo field_241103_E_;
    private volatile @MonotonicNonNull Pointers api$pointers;

    @Shadow
    public abstract void shadow$func_217445_a(@Nullable IProgressUpdate var1, boolean var2, boolean var3);

    @Shadow
    public abstract void shadow$func_217466_a(Chunk var1);

    @Override
    @Shadow
    public abstract void shadow$func_184148_a(@Nullable PlayerEntity var1, double var2, double var4, double var6, SoundEvent var8, SoundCategory var9, float var10, float var11);

    @Shadow
    public abstract ServerChunkProvider shadow$func_72863_F();

    @Override
    @Nonnull
    @Shadow
    public abstract MinecraftServer shadow$func_73046_m();

    @Nullable
    @Shadow
    public abstract net.minecraft.entity.Entity shadow$func_217461_a(UUID var1);

    @Shadow
    public abstract List<ServerPlayerEntity> shadow$func_217369_A();

    @Shadow
    public abstract RaidManager shadow$func_217452_C();

    @Nullable
    @Shadow
    public abstract Raid shadow$func_217475_c_(BlockPos var1);

    @Shadow
    public abstract long shadow$func_72905_C();

    @Override
    public long seed() {
        return this.shadow$func_72905_C();
    }

    @Override
    public boolean isLoaded() {
        return ((ServerLevelBridge)((Object)this)).bridge$isLoaded();
    }

    @NotNull
    public Pointers pointers() {
        if (this.api$pointers == null) {
            this.api$pointers = (Pointers)Pointers.builder().withDynamic(Identity.UUID, this::uniqueId).withDynamic(Identity.NAME, () -> this.key().formatted()).withDynamic(Identity.DISPLAY_NAME, () -> this.properties().displayName().orElse(null)).build();
            return this.api$pointers;
        }
        return this.api$pointers;
    }

    @Override
    public ServerLocation location(Vector3i position) {
        return ServerLocation.of((ServerWorld)this, Objects.requireNonNull(position, "position"));
    }

    @Override
    public ServerLocation location(Vector3d position) {
        return ServerLocation.of((ServerWorld)this, Objects.requireNonNull(position, "position"));
    }

    @Override
    public ServerWorldProperties properties() {
        return (ServerWorldProperties)this.shadow$func_72912_H();
    }

    @Override
    public ChunkGenerator generator() {
        return (ChunkGenerator)this.shadow$func_72863_F().func_201711_g();
    }

    @Override
    public WorldTemplate asTemplate() {
        return new SpongeWorldTemplate((net.minecraft.world.server.ServerWorld)this);
    }

    @Override
    public ResourceKey key() {
        return (ResourceKey)this.shadow$func_234923_W_().func_240901_a_();
    }

    @Override
    public Server engine() {
        return (Server)this.shadow$func_73046_m();
    }

    @Override
    public BlockSnapshot createSnapshot(int x, int y, int z) {
        return ((ServerLevelBridge)((Object)this)).bridge$createSnapshot(x, y, z);
    }

    @Override
    public boolean restoreSnapshot(BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return snapshot.restore(force, Objects.requireNonNull(flag, "flag"));
    }

    @Override
    public boolean restoreSnapshot(int x, int y, int z, BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return ((BlockSnapshot)Objects.requireNonNull(snapshot, "snapshot").withLocation((ServerLocation)this.location(x, y, z))).restore(force, Objects.requireNonNull(flag, "flag"));
    }

    @Override
    public Path directory() {
        return ((ServerLevelBridge)((Object)this)).bridge$getLevelSave().func_237285_a_(FolderName.field_237253_i_);
    }

    @Override
    public boolean save() throws IOException {
        ((ServerLevelBridge)((Object)this)).bridge$setManualSave(true);
        this.shadow$func_217445_a(null, false, true);
        return true;
    }

    @Override
    public boolean unloadChunk(WorldChunk chunk) {
        this.shadow$func_217466_a((Chunk)Objects.requireNonNull(chunk, "chunk"));
        return true;
    }

    @Override
    public void triggerExplosion(Explosion explosion) {
        ((ServerLevelBridge)((Object)this)).bridge$triggerExplosion(Objects.requireNonNull(explosion, "explosion"));
    }

    @Override
    public Collection<ServerPlayer> players() {
        return Collections.unmodifiableCollection(ImmutableList.copyOf(this.shadow$func_217369_A()));
    }

    public Collection<Entity> entities() {
        return (Collection)ImmutableList.copyOf((Collection)this.field_217498_x.values());
    }

    @Override
    public Collection<org.spongepowered.api.raid.Raid> raids() {
        return ((RaidsAccessor)this.shadow$func_217452_C()).accessor$raidMap().values();
    }

    @Override
    public Optional<org.spongepowered.api.raid.Raid> raidAt(Vector3i blockPosition) {
        return Optional.ofNullable((org.spongepowered.api.raid.Raid)this.shadow$func_217475_c_(VecHelper.toBlockPos(Objects.requireNonNull(blockPosition, "blockPosition"))));
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return World.func_175701_a((BlockPos)new BlockPos(x, y, z));
    }

    @Override
    public Optional<Entity> entity(UUID uniqueId) {
        return Optional.ofNullable((Entity)this.shadow$func_217461_a(Objects.requireNonNull(uniqueId, "uniqueId")));
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.blockEntity(x, y, z).ifPresent(ignored -> this.removeBlock(x, y, z));
    }

    @Override
    public ScheduledUpdateList<BlockType> scheduledBlockUpdates() {
        return (ScheduledUpdateList)this.field_94579_S;
    }

    @Override
    public ScheduledUpdateList<FluidType> scheduledFluidUpdates() {
        return (ScheduledUpdateList)this.field_205342_P;
    }

    @Override
    public ServerLocation impl$dataholder(int x, int y, int z) {
        return ServerLocation.of((ServerWorld)this, x, y, z);
    }

    @Override
    public Weather weather() {
        return ((ServerWorldProperties)this.shadow$func_72912_H()).weather();
    }

    @Override
    public void setWeather(WeatherType type) {
        ((ServerWorldProperties)this.shadow$func_72912_H()).setWeather(Objects.requireNonNull(type, "type"));
    }

    @Override
    public void setWeather(WeatherType type, Ticks ticks) {
        ((ServerWorldProperties)this.shadow$func_72912_H()).setWeather(Objects.requireNonNull(type, "type"), Objects.requireNonNull(ticks, "ticks"));
    }

    @Override
    public ChunkLayout chunkLayout() {
        return SpongeChunkLayout.INSTANCE;
    }

    @Override
    public WorldBorder setBorder(WorldBorder border) {
        WorldBorder worldBorder = ((WorldBorderBridge)((ICollisionReader)this).func_175723_af()).bridge$applyFrom(border);
        if (worldBorder == null) {
            return (WorldBorder)net.minecraft.world.border.WorldBorder.field_235925_b_;
        }
        this.field_241103_E_.func_230393_a_((WorldBorder.Serializer)border);
        return worldBorder;
    }

    @Override
    public ChunkManager chunkManager() {
        return (ChunkManager)this.shadow$func_72863_F().field_217237_a;
    }
}

