/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.level;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.network.play.server.SSendResourcePackPacket;
import net.minecraft.network.play.server.SSpawnMovingSoundEffectPacket;
import net.minecraft.network.play.server.SStopSoundPacket;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.network.play.server.SWorldBorderPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.server.ServerBossInfo;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.SetValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.CooldownTracker;
import org.spongepowered.api.entity.living.player.PlayerChatFormatter;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.message.PlayerChatEvent;
import org.spongepowered.api.event.world.ChangeWorldBorderEvent;
import org.spongepowered.api.network.ServerPlayerConnection;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.world.level.border.WorldBorderAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.server.PlayerAdvancementsBridge;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.effect.particle.SpongeParticleHelper;
import org.spongepowered.common.effect.record.SpongeMusicDisc;
import org.spongepowered.common.entity.player.SpongeUserView;
import org.spongepowered.common.entity.player.tab.SpongeTabList;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.api.minecraft.world.entity.player.PlayerMixin_API;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.resourcepack.SpongeResourcePack;
import org.spongepowered.common.util.BookUtil;
import org.spongepowered.common.util.NetworkUtil;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerMixin_API
extends PlayerMixin_API
implements ServerPlayer {
    @Shadow
    @Final
    public MinecraftServer field_71133_b;
    @Shadow
    @Final
    private PlayerAdvancements field_192042_bX;
    @Shadow
    public ServerPlayNetHandler field_71135_a;
    private volatile Pointers api$pointers;
    private final TabList api$tabList = new SpongeTabList((ServerPlayerEntity)this);
    @Nullable
    private PlayerChatFormatter api$chatRouter;
    @Nullable
    private WorldBorderBridge api$worldBorder;

    @Shadow
    public abstract net.minecraft.world.server.ServerWorld shadow$func_71121_q();

    @Override
    public ServerWorld world() {
        return (ServerWorld)this.shadow$func_71121_q();
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, org.spongepowered.math.vector.Vector3d position, int radius) {
        if (this.impl$isFake) {
            return;
        }
        Objects.requireNonNull(particleEffect, "particleEffect");
        Objects.requireNonNull(position, "position");
        if (radius <= 0) {
            throw new IllegalArgumentException("The radius has to be greater then zero!");
        }
        List<IPacket<?>> packets = SpongeParticleHelper.toPackets(particleEffect, position);
        if (!packets.isEmpty() && position.sub(this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_()).lengthSquared() < (double)((long)radius * (long)radius)) {
            for (IPacket<?> packet : packets) {
                this.field_71135_a.func_147359_a(packet);
            }
        }
    }

    @Override
    public User user() {
        return SpongeUserView.create(this.field_96093_i);
    }

    @Override
    public boolean isOnline() {
        if (this.impl$isFake) {
            return true;
        }
        return this.field_71133_b.func_184103_al().func_177451_a(this.field_96093_i) == (ServerPlayerEntity)this;
    }

    @Override
    public GameProfile profile() {
        return SpongeGameProfile.of(this.shadow$func_146103_bH());
    }

    @Override
    public void sendWorldType(WorldType worldType) {
        if (this.impl$isFake) {
            return;
        }
        ((ServerPlayerBridge)((Object)this)).bridge$sendViewerEnvironment((DimensionType)Objects.requireNonNull(worldType, "worldType"));
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, org.spongepowered.math.vector.Vector3d position) {
        if (this.impl$isFake) {
            return;
        }
        this.spawnParticles(particleEffect, position, Integer.MAX_VALUE);
    }

    @Override
    public ServerPlayerConnection connection() {
        return (ServerPlayerConnection)this.field_71135_a;
    }

    @Overwrite
    public String func_71114_r() {
        return NetworkUtil.getHostString(this.field_71135_a.field_147371_a.func_74430_c());
    }

    @Override
    public String identifier() {
        return this.field_96093_i.toString();
    }

    @Override
    public void setScoreboard(Scoreboard scoreboard) {
        Objects.requireNonNull(scoreboard, "scoreboard");
        ((ServerScoreboardBridge)((Object)((ServerPlayerBridge)((Object)this)).bridge$getScoreboard())).bridge$removePlayer((ServerPlayerEntity)this, true);
        ((ServerPlayerBridge)((Object)this)).bridge$replaceScoreboard(scoreboard);
        ((ServerScoreboardBridge)((Object)((ServerPlayerBridge)((Object)this)).bridge$getScoreboard())).bridge$addPlayer((ServerPlayerEntity)this, true);
    }

    @Override
    public Component teamRepresentation() {
        return SpongeAdventure.asAdventure(this.shadow$func_200200_C_());
    }

    @Override
    public Scoreboard scoreboard() {
        return ((ServerPlayerBridge)((Object)this)).bridge$getScoreboard();
    }

    @Override
    public boolean kick() {
        return this.kick((Component)Component.translatable((String)"disconnect.disconnected"));
    }

    @Override
    public boolean kick(Component message) {
        return ((ServerPlayerBridge)((Object)this)).bridge$kick(Objects.requireNonNull(message, "message"));
    }

    @Override
    public void playMusicDisc(Vector3i position, MusicDisc recordType) {
        this.field_71135_a.func_147359_a((IPacket)SpongeMusicDisc.createPacket(Objects.requireNonNull(position, "position"), Objects.requireNonNull(recordType, "recordType")));
    }

    @Override
    public void stopMusicDisc(Vector3i position) {
        this.field_71135_a.func_147359_a((IPacket)SpongeMusicDisc.createPacket(position, null));
    }

    @Override
    public void sendResourcePack(ResourcePack pack) {
        this.field_71135_a.func_147359_a((IPacket)new SSendResourcePackPacket(((SpongeResourcePack)Objects.requireNonNull(pack, "pack")).getUrlString(), pack.hash().orElse("")));
    }

    @Override
    public TabList tabList() {
        return this.api$tabList;
    }

    @Override
    public boolean hasPlayedBefore() {
        Instant instant = ((SpongeServer)this.shadow$func_184102_h()).getPlayerDataManager().getFirstJoined(this.uniqueId()).get();
        Instant toTheMinute = instant.truncatedTo(ChronoUnit.MINUTES);
        Instant now = Instant.now().truncatedTo(ChronoUnit.MINUTES);
        Duration timeSinceFirstJoined = Duration.of(now.minusMillis(toTheMinute.toEpochMilli()).toEpochMilli(), ChronoUnit.MINUTES);
        return timeSinceFirstJoined.getSeconds() > 0L;
    }

    @Override
    public void sendBlockChange(int x, int y, int z, BlockState state) {
        this.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket(new BlockPos(x, y, z), (net.minecraft.block.BlockState)state));
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        this.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)this.shadow$func_130014_f_(), new BlockPos(x, y, z)));
    }

    @Override
    public boolean respawn() {
        if (this.impl$isFake) {
            return false;
        }
        if (this.shadow$func_110143_aJ() > 0.0f) {
            return false;
        }
        this.field_71135_a.field_147369_b = this.field_71133_b.func_184103_al().func_232644_a_((ServerPlayerEntity)this, false);
        return true;
    }

    @Override
    public PlayerChatFormatter chatFormatter() {
        if (this.api$chatRouter == null) {
            this.api$chatRouter = (player, audience, message, originalMessage) -> Optional.of(Component.translatable((String)"chat.type.text", (ComponentLike[])new ComponentLike[]{SpongeAdventure.asAdventure(this.shadow$func_145748_c_()), message}));
        }
        return this.api$chatRouter;
    }

    @Override
    public void setChatFormatter(PlayerChatFormatter router) {
        this.api$chatRouter = Objects.requireNonNull(router, "router");
    }

    @Override
    public PlayerChatEvent simulateChat(Component message, Cause cause) {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(cause, "cause");
        PlayerChatFormatter originalRouter = this.chatFormatter();
        Audience audience = (Audience)this.field_71133_b;
        PlayerChatEvent event = SpongeEventFactory.createPlayerChatEvent(cause, audience, Optional.of(audience), originalRouter, Optional.of(originalRouter), message, message);
        if (!SpongeCommon.post(event)) {
            event.chatFormatter().ifPresent(formatter -> event.audience().map(SpongeAdventure::unpackAudiences).ifPresent(targets -> {
                for (Audience target : targets) {
                    formatter.format(this, target, event.message(), event.originalMessage()).ifPresent(formattedMessage -> target.sendMessage((Identified)this, formattedMessage));
                }
            }));
        }
        return event;
    }

    @Override
    public @NonNull Optional<org.spongepowered.api.world.border.WorldBorder> worldBorder() {
        if (this.api$worldBorder == null) {
            return Optional.empty();
        }
        return Optional.of(this.api$worldBorder.bridge$asImmutable());
    }

    @Override
    public CooldownTracker cooldownTracker() {
        return (CooldownTracker)this.shadow$func_184811_cZ();
    }

    @Override
    public AdvancementProgress progress(org.spongepowered.api.advancement.Advancement advancement) {
        return (AdvancementProgress)this.field_192042_bX.func_192747_a((Advancement)Objects.requireNonNull(advancement, "advancement"));
    }

    @Override
    public Collection<AdvancementTree> unlockedAdvancementTrees() {
        if (this.impl$isFake) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(((PlayerAdvancementsBridge)this.field_192042_bX).bridge$getAdvancementTrees());
    }

    @Override
    public @NonNull Optional<org.spongepowered.api.world.border.WorldBorder> setWorldBorder(@Nullable org.spongepowered.api.world.border.WorldBorder border) {
        Optional<org.spongepowered.api.world.border.WorldBorder> toSet;
        if (this.impl$isFake) {
            return Optional.empty();
        }
        Optional<org.spongepowered.api.world.border.WorldBorder> currentBorder = this.worldBorder();
        if (Objects.equals(currentBorder.orElse(null), border)) {
            return currentBorder;
        }
        ChangeWorldBorderEvent.Player event = SpongeEventFactory.createChangeWorldBorderEventPlayer(PhaseTracker.getCauseStackManager().currentCause(), Optional.ofNullable(border), Optional.ofNullable(border), this, Optional.ofNullable(border));
        if (SpongeCommon.post(event)) {
            return currentBorder;
        }
        if (this.api$worldBorder != null) {
            ((WorldBorderAccessor)((Object)this.api$worldBorder)).accessor$listeners().remove(((ServerPlayerBridge)((Object)this)).bridge$getWorldBorderListener());
        }
        if ((toSet = event.newBorder()).isPresent()) {
            WorldBorder mutableWorldBorder = new WorldBorder();
            this.api$worldBorder = (WorldBorderBridge)mutableWorldBorder;
            this.api$worldBorder.bridge$applyFrom(toSet.get());
            mutableWorldBorder.func_177737_a((IBorderListener)((ServerPlayerBridge)((Object)this)).bridge$getWorldBorderListener());
            this.field_71135_a.func_147359_a((IPacket)new SWorldBorderPacket((WorldBorder)this.api$worldBorder, SWorldBorderPacket.Action.INITIALIZE));
        } else {
            this.api$worldBorder = null;
            this.field_71135_a.func_147359_a((IPacket)new SWorldBorderPacket(this.shadow$func_130014_f_().func_175723_af(), SWorldBorderPacket.Action.INITIALIZE));
        }
        return toSet;
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.requireValue(Keys.CHAT_COLORS_ENABLED).asImmutable());
        values.add(this.requireValue(Keys.CHAT_VISIBILITY).asImmutable());
        values.add(this.requireValue(Keys.GAME_MODE).asImmutable());
        values.add(this.requireValue(Keys.HAS_VIEWED_CREDITS).asImmutable());
        values.add(this.requireValue(Keys.LOCALE).asImmutable());
        values.add(((SetValue)this.requireValue(Keys.SKIN_PARTS)).asImmutable());
        values.add(this.requireValue(Keys.SPECTATOR_TARGET).asImmutable());
        values.add(this.requireValue(Keys.VIEW_DISTANCE).asImmutable());
        this.getValue(Keys.HEALTH_SCALE).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.SKIN_PROFILE_PROPERTY).map(Value::asImmutable).ifPresent(values::add);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Pointers pointers() {
        Pointers pointers = this.api$pointers;
        if (pointers == null) {
            ServerPlayerMixin_API serverPlayerMixin_API = this;
            synchronized (serverPlayerMixin_API) {
                if (this.api$pointers != null) {
                    return this.api$pointers;
                }
                this.api$pointers = pointers = (Pointers)Pointers.builder().withDynamic(Identity.NAME, () -> ((ServerPlayerEntity)this).func_146103_bH().getName()).withDynamic(Identity.DISPLAY_NAME, () -> (Component)this.displayName().get()).withDynamic(Identity.UUID, () -> ((net.minecraft.entity.Entity)((net.minecraft.entity.Entity)this)).func_110124_au()).withDynamic(Identity.LOCALE, this::locale).withStatic(PermissionChecker.POINTER, permission -> SpongeAdventure.asAdventure(this.permissionValue(permission))).build();
            }
        }
        return pointers;
    }

    public void sendMessage(Identity identity, Component message, MessageType type) {
        if (this.impl$isFake) {
            return;
        }
        this.field_71135_a.func_147359_a((IPacket)new SChatPacket(SpongeAdventure.asVanilla(Objects.requireNonNull(message, "message")), SpongeAdventure.asVanilla(Objects.requireNonNull(type, "type")), Objects.requireNonNull(identity, "identity").uuid()));
    }

    public void sendActionBar(Component message) {
        if (this.impl$isFake) {
            return;
        }
        this.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.ACTIONBAR, SpongeAdventure.asVanilla(Objects.requireNonNull(message, "message"))));
    }

    public void sendPlayerListHeader(Component header) {
        this.api$tabList.setHeader(Objects.requireNonNull(header, "header"));
    }

    public void sendPlayerListFooter(Component footer) {
        this.api$tabList.setFooter(Objects.requireNonNull(footer, "footer"));
    }

    public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
        this.api$tabList.setHeaderAndFooter(Objects.requireNonNull(header, "header"), Objects.requireNonNull(footer, "footer"));
    }

    public void showTitle(Title title) {
        if (this.impl$isFake) {
            return;
        }
        Title.Times times = Objects.requireNonNull(title, "title").times();
        if (times != null) {
            this.field_71135_a.func_147359_a((IPacket)new STitlePacket(this.api$durationToTicks(times.fadeIn()), this.api$durationToTicks(times.stay()), this.api$durationToTicks(times.fadeOut())));
        }
        this.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.SUBTITLE, SpongeAdventure.asVanilla(title.subtitle())));
        this.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.TITLE, SpongeAdventure.asVanilla(title.title())));
    }

    public <T> void sendTitlePart(@NotNull TitlePart<T> part, @NotNull T value) {
        if (this.impl$isFake) {
            return;
        }
        Objects.requireNonNull(value, "value");
        if (part == TitlePart.TITLE) {
            this.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.TITLE, SpongeAdventure.asVanilla((Component)value)));
        } else if (part == TitlePart.SUBTITLE) {
            this.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.SUBTITLE, SpongeAdventure.asVanilla((Component)value)));
        } else if (part == TitlePart.TIMES) {
            Title.Times times = (Title.Times)value;
            this.field_71135_a.func_147359_a((IPacket)new STitlePacket(this.api$durationToTicks(times.fadeIn()), this.api$durationToTicks(times.stay()), this.api$durationToTicks(times.fadeOut())));
        } else {
            throw new IllegalArgumentException("Unknown TitlePart '" + part + "'");
        }
    }

    public void clearTitle() {
        if (this.impl$isFake) {
            return;
        }
        this.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.CLEAR, null));
    }

    public void resetTitle() {
        if (this.impl$isFake) {
            return;
        }
        this.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.RESET, null));
    }

    public void showBossBar(BossBar bar) {
        if (this.impl$isFake) {
            return;
        }
        ServerBossInfo vanilla = SpongeAdventure.asVanillaServer(Objects.requireNonNull(bar, "bar"));
        vanilla.func_186760_a((ServerPlayerEntity)this);
    }

    public void hideBossBar(BossBar bar) {
        if (this.impl$isFake) {
            return;
        }
        ServerBossInfo vanilla = SpongeAdventure.asVanillaServer(Objects.requireNonNull(bar, "bar"));
        vanilla.func_186761_b((ServerPlayerEntity)this);
    }

    public void playSound(Sound sound) {
        this.playSound(Objects.requireNonNull(sound, "sound"), this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_());
    }

    public void playSound(@NonNull Sound sound, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Sound.Emitter emitter) {
        Objects.requireNonNull(sound, "sound");
        Objects.requireNonNull(emitter, "emitter");
        if (this.impl$isFake) {
            return;
        }
        Optional event = Registry.field_212633_v.func_241873_b(SpongeAdventure.asVanilla(Objects.requireNonNull(sound, "sound").name()));
        if (event.isPresent()) {
            net.minecraft.entity.Entity tracked;
            if (emitter == Sound.Emitter.self()) {
                tracked = (net.minecraft.entity.Entity)this;
            } else if (emitter instanceof Entity) {
                tracked = (net.minecraft.entity.Entity)emitter;
            } else {
                throw new IllegalArgumentException("Specified emitter '" + emitter + "' is not a Sponge Entity or Emitter.self(), was of type '" + emitter.getClass() + "'");
            }
            this.field_71135_a.func_147359_a((IPacket)new SSpawnMovingSoundEffectPacket((SoundEvent)event.get(), SpongeAdventure.asVanilla(sound.source()), tracked, sound.volume(), sound.pitch()));
        }
    }

    public void playSound(Sound sound, double x, double y, double z) {
        if (this.impl$isFake) {
            return;
        }
        Optional event = Registry.field_212633_v.func_241873_b(SpongeAdventure.asVanilla(Objects.requireNonNull(sound, "sound").name()));
        if (event.isPresent()) {
            this.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket((SoundEvent)event.get(), SpongeAdventure.asVanilla(sound.source()), x, y, z, sound.volume(), sound.pitch()));
        } else {
            this.field_71135_a.func_147359_a((IPacket)new SPlaySoundPacket(SpongeAdventure.asVanilla(sound.name()), SpongeAdventure.asVanilla(sound.source()), new Vector3d(x, y, z), sound.volume(), sound.pitch()));
        }
    }

    public void stopSound(SoundStop stop) {
        if (this.impl$isFake) {
            return;
        }
        this.field_71135_a.func_147359_a((IPacket)new SStopSoundPacket(SpongeAdventure.asVanillaNullable(Objects.requireNonNull(stop, "stop").sound()), SpongeAdventure.asVanillaNullable(stop.source())));
    }

    public void openBook(@NonNull Book book) {
        if (this.impl$isFake) {
            return;
        }
        BookUtil.fakeBookView(Objects.requireNonNull(book, "book"), Collections.singletonList(this));
    }

    @Override
    public @NonNull Locale locale() {
        return ((ServerPlayerBridge)((Object)this)).bridge$getLanguage();
    }

    private int api$durationToTicks(Duration duration) {
        return (int)(duration.toMillis() / 50L);
    }
}

