/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.level;

import java.util.List;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.generation.GenerationChunk;
import org.spongepowered.api.world.generation.GenerationRegion;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={WorldGenRegion.class})
public abstract class WorldGenRegionMixin_API
implements GenerationRegion {
    @Shadow
    @Final
    private ChunkPos field_241160_n_;
    @Shadow
    @Final
    private ChunkPos field_241161_o_;
    private ResourceKey api$serverWorldKey;
    private @MonotonicNonNull Vector3i api$minBlock;
    private @MonotonicNonNull Vector3i api$maxBlock;
    private @MonotonicNonNull Vector3i api$size;

    @Shadow
    public abstract IChunk shadow$func_212866_a_(int var1, int var2);

    @Inject(method={"<init>(Lnet/minecraft/world/server/ServerWorld;Ljava/util/List;)V"}, at={@At(value="RETURN")})
    private void api$getWorldKeyOnConstruction(ServerWorld param0, List<IChunk> param1, CallbackInfo ci) {
        this.api$serverWorldKey = (ResourceKey)param0.func_234923_W_().func_240901_a_();
    }

    @Override
    public @NonNull ResourceKey worldKey() {
        return this.api$serverWorldKey;
    }

    @Override
    public @NonNull Server engine() {
        return SpongeCommon.game().server();
    }

    @Override
    public @NonNull GenerationChunk chunk(int cx, int cy, int cz) {
        IChunk chunk;
        try {
            chunk = this.shadow$func_212866_a_(cx, cz);
        }
        catch (RuntimeException exception) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Chunk coordinates (%d, %d, %d) is out of bounds.", cx, cy, cz));
        }
        if (chunk instanceof Chunk) {
            return (GenerationChunk)new ChunkPrimerWrapper((Chunk)chunk);
        }
        return (GenerationChunk)chunk;
    }

    @Override
    public @NonNull Vector3i chunkMin() {
        return VecHelper.toVector3i(this.field_241160_n_).min(VecHelper.toVector3i(this.field_241161_o_));
    }

    @Override
    public @NonNull Vector3i chunkMax() {
        return VecHelper.toVector3i(this.field_241160_n_).max(VecHelper.toVector3i(this.field_241161_o_));
    }

    @Override
    public @NonNull Vector3i min() {
        if (this.api$minBlock == null) {
            this.api$minBlock = this.convertToBlock(this.chunkMin(), false);
        }
        return this.api$minBlock;
    }

    @Override
    public @NonNull Vector3i max() {
        if (this.api$maxBlock == null) {
            this.api$maxBlock = this.convertToBlock(this.chunkMax(), true);
        }
        return this.api$maxBlock;
    }

    @Override
    public @NonNull Vector3i size() {
        if (this.api$size == null) {
            this.api$size = this.max().sub(this.min()).add(Vector3i.ONE);
        }
        return this.api$size;
    }

    @Override
    public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    private Vector3i convertToBlock(Vector3i chunk, boolean isMax) {
        Vector3i chunkMin = Sponge.server().chunkLayout().forceToWorld(chunk);
        if (isMax) {
            return chunkMin.add(SpongeChunkLayout.CHUNK_MASK);
        }
        return chunkMin;
    }
}

