/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.packs;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.resource.Resource;
import org.spongepowered.api.resource.ResourcePath;
import org.spongepowered.api.resource.pack.PackContents;
import org.spongepowered.api.resource.pack.PackType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.resource.SpongeResource;
import org.spongepowered.common.resource.SpongeResourcePath;

@Mixin(value={IResourcePack.class})
public interface PackResourcesMixin_API
extends PackContents {
    @Shadow
    public String shadow$func_195762_a();

    @Shadow
    public InputStream shadow$func_195761_a(ResourcePackType var1, ResourceLocation var2) throws IOException;

    @Shadow
    public boolean shadow$func_195764_b(ResourcePackType var1, ResourceLocation var2);

    @Shadow
    public Collection<ResourceLocation> shadow$func_225637_a_(ResourcePackType var1, String var2, String var3, int var4, Predicate<String> var5);

    @Shadow
    public Set<String> shadow$func_195759_a(ResourcePackType var1);

    @Override
    default public String name() {
        return this.shadow$func_195762_a();
    }

    @Override
    default public Optional<Resource> resource(PackType root, ResourcePath path) throws IOException {
        return Optional.ofNullable(this.api$createResource(root, path));
    }

    @Override
    default public Resource requireResource(PackType root, ResourcePath path) throws IOException {
        Resource resource = this.api$createResource(root, path);
        if (resource == null) {
            throw new NoSuchElementException(MessageFormat.format("Pack type {} does not contain a resource at {}", root, path));
        }
        return resource;
    }

    default public @Nullable Resource api$createResource(PackType root, ResourcePath path) throws IOException {
        return new SpongeResource(Objects.requireNonNull(path, "path"), this.shadow$func_195761_a((ResourcePackType)Objects.requireNonNull(root, "root"), (ResourceLocation)path.key()));
    }

    @Override
    default public Collection<ResourcePath> paths(PackType root, String namespace, String prefix, int depth, Predicate<String> filter) {
        Collection<ResourceLocation> resources = this.shadow$func_225637_a_((ResourcePackType)Objects.requireNonNull(root, "root"), Objects.requireNonNull(namespace, "namespace"), Objects.requireNonNull(prefix, "prefix"), depth, Objects.requireNonNull(filter, "filter"));
        return resources.stream().map(r -> new SpongeResourcePath((ResourceKey)r)).collect(Collectors.toList());
    }

    @Override
    default public boolean exists(PackType root, ResourcePath path) {
        return this.shadow$func_195764_b((ResourcePackType)Objects.requireNonNull(root, "root"), (ResourceLocation)Objects.requireNonNull(path, "path").key());
    }

    @Override
    default public Set<String> namespaces(PackType root) {
        return this.shadow$func_195759_a((ResourcePackType)Objects.requireNonNull(root, "root"));
    }
}

