/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.rcon;

import java.net.InetSocketAddress;
import java.util.UUID;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.text.Component;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.util.text.ITextComponent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.network.RconConnection;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.server.rcon.thread.RconClientAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.server.rcon.RconConsoleSourceBridge;

@Mixin(value={RConConsoleSource.class})
public abstract class RconConsoleSourceMixin_API
implements RconConsoleSourceBridge,
RconConnection {
    private static final String API$IDENTIFIER = "Recon";
    private static final Pointers API$POINTERS = (Pointers)Pointers.builder().withStatic(Identity.NAME, (Object)"Recon").build();

    @Shadow
    public abstract void shadow$func_145747_a(ITextComponent var1, UUID var2);

    @Override
    public String identifier() {
        return API$IDENTIFIER;
    }

    @Override
    public boolean isAuthorized() {
        return ((RconClientAccessor)this.bridge$getClient()).accessor$authed();
    }

    @Override
    public void setAuthorized(boolean authorized) {
        ((RconClientAccessor)this.bridge$getClient()).accessor$authed(authorized);
    }

    @Override
    public InetSocketAddress address() {
        return ((RemoteConnection)this.bridge$getClient()).address();
    }

    @Override
    public InetSocketAddress virtualHost() {
        return ((RemoteConnection)this.bridge$getClient()).virtualHost();
    }

    @Override
    public void close() {
        ((RemoteConnection)this.bridge$getClient()).close();
    }

    public void sendMessage(@NonNull Identity identity, @NonNull Component message, @NonNull MessageType type) {
        this.shadow$func_145747_a(SpongeAdventure.asVanilla(message), identity.uuid());
    }

    @NotNull
    public Pointers pointers() {
        return API$POINTERS;
    }
}

