/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.entity;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.data.value.SetValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Transform;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={net.minecraft.entity.Entity.class})
@Implements(value={@Interface(iface=Entity.class, prefix="entity$", remap=Interface.Remap.NONE)})
public abstract class EntityMixin_API
implements Entity {
    @Shadow
    public float field_70177_z;
    @Shadow
    public float field_70125_A;
    @Shadow
    public boolean field_70128_L;
    @Shadow
    @Final
    protected Random field_70146_Z;
    @Shadow
    public int field_70173_aa;
    @Shadow
    protected UUID field_96093_i;
    @Shadow
    @Final
    private net.minecraft.entity.EntityType<?> field_200606_g;
    @Shadow
    public net.minecraft.world.World field_70170_p;

    @Shadow
    public abstract double shadow$func_226277_ct_();

    @Shadow
    public abstract double shadow$func_226278_cu_();

    @Shadow
    public abstract double shadow$func_226281_cx_();

    @Shadow
    public abstract net.minecraft.world.World shadow$func_130014_f_();

    @Shadow
    @Nullable
    public abstract MinecraftServer shadow$func_184102_h();

    @Shadow
    public abstract void shadow$func_70106_y();

    @Shadow
    public abstract UUID shadow$func_110124_au();

    @Shadow
    public abstract void shadow$func_241209_g_(int var1);

    @Shadow
    public abstract boolean shadow$func_70097_a(DamageSource var1, float var2);

    @Shadow
    public abstract int shadow$func_145782_y();

    @Shadow
    public abstract void shadow$func_184185_a(SoundEvent var1, float var2, float var3);

    @Shadow
    protected abstract void shadow$func_70101_b(float var1, float var2);

    @Shadow
    public abstract AxisAlignedBB shadow$func_174813_aQ();

    @Shadow
    public abstract boolean shadow$func_184198_c(CompoundNBT var1);

    @Shadow
    @Nullable
    public abstract ITextComponent shadow$func_200201_e();

    @Shadow
    public abstract ITextComponent shadow$func_145748_c_();

    @Shadow
    public abstract void shadow$func_200602_a(EntityAnchorArgument.Type var1, Vector3d var2);

    @Override
    public Random random() {
        return this.field_70146_Z;
    }

    @Override
    public org.spongepowered.math.vector.Vector3d position() {
        return new org.spongepowered.math.vector.Vector3d(this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_());
    }

    @Override
    public boolean setPosition(org.spongepowered.math.vector.Vector3d position) {
        return ((EntityBridge)((Object)this)).bridge$setPosition(Objects.requireNonNull(position, "The position was null!"));
    }

    @Override
    public World<?, ?> world() {
        return (World)this.field_70170_p;
    }

    public ServerLocation location() {
        return ServerLocation.of((ServerWorld)this.shadow$func_130014_f_(), this.position());
    }

    @Override
    public boolean setLocation(ServerLocation location) {
        return ((EntityBridge)((Object)this)).bridge$setLocation(Objects.requireNonNull(location, "The location was null!"));
    }

    @Override
    public boolean setLocationAndRotation(ServerLocation location, org.spongepowered.math.vector.Vector3d rotation) {
        if (this.setLocation(location)) {
            this.setRotation(rotation);
            return true;
        }
        return false;
    }

    @Override
    public org.spongepowered.math.vector.Vector3d scale() {
        return org.spongepowered.math.vector.Vector3d.ONE;
    }

    @Override
    public void setScale(org.spongepowered.math.vector.Vector3d scale) {
    }

    @Override
    public Transform transform() {
        return Transform.of(this.position(), this.rotation(), this.scale());
    }

    @Override
    public boolean setTransform(Transform transform) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            return false;
        }
        Objects.requireNonNull(transform, "The transform cannot be null!");
        if (((EntityBridge)((Object)this)).bridge$setPosition(transform.position())) {
            this.setRotation(transform.rotation());
            this.setScale(transform.scale());
            if (!((LevelBridge)this.shadow$func_130014_f_()).bridge$isFake()) {
                ((net.minecraft.world.server.ServerWorld)this.shadow$func_130014_f_()).func_217464_b((net.minecraft.entity.Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean transferToWorld(ServerWorld world, org.spongepowered.math.vector.Vector3d position) {
        Objects.requireNonNull(world, "World was null!");
        Objects.requireNonNull(position, "Position was null!");
        return this.setLocation(ServerLocation.of(world, position));
    }

    @Override
    public org.spongepowered.math.vector.Vector3d rotation() {
        return new org.spongepowered.math.vector.Vector3d(this.field_70125_A, this.field_70177_z, 0.0f);
    }

    @Override
    public void setRotation(org.spongepowered.math.vector.Vector3d rotation) {
        Objects.requireNonNull(rotation, "Rotation was null!");
        if (this.isRemoved()) {
            return;
        }
        if ((net.minecraft.entity.Entity)this instanceof ServerPlayerEntity && ((ServerPlayerEntity)this).field_71135_a != null) {
            ((ServerPlayerEntity)this).field_71135_a.func_175089_a(this.position().x(), this.position().y(), this.position().z(), (float)rotation.y(), (float)rotation.x(), EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class));
        } else {
            if (!this.shadow$func_130014_f_().field_72995_K) {
                ((ServerLevelBridge)((Object)this.world())).bridge$addEntityRotationUpdate((net.minecraft.entity.Entity)this, rotation);
            }
            this.shadow$func_70101_b((float)rotation.y(), (float)rotation.x());
        }
    }

    @Override
    public Optional<AABB> boundingBox() {
        AxisAlignedBB boundingBox = this.shadow$func_174813_aQ();
        if (boundingBox == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(VecHelper.toSpongeAABB(boundingBox));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    @Override
    public boolean isRemoved() {
        return this.field_70128_L;
    }

    @Override
    public boolean isLoaded() {
        return !this.isRemoved();
    }

    @Intrinsic
    public void entity$remove() {
        this.shadow$func_70106_y();
    }

    @Override
    public boolean damage(double damage, org.spongepowered.api.event.cause.entity.damage.source.DamageSource damageSource) {
        if (!(damageSource instanceof DamageSource)) {
            SpongeCommon.logger().error("An illegal DamageSource was provided in the cause! The damage source must extend AbstractDamageSource!");
            return false;
        }
        return this.shadow$func_70097_a((DamageSource)damageSource, (float)damage);
    }

    public EntityType type() {
        return (EntityType)this.field_200606_g;
    }

    @Override
    public UUID uniqueId() {
        return this.field_96093_i;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        CompoundNBT compound = new CompoundNBT();
        this.shadow$func_184198_c(compound);
        DataContainer unsafeNbt = NBTTranslator.INSTANCE.translateFrom(compound);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Entity.CLASS, this.getClass().getName()).set(Queries.WORLD_KEY, ((ServerWorld)this.world()).key().formatted()).createView(Constants.Sponge.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, this.position().x()).set(Queries.POSITION_Y, this.position().y()).set(Queries.POSITION_Z, this.position().z()).container().createView(Constants.Entity.ROTATION).set(Queries.POSITION_X, this.rotation().x()).set(Queries.POSITION_Y, this.rotation().y()).set(Queries.POSITION_Z, this.rotation().z()).container().createView(Constants.Entity.SCALE).set(Queries.POSITION_X, this.scale().x()).set(Queries.POSITION_Y, this.scale().y()).set(Queries.POSITION_Z, this.scale().z()).container().set(Constants.Entity.TYPE, Registry.field_212629_r.func_177774_c((Object)((net.minecraft.entity.EntityType)this.type()))).set(Constants.Sponge.UNSAFE_NBT, unsafeNbt);
        return container;
    }

    @Override
    public Entity copy() {
        if (this instanceof Player) {
            throw new IllegalArgumentException("Cannot copy player entities!");
        }
        try {
            CompoundNBT compound = new CompoundNBT();
            this.shadow$func_184198_c(compound);
            net.minecraft.entity.Entity entity = net.minecraft.entity.EntityType.func_220335_a((CompoundNBT)compound, (net.minecraft.world.World)this.shadow$func_130014_f_(), createdEntity -> {
                createdEntity.func_184221_a(UUID.randomUUID());
                return createdEntity;
            });
            return (Entity)entity;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not copy the entity:", e);
        }
    }

    @Override
    public boolean canSee(Entity entity) {
        return !((VanishableBridge)((Object)entity)).bridge$vanishState().invisible();
    }

    @Override
    public void lookAt(org.spongepowered.math.vector.Vector3d targetPos) {
        Vector3d vec = VecHelper.toVanillaVector3d(targetPos);
        this.shadow$func_200602_a(EntityAnchorArgument.Type.EYES, vec);
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.api$getVanillaValues();
    }

    @Override
    public EntitySnapshot createSnapshot() {
        return (EntitySnapshot)EntitySnapshot.builder().from(this).build();
    }

    @Override
    public EntityArchetype createArchetype() {
        return SpongeEntityArchetypeBuilder.pooled().from(this).build();
    }

    @Override
    public HoverEvent<HoverEvent.ShowEntity> asHoverEvent(UnaryOperator<HoverEvent.ShowEntity> op) {
        ResourceLocation entityTypeKey = Registry.field_212629_r.func_177774_c((Object)((net.minecraft.entity.EntityType)this.type()));
        return HoverEvent.showEntity((HoverEvent.ShowEntity)((HoverEvent.ShowEntity)op.apply(HoverEvent.ShowEntity.of((Key)((Key)entityTypeKey), (UUID)this.uniqueId(), (Component)((Component)this.displayName().get())))));
    }

    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        HashSet values = new HashSet();
        values.add(this.requireValue(Keys.AGE).asImmutable());
        values.add(this.requireValue(Keys.BASE_SIZE).asImmutable());
        values.add(this.requireValue(Keys.DISPLAY_NAME).asImmutable());
        values.add(this.requireValue(Keys.EYE_HEIGHT).asImmutable());
        values.add(this.requireValue(Keys.EYE_POSITION).asImmutable());
        values.add(this.requireValue(Keys.FALL_DISTANCE).asImmutable());
        values.add(this.requireValue(Keys.FIRE_DAMAGE_DELAY).asImmutable());
        values.add(this.requireValue(Keys.HEIGHT).asImmutable());
        values.add(this.requireValue(Keys.INVULNERABILITY_TICKS).asImmutable());
        values.add(this.requireValue(Keys.INVULNERABLE).asImmutable());
        values.add(this.requireValue(Keys.IS_CUSTOM_NAME_VISIBLE).asImmutable());
        values.add(this.requireValue(Keys.IS_GLOWING).asImmutable());
        values.add(this.requireValue(Keys.IS_GRAVITY_AFFECTED).asImmutable());
        values.add(this.requireValue(Keys.IS_INVISIBLE).asImmutable());
        values.add(this.requireValue(Keys.IS_SILENT).asImmutable());
        values.add(this.requireValue(Keys.IS_SNEAKING).asImmutable());
        values.add(this.requireValue(Keys.IS_SPRINTING).asImmutable());
        values.add(this.requireValue(Keys.IS_WET).asImmutable());
        values.add(this.requireValue(Keys.MAX_AIR).asImmutable());
        values.add(this.requireValue(Keys.ON_GROUND).asImmutable());
        values.add(((ListValue)this.requireValue(Keys.PASSENGERS)).asImmutable());
        values.add(this.requireValue(Keys.REMAINING_AIR).asImmutable());
        values.add(this.requireValue(Keys.SCALE).asImmutable());
        values.add(((SetValue)this.requireValue(Keys.SCOREBOARD_TAGS)).asImmutable());
        values.add(this.requireValue(Keys.TRANSIENT).asImmutable());
        values.add(this.requireValue(Keys.VANISH_STATE).asImmutable());
        values.add(this.requireValue(Keys.VANISH_IGNORES_COLLISION).asImmutable());
        values.add(this.requireValue(Keys.VANISH_PREVENTS_TARGETING).asImmutable());
        values.add(this.requireValue(Keys.VELOCITY).asImmutable());
        this.getValue(Keys.BASE_VEHICLE).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.CREATOR).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.CUSTOM_NAME).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.FIRE_TICKS).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.NOTIFIER).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.SWIFTNESS).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.VEHICLE).map(Value::asImmutable).ifPresent(values::add);
        return values;
    }
}

