/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IEntityReader;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.volume.entity.EntityVolume;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={IEntityReader.class})
public interface EntityGetterMixin_API
extends EntityVolume {
    @Shadow
    public List<Entity> shadow$func_175674_a(@Nullable Entity var1, AxisAlignedBB var2, @Nullable Predicate<? super Entity> var3);

    @Shadow
    public <T extends Entity> List<T> shadow$func_175647_a(Class<? extends T> var1, AxisAlignedBB var2, @Nullable Predicate<? super T> var3);

    @Shadow
    public List<? extends PlayerEntity> shadow$func_217369_A();

    @Shadow
    public List<Entity> shadow$func_72839_b(@Nullable Entity var1, AxisAlignedBB var2);

    @Override
    default public Vector3i min() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of EntityGetter that isn't part of Sponge API");
    }

    @Override
    default public Vector3i max() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of EntityGetter that isn't part of Sponge API");
    }

    @Override
    default public boolean contains(int x, int y, int z) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of EntityGetter that isn't part of Sponge API");
    }

    @Override
    default public boolean isAreaAvailable(int x, int y, int z) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of EntityGetter that isn't part of Sponge API");
    }

    @Override
    default public Optional<org.spongepowered.api.entity.Entity> entity(UUID uuid) {
        return Optional.empty();
    }

    @Override
    default public Collection<? extends Player> players() {
        return Collections.unmodifiableCollection(this.shadow$func_217369_A());
    }

    @Override
    default public Collection<? extends org.spongepowered.api.entity.Entity> entities() {
        return (Collection)ImmutableList.copyOf(this.shadow$func_72839_b(null, VecHelper.toMinecraftAABB(AABB.of(this.min(), this.max()))));
    }

    @Override
    default public Collection<? extends org.spongepowered.api.entity.Entity> entities(AABB box, Predicate<? super org.spongepowered.api.entity.Entity> filter) {
        return this.shadow$func_175674_a(null, VecHelper.toMinecraftAABB(box), VolumeStreamUtils.apiToImplPredicate(filter));
    }

    default public <E extends org.spongepowered.api.entity.Entity> Collection<? extends E> entities(Class<? extends E> entityClass, AABB box, @Nullable Predicate<? super E> predicate) {
        Predicate<Entity> filter = entity -> predicate == null || entityClass.isInstance(entity) && predicate.test((Object)((org.spongepowered.api.entity.Entity)entity));
        List<Entity> ts = this.shadow$func_175647_a(entityClass, VecHelper.toMinecraftAABB(box), filter);
        return ts;
    }
}

