/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.storage.IWorldInfo;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.WorldLike;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.level.chunk.ChunkBiomeContainerAccessor;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

@Mixin(value={IWorld.class})
@Implements(value={@Interface(iface=WorldLike.class, prefix="worldLike$", remap=Interface.Remap.NONE)})
public interface LevelAccessorMixin_API<P extends WorldLike<P>>
extends WorldLike<P> {
    @Shadow
    public boolean shadow$func_217354_b(int var1, int var2);

    @Shadow
    public Random shadow$func_201674_k();

    @Shadow
    public IWorldInfo shadow$func_72912_H();

    @Override
    default public boolean setBiome(int x, int y, int z, Biome biome) {
        Objects.requireNonNull(biome, "biome");
        IChunk iChunk = ((IWorldReader)this).func_217349_x(new BlockPos(x, y, z));
        if (iChunk == null) {
            return false;
        }
        return VolumeStreamUtils.setBiomeOnNativeChunk(x, y, z, biome, () -> (ChunkBiomeContainerAccessor)iChunk.func_225549_i_(), () -> iChunk.func_177427_f(true));
    }

    @Override
    default public Vector3i min() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of LevelAccessor that isn't part of Sponge API: " + this.getClass());
    }

    @Override
    default public Vector3i max() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of LevelAccessor that isn't part of Sponge API: " + this.getClass());
    }

    @Override
    default public Vector3i size() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of LevelAccessor that isn't part of Sponge API: " + this.getClass());
    }

    @Override
    default public boolean contains(int x, int y, int z) {
        return this.shadow$func_217354_b(x >> 4, z >> 4);
    }

    @Override
    default public boolean isAreaAvailable(int x, int y, int z) {
        return this.shadow$func_217354_b(x >> 4, z >> 4);
    }

    @Override
    default public Optional<org.spongepowered.api.entity.Entity> entity(UUID uuid) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of LevelAccessor that isn't part of Sponge API: " + this.getClass());
    }

    @Intrinsic
    default public Random worldLike$random() {
        return this.shadow$func_201674_k();
    }

    @Override
    default public Difficulty difficulty() {
        return (Difficulty)this.shadow$func_72912_H().func_176130_y();
    }

    @Override
    default public Collection<org.spongepowered.api.entity.Entity> spawnEntities(Iterable<? extends org.spongepowered.api.entity.Entity> entities) {
        Objects.requireNonNull(entities, "entities");
        return EntityUtil.spawnEntities(entities, x -> true, e -> e.field_70170_p.func_217376_c(e));
    }

    @Override
    default public boolean spawnEntity(org.spongepowered.api.entity.Entity entity) {
        return ((IWorld)this).func_217376_c((Entity)Objects.requireNonNull(entity, "entity"));
    }

    @Override
    default public boolean setBlock(int x, int y, int z, BlockState blockState, BlockChangeFlag flag) {
        Objects.requireNonNull(blockState, "blockState");
        Objects.requireNonNull(flag, "flag");
        if (!World.func_175701_a((BlockPos)new BlockPos(x, y, z))) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)Constants.World.BLOCK_MIN, (Vectori)Constants.World.BLOCK_MAX);
        }
        try (@Nullable PhaseContext<@NonNull ?> context = PluginPhase.State.BLOCK_WORKER.switchIfNecessary(PhaseTracker.SERVER);){
            if (context != null) {
                context.buildAndSwitch();
            }
            boolean bl = ((IWorld)this).func_180501_a(new BlockPos(x, y, z), (net.minecraft.block.BlockState)blockState, ((SpongeBlockChangeFlag)flag).getRawFlag());
            return bl;
        }
    }
}

