/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.kyori.adventure.sound.Sound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.storage.IWorldInfo;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.HeightTypes;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeApplicators;
import org.spongepowered.api.world.volume.stream.VolumeCollectors;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslators;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.server.level.ChunkMapAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.effect.particle.SpongeParticleHelper;
import org.spongepowered.common.effect.record.SpongeMusicDisc;
import org.spongepowered.common.entity.living.human.HumanEntity;
import org.spongepowered.common.registry.RegistryHolderLogic;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.level.chunk.SpongeEmptyChunk;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.archetype.SpongeArchetypeVolume;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityBuffer;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={net.minecraft.world.World.class})
public abstract class LevelMixin_API<W extends World<W, L>, L extends Location<W, L>>
implements World<W, L>,
SpongeRegistryHolder,
AutoCloseable {
    @Shadow
    @Final
    public Random field_73012_v;
    @Shadow
    @Final
    public List<TileEntity> field_147482_g;
    private Context api$context;
    private RegistryHolderLogic api$registryHolder;

    @Shadow
    public abstract @Nullable MinecraftServer shadow$func_73046_m();

    @Shadow
    public abstract net.minecraft.block.BlockState shadow$func_180495_p(BlockPos var1);

    @Shadow
    public abstract void shadow$func_184148_a(@javax.annotation.Nullable PlayerEntity var1, double var2, double var4, double var6, SoundEvent var8, SoundCategory var9, float var10, float var11);

    @Shadow
    public abstract IWorldInfo shadow$func_72912_H();

    @Shadow
    public abstract void shadow$func_175690_a(BlockPos var1, @javax.annotation.Nullable TileEntity var2);

    @Shadow
    public abstract RegistryKey<net.minecraft.world.World> shadow$func_234923_W_();

    @Shadow
    public abstract Chunk shadow$func_175726_f(BlockPos var1);

    @Shadow
    public abstract List<net.minecraft.entity.Entity> shadow$func_175674_a(@org.jetbrains.annotations.Nullable net.minecraft.entity.Entity var1, AxisAlignedBB var2, @org.jetbrains.annotations.Nullable Predicate<? super net.minecraft.entity.Entity> var3);

    @Shadow
    public abstract <T extends net.minecraft.entity.Entity> List<T> shadow$func_175647_a(Class<? extends T> var1, AxisAlignedBB var2, @org.jetbrains.annotations.Nullable Predicate<? super T> var3);

    @Override
    public Optional<? extends Player> closestPlayer(int x, int y, int z, double distance, Predicate<? super Player> predicate) {
        return Optional.ofNullable((Player)((net.minecraft.world.World)this).func_190525_a((double)x, (double)y, (double)z, distance, Objects.requireNonNull(predicate, "predicate")));
    }

    @Override
    public WorldChunk chunk(int cx, int cy, int cz) {
        IChunk chunk = ((net.minecraft.world.World)this).func_217353_a(cx, cz, ChunkStatus.field_223226_a_, true);
        if (chunk instanceof WorldChunk) {
            return (WorldChunk)chunk;
        }
        if (chunk instanceof ChunkPrimerWrapper) {
            return (WorldChunk)((ChunkPrimerWrapper)chunk).func_217336_u();
        }
        return new SpongeEmptyChunk((net.minecraft.world.World)this, chunk);
    }

    @Override
    public Optional<WorldChunk> loadChunk(int cx, int cy, int cz, boolean shouldGenerate) {
        ChunkStatus status;
        if (!SpongeChunkLayout.INSTANCE.isValidChunk(cx, cy, cz)) {
            return Optional.empty();
        }
        AbstractChunkProvider chunkProvider = ((IWorld)this).func_72863_F();
        @Nullable IChunk chunkAccess = chunkProvider.func_212849_a_(cx, cz, status = shouldGenerate ? ChunkStatus.field_222617_m : ChunkStatus.field_223226_a_, true);
        if (chunkAccess == null) {
            return Optional.empty();
        }
        if (chunkAccess instanceof ChunkPrimerWrapper) {
            return Optional.of((WorldChunk)((ChunkPrimerWrapper)chunkAccess).func_217336_u());
        }
        if (chunkAccess instanceof WorldChunk) {
            return Optional.of((WorldChunk)chunkAccess);
        }
        return Optional.empty();
    }

    @Override
    public Iterable<WorldChunk> loadedChunks() {
        AbstractChunkProvider chunkProvider = ((IWorld)this).func_72863_F();
        if (chunkProvider instanceof ServerChunkProvider) {
            ChunkMapAccessor chunkManager = (ChunkMapAccessor)((ServerChunkProvider)chunkProvider).field_217237_a;
            ArrayList<WorldChunk> chunks = new ArrayList<WorldChunk>();
            chunkManager.invoker$getChunks().forEach(holder -> {
                WorldChunk chunk = (WorldChunk)holder.func_219298_c();
                if (chunk != null) {
                    chunks.add(chunk);
                }
            });
            return chunks;
        }
        return Collections.emptyList();
    }

    @Override
    public RegistryHolderLogic registryHolder() {
        if (this.api$registryHolder == null) {
            this.api$registryHolder = new RegistryHolderLogic(((IWorld)this).func_241828_r());
        }
        return this.api$registryHolder;
    }

    @Override
    public int highestYAt(int x, int z) {
        return this.height(HeightTypes.WORLD_SURFACE.get(), x, z);
    }

    @Override
    public Vector3i min() {
        return Constants.World.BLOCK_MIN;
    }

    @Override
    public Vector3i max() {
        return Constants.World.BLOCK_MAX;
    }

    @Override
    public Vector3i size() {
        return Constants.World.BLOCK_SIZE;
    }

    @Override
    public Context context() {
        if (this.api$context == null) {
            this.api$context = new Context("world", this.shadow$func_234923_W_().func_240901_a_().toString());
        }
        return this.api$context;
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, org.spongepowered.math.vector.Vector3d position, int radius) {
        Objects.requireNonNull(particleEffect, "particleEffect");
        Objects.requireNonNull(position, "position");
        if (radius <= 0) {
            throw new IllegalArgumentException("The radius has to be greater then zero!");
        }
        SpongeParticleHelper.sendPackets(particleEffect, position, radius, this.shadow$func_234923_W_(), this.shadow$func_73046_m().func_184103_al());
    }

    @Override
    public void playMusicDisc(Vector3i position, MusicDisc musicDisc) {
        this.api$playRecord(Objects.requireNonNull(position, "position"), Objects.requireNonNull(musicDisc, "musicDisc"));
    }

    @Override
    public void stopMusicDisc(Vector3i position) {
        this.api$playRecord(Objects.requireNonNull(position, "position"), null);
    }

    @Override
    public void sendBlockChange(int x, int y, int z, BlockState state) {
        Objects.requireNonNull(state, "state");
        SChangeBlockPacket packet = new SChangeBlockPacket(new BlockPos(x, y, z), (net.minecraft.block.BlockState)state);
        ((net.minecraft.world.World)this).func_217369_A().stream().filter(ServerPlayerEntity.class::isInstance).map(ServerPlayerEntity.class::cast).forEach(p -> p.field_71135_a.func_147359_a((IPacket)packet));
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        SChangeBlockPacket packet = new SChangeBlockPacket((IBlockReader)((IWorldReader)this), new BlockPos(x, y, z));
        ((net.minecraft.world.World)this).func_217369_A().stream().filter(ServerPlayerEntity.class::isInstance).map(ServerPlayerEntity.class::cast).forEach(p -> p.field_71135_a.func_147359_a((IPacket)packet));
    }

    public void playSound(Sound sound, double x, double y, double z) {
        ResourceLocation soundKey = SpongeAdventure.asVanilla(sound.name());
        Optional event = Registry.field_212633_v.func_241873_b(soundKey);
        SoundCategory soundCategory = SpongeAdventure.asVanilla(sound.source());
        if (event.isPresent()) {
            this.shadow$func_184148_a(null, x, y, z, (SoundEvent)event.get(), soundCategory, sound.volume(), sound.pitch());
        } else {
            float volume = sound.volume();
            double radius = volume > 1.0f ? (double)(16.0f * volume) : 16.0;
            SPlaySoundPacket packet = new SPlaySoundPacket(soundKey, soundCategory, new Vector3d(x, y, z), volume, sound.pitch());
            this.shadow$func_73046_m().func_184103_al().func_148543_a(null, x, y, z, radius, this.shadow$func_234923_W_(), (IPacket)packet);
        }
    }

    @Override
    public Collection<? extends BlockEntity> blockEntities() {
        return Collections.unmodifiableCollection(this.field_147482_g);
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        TileEntity mcOriginalBlockEntity = (TileEntity)Objects.requireNonNull(blockEntity, "blockEntity");
        CompoundNBT tag = mcOriginalBlockEntity.func_189515_b(new CompoundNBT());
        this.world().setBlock(x, y, z, (BlockState)mcOriginalBlockEntity.func_195044_w());
        TileEntity mcNewBlockEntity = (TileEntity)this.blockEntity(x, y, z).orElseThrow(() -> new IllegalStateException("Failed to create Block Entity at " + this.location(Vector3i.from((int)x, (int)y, (int)z))));
        mcNewBlockEntity.func_230337_a_(mcOriginalBlockEntity.func_195044_w(), tag);
        this.shadow$func_175690_a(new BlockPos(x, y, z), mcNewBlockEntity);
    }

    @Override
    public <E extends Entity> E createEntity(EntityType<E> type, org.spongepowered.math.vector.Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return ((LevelBridge)((Object)this)).bridge$createEntity(Objects.requireNonNull(type, "type"), Objects.requireNonNull(position, "position"), false);
    }

    @Override
    public <E extends Entity> E createEntityNaturally(EntityType<E> type, org.spongepowered.math.vector.Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return ((LevelBridge)((Object)this)).bridge$createEntity(Objects.requireNonNull(type, "type"), Objects.requireNonNull(position, "position"), true);
    }

    @Override
    public Optional<Entity> createEntity(DataContainer container) {
        return (Optional)((LevelBridge)((Object)this)).bridge$createEntity(container, null, null);
    }

    @Override
    public Optional<Entity> createEntity(DataContainer container, org.spongepowered.math.vector.Vector3d position) {
        return Optional.ofNullable(((LevelBridge)((Object)this)).bridge$createEntity(container, position, null));
    }

    @Override
    public ArchetypeVolume createArchetypeVolume(Vector3i min2, Vector3i max, Vector3i origin) {
        Vector3i rawVolMin = Objects.requireNonNull(min2, "min").min(Objects.requireNonNull(max, "max"));
        Vector3i volMax = max.max(min2);
        Vector3i size = volMax.sub(rawVolMin).add(1, 1, 1);
        Vector3i relativeMin = rawVolMin.sub(Objects.requireNonNull(origin, "origin"));
        SpongeArchetypeVolume volume = new SpongeArchetypeVolume(relativeMin, size, this);
        this.blockStateStream(min2, max, StreamOptions.lazily()).apply(VolumeCollectors.of(volume, VolumePositionTranslators.offset(origin), VolumeApplicators.applyBlocks()));
        this.blockEntityStream(min2, max, StreamOptions.lazily()).map((world, blockEntity, x, y, z) -> ((BlockEntity)blockEntity.get()).createArchetype()).apply(VolumeCollectors.of(volume, VolumePositionTranslators.offset(origin), VolumeApplicators.applyBlockEntityArchetypes()));
        this.biomeStream(min2, max, StreamOptions.lazily()).apply(VolumeCollectors.of(volume, VolumePositionTranslators.offset(origin), VolumeApplicators.applyBiomes()));
        this.entityStream(min2, max, StreamOptions.lazily()).filter((world, entity, x, y, z) -> ((EntityAccessor)entity.get()).invoker$getEncodeId() != null || ((Entity)entity.get()).type() == HumanEntity.TYPE).map((world, entity, x, y, z) -> ((Entity)entity.get()).createArchetype()).apply(VolumeCollectors.of(volume, VolumePositionTranslators.offset(origin), VolumeApplicators.applyEntityArchetypes()));
        return volume;
    }

    private void api$playRecord(Vector3i position, @javax.annotation.Nullable MusicDisc recordType) {
        this.shadow$func_73046_m().func_184103_al().func_232642_a_((IPacket)SpongeMusicDisc.createPacket(position, recordType), this.shadow$func_234923_W_());
    }

    @Override
    public Optional<Entity> entity(UUID uuid) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of Level that isn't part of Sponge API");
    }

    @Override
    public Collection<? extends Player> players() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of Level that isn't part of Sponge API");
    }

    @Override
    public VolumeStream<W, Entity> entityStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min2, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min2).add(1, 1, 1);
        ObjectArrayMutableEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableEntityBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(min2, max, options, this, VolumeStreamUtils.getOrCloneEntityWithVolume(shouldCarbonCopy, backingVolume, (net.minecraft.world.World)this), VolumeStreamUtils.getChunkAccessorByStatus((IWorldReader)this, options.loadingStyle().generateArea()), (key, entity) -> entity.func_110124_au(), chunk -> chunk instanceof Chunk ? VolumeStreamUtils.getEntitiesFromChunk(min2, max, (Chunk)chunk) : Stream.empty(), (entityUuid, world) -> {
            net.minecraft.entity.Entity entity;
            net.minecraft.entity.Entity entity2 = entity = shouldCarbonCopy ? (net.minecraft.entity.Entity)backingVolume.entity((UUID)entityUuid).orElse(null) : (net.minecraft.entity.Entity)world.entity((UUID)entityUuid).orElse(null);
            if (entity == null) {
                return null;
            }
            return new Tuple((Object)entity.func_233580_cy_(), (Object)entity);
        });
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        if (!((net.minecraft.world.World)this).func_217354_b(x << 4, z << 4)) {
            return false;
        }
        Chunk levelChunk = this.shadow$func_175726_f(new BlockPos(x, y, z));
        return ((BiomeVolume.Modifiable)levelChunk).setBiome(x, y, z, biome);
    }

    @Override
    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        for (Entity entity : entities) {
            if (!this.spawnEntity(entity)) continue;
            entityList.add(entity);
        }
        return entityList;
    }

    @Override
    public <T extends Entity> Collection<? extends T> entities(Class<? extends T> entityClass, AABB box, @Nullable Predicate<? super T> filter) {
        return this.shadow$func_175647_a(entityClass, VecHelper.toMinecraftAABB(box), filter);
    }

    @Override
    public Collection<? extends Entity> entities(AABB box, Predicate<? super Entity> filter) {
        return this.shadow$func_175674_a(null, VecHelper.toMinecraftAABB(box), filter);
    }
}

