/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level;

import java.util.Objects;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.HeightType;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.volume.game.Region;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={IWorldReader.class})
public interface LevelReaderMixin_API<R extends Region<R>>
extends Region<R> {
    @Shadow
    public @Nullable IChunk shadow$func_217353_a(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    @Shadow
    public boolean shadow$func_217354_b(int var1, int var2);

    @Shadow
    public int shadow$func_201676_a(Heightmap.Type var1, int var2, int var3);

    @Shadow
    public int shadow$func_175657_ab();

    @Shadow
    public int shadow$func_181545_F();

    @Shadow
    public boolean shadow$func_201671_F(BlockPos var1);

    @Deprecated
    @Shadow
    public boolean shadow$func_217344_a(int var1, int var2, int var3, int var4, int var5, int var6);

    @Shadow
    public DimensionType shadow$func_230315_m_();

    @Shadow
    public boolean shadow$func_72953_d(AxisAlignedBB var1);

    @Shadow
    public Biome shadow$func_226691_t_(BlockPos var1);

    @Override
    default public WorldType worldType() {
        return (WorldType)this.shadow$func_230315_m_();
    }

    @Override
    default public WorldBorder border() {
        return ((WorldBorderBridge)((ICollisionReader)this).func_175723_af()).bridge$asImmutable();
    }

    @Override
    default public WorldBorder setBorder(WorldBorder border) {
        WorldBorder worldBorder = ((WorldBorderBridge)((ICollisionReader)this).func_175723_af()).bridge$applyFrom(border);
        if (worldBorder == null) {
            return (WorldBorder)net.minecraft.world.border.WorldBorder.field_235925_b_;
        }
        return worldBorder;
    }

    @Override
    default public boolean isInBorder(org.spongepowered.api.entity.Entity entity) {
        return ((ICollisionReader)this).func_175723_af().func_177743_a(((Entity)Objects.requireNonNull(entity, "entity")).func_174813_aQ());
    }

    @Override
    default public boolean canSeeSky(int x, int y, int z) {
        return ((IBlockDisplayReader)this).func_226660_f_(new BlockPos(x, y, z));
    }

    @Override
    default public boolean hasLiquid(int x, int y, int z) {
        return this.shadow$func_201671_F(new BlockPos(x, y, z));
    }

    @Override
    default public boolean containsAnyLiquids(AABB aabb) {
        Vector3d max = Objects.requireNonNull(aabb, "aabb").max();
        Vector3d min2 = aabb.min();
        return this.shadow$func_72953_d(new AxisAlignedBB(min2.x(), min2.y(), min2.z(), max.x(), max.y(), max.z()));
    }

    @Override
    default public int skylightSubtracted() {
        return this.shadow$func_175657_ab();
    }

    @Override
    default public int seaLevel() {
        return this.shadow$func_181545_F();
    }

    @Override
    default public boolean isAreaLoaded(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, boolean allowEmpty) {
        return this.shadow$func_217344_a(xStart, yStart, zStart, xEnd, yEnd, zEnd);
    }

    @Override
    default public Random random() {
        return new Random();
    }

    @Override
    default public Chunk<@NonNull ?> chunk(int x, int y, int z) {
        return (Chunk)this.shadow$func_217353_a(x, z, ChunkStatus.field_223226_a_, true);
    }

    @Override
    default public boolean isChunkLoaded(int cx, int cy, int cz, boolean allowEmpty) {
        return this.shadow$func_217354_b(cx, cz);
    }

    @Override
    default public boolean hasChunk(int cx, int cy, int cz) {
        return this.shadow$func_217354_b(cx, cz);
    }

    @Override
    default public int height(HeightType type, int x, int z) {
        return this.shadow$func_201676_a((Heightmap.Type)Objects.requireNonNull(type, "type"), x, z);
    }

    @Override
    default public org.spongepowered.api.world.biome.Biome biome(int x, int y, int z) {
        return (org.spongepowered.api.world.biome.Biome)this.shadow$func_226691_t_(new BlockPos(x, y, z));
    }

    @Override
    default public VolumeStream<R, org.spongepowered.api.world.biome.Biome> biomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        return VolumeStreamUtils.getBiomeStream((IWorldReader)this, min2, max, options);
    }

    @Override
    default public VolumeStream<R, BlockState> blockStateStream(Vector3i min2, Vector3i max, StreamOptions options) {
        return VolumeStreamUtils.generateBlockStream((IWorldReader)this, min2, max, options);
    }

    @Override
    default public VolumeStream<R, BlockEntity> blockEntityStream(Vector3i min2, Vector3i max, StreamOptions options) {
        return VolumeStreamUtils.getBlockEntityStream((IWorldReader)this, min2, max, options);
    }
}

