/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.chunk;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.scheduler.ScheduledUpdateList;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.HeightType;
import org.spongepowered.api.world.HeightTypes;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.chunk.ChunkState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.level.chunk.ChunkBiomeContainerAccessor;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={IChunk.class})
public interface ChunkAccessMixin_API<P extends Chunk<P>>
extends Chunk<P> {
    @Shadow
    public ChunkStatus shadow$func_201589_g();

    @Shadow
    @Nullable
    public BiomeContainer shadow$func_225549_i_();

    @Shadow
    public void shadow$func_76612_a(Entity var1);

    @Shadow
    public void shadow$func_177427_f(boolean var1);

    @Shadow
    public void shadow$func_177415_c(long var1);

    @Shadow
    public long shadow$func_177416_w();

    @Shadow
    public ChunkPos shadow$func_76632_l();

    @Shadow
    public int shadow$func_201576_a(Heightmap.Type var1, int var2, int var3);

    @Override
    default public void addEntity(org.spongepowered.api.entity.Entity entity) {
        this.shadow$func_76612_a((Entity)entity);
    }

    @Override
    default public ChunkState state() {
        return (ChunkState)this.shadow$func_201589_g();
    }

    @Override
    default public boolean isEmpty() {
        return this.shadow$func_201589_g() == ChunkStatus.field_223226_a_;
    }

    @Override
    default public boolean setBiome(int x, int y, int z, Biome biome) {
        return VolumeStreamUtils.setBiomeOnNativeChunk(x, y, z, biome, () -> (ChunkBiomeContainerAccessor)this.shadow$func_225549_i_(), () -> this.shadow$func_177427_f(true));
    }

    @Override
    default public Ticks inhabitedTime() {
        return new SpongeTicks(this.shadow$func_177416_w());
    }

    @Override
    default public void setInhabitedTime(Ticks newInhabitedTime) {
        this.shadow$func_177415_c(newInhabitedTime.ticks());
    }

    @Override
    default public Vector3i chunkPosition() {
        ChunkPos chunkPos = this.shadow$func_76632_l();
        return new Vector3i(chunkPos.field_77276_a, 0, chunkPos.field_77275_b);
    }

    @Override
    default public boolean contains(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    @Override
    default public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    @Override
    default public int highestYAt(int x, int z) {
        return this.shadow$func_201576_a((Heightmap.Type)HeightTypes.WORLD_SURFACE.get(), x, z);
    }

    @Override
    default public int height(HeightType type, int x, int z) {
        return this.shadow$func_201576_a((Heightmap.Type)HeightTypes.WORLD_SURFACE.get(), x, z);
    }

    @Override
    default public ScheduledUpdateList<BlockType> scheduledBlockUpdates() {
        throw new MissingImplementationException("ChunkAccess", "scheduledBlockUpdates");
    }

    @Override
    default public ScheduledUpdateList<FluidType> scheduledFluidUpdates() {
        throw new MissingImplementationException("ChunkAccess", "scheduledFluidUpdates");
    }
}

