/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldLike;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.data.holder.SpongeLocationBaseDataHolder;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.ObjectArrayMutableBiomeBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.volume.buffer.blockentity.ObjectArrayMutableBlockEntityBuffer;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

@Mixin(value={Chunk.class})
@Implements(value={@Interface(iface=WorldChunk.class, prefix="worldChunk$", remap=Interface.Remap.NONE)})
public abstract class LevelChunkMixin_API
implements WorldChunk,
SpongeLocationBaseDataHolder {
    @Shadow
    @Final
    private ChunkPos field_212816_F;
    @Shadow
    @Final
    private net.minecraft.world.World field_76637_e;
    @Shadow
    @Final
    private ClassInheritanceMultiMap<net.minecraft.entity.Entity>[] field_76645_j;
    private @Nullable Vector3i api$blockMin;
    private @Nullable Vector3i api$blockMax;

    @Shadow
    public abstract boolean shadow$func_76621_g();

    @Shadow
    public abstract int shadow$func_201576_a(Heightmap.Type var1, int var2, int var3);

    @Shadow
    public abstract void shadow$func_177427_f(boolean var1);

    @Shadow
    public abstract <T extends net.minecraft.entity.Entity> void shadow$func_177430_a(Class<? extends T> var1, AxisAlignedBB var2, List<T> var3, @org.jetbrains.annotations.Nullable Predicate<? super T> var4);

    @Shadow
    public abstract void shadow$func_177414_a(@org.jetbrains.annotations.Nullable net.minecraft.entity.Entity var1, AxisAlignedBB var2, List<net.minecraft.entity.Entity> var3, @org.jetbrains.annotations.Nullable Predicate<? super net.minecraft.entity.Entity> var4);

    @Shadow
    public abstract Map<BlockPos, TileEntity> shadow$func_177434_r();

    @Shadow
    public abstract void shadow$func_177426_a(BlockPos var1, TileEntity var2);

    @Shadow
    public abstract void shadow$func_177425_e(BlockPos var1);

    @Override
    public Biome biome(int x, int y, int z) {
        if (!this.contains(x, y, z)) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)Constants.World.BLOCK_MIN, (Vectori)Constants.World.BLOCK_MAX);
        }
        return (Biome)this.field_76637_e.func_226691_t_(new BlockPos(x, y, z));
    }

    @Override
    public double regionalDifficultyFactor() {
        return new DifficultyInstance(this.field_76637_e.func_175659_aa(), this.field_76637_e.func_72820_D(), this.inhabitedTime().ticks(), this.field_76637_e.func_242413_ae()).func_180168_b();
    }

    @Override
    public double regionalDifficultyPercentage() {
        return new DifficultyInstance(this.field_76637_e.func_175659_aa(), this.field_76637_e.func_72820_D(), this.inhabitedTime().ticks(), this.field_76637_e.func_242413_ae()).func_180170_c();
    }

    @Override
    public World<@NonNull ?, @NonNull ?> world() {
        return (World)this.field_76637_e;
    }

    @Intrinsic
    public boolean worldChunk$isEmpty() {
        return this.shadow$func_76621_g();
    }

    @Override
    public VolumeStream<WorldChunk, Entity> entityStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min2, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min2).add(1, 1, 1);
        ObjectArrayMutableEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableEntityBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(options, this, (Chunk)this, chunk -> VolumeStreamUtils.getEntitiesFromChunk(min2, max, chunk), VolumeStreamUtils.getOrCloneEntityWithVolume(shouldCarbonCopy, backingVolume, this.field_76637_e), (key, entity) -> entity.func_110124_au(), (entityUuid, chunk) -> {
            net.minecraft.entity.Entity entity;
            net.minecraft.entity.Entity entity2 = entity = shouldCarbonCopy ? (net.minecraft.entity.Entity)backingVolume.entity((UUID)entityUuid).orElse(null) : (net.minecraft.entity.Entity)chunk.world().entity((UUID)entityUuid).orElse(null);
            if (entity == null) {
                return null;
            }
            return new Tuple((Object)entity.func_233580_cy_(), (Object)entity);
        });
    }

    @Override
    public VolumeStream<WorldChunk, BlockState> blockStateStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min2, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min2).add(1, 1, 1);
        ArrayMutableBlockBuffer backingVolume = shouldCarbonCopy ? new ArrayMutableBlockBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(options, this, (Chunk)this, VolumeStreamUtils.getBlockStatesForSections(min2, max), (pos, blockState) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBlock((BlockPos)pos, (net.minecraft.block.BlockState)blockState);
            }
        }, (key, biome) -> key, (blockPos, world) -> {
            net.minecraft.block.BlockState tileEntity = shouldCarbonCopy ? backingVolume.getBlock((BlockPos)blockPos) : ((IWorldReader)world).func_180495_p(blockPos);
            return new Tuple(blockPos, (Object)tileEntity);
        });
    }

    @Override
    public Collection<? extends BlockEntity> blockEntities() {
        return Collections.unmodifiableCollection(this.shadow$func_177434_r().values());
    }

    @Override
    public VolumeStream<WorldChunk, BlockEntity> blockEntityStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min2, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min2).add(1, 1, 1);
        ObjectArrayMutableBlockEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableBlockEntityBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(options, this, (Chunk)this, this::impl$getBlockEntitiesStream, VolumeStreamUtils.getBlockEntityOrCloneToBackingVolume(shouldCarbonCopy, backingVolume, this.field_76637_e), (key, biome) -> key, (blockPos, world) -> {
            @Nullable TileEntity tileEntity = shouldCarbonCopy ? (TileEntity)backingVolume.blockEntity(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()).orElse(null) : ((IWorldReader)world).func_175625_s(blockPos);
            return new Tuple(blockPos, (Object)tileEntity);
        });
    }

    private Stream<Map.Entry<BlockPos, TileEntity>> impl$getBlockEntitiesStream(IChunk chunk) {
        return chunk instanceof Chunk ? ((Chunk)chunk).func_177434_r().entrySet().stream() : Stream.empty();
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        this.world().addBlockEntity(x, y, z, blockEntity);
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.world().removeBlockEntity(x, y, z);
    }

    @Override
    public VolumeStream<WorldChunk, Biome> biomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        ObjectArrayMutableBiomeBuffer backingVolume;
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min2, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min2).add(1, 1, 1);
        if (shouldCarbonCopy) {
            Registry biomeRegistry = this.field_76637_e.func_241828_r().func_230521_a_(Registry.field_239720_u_).map(wr -> wr).orElse(WorldGenRegistries.field_243657_i);
            backingVolume = new ObjectArrayMutableBiomeBuffer(min2, size, VolumeStreamUtils.nativeToSpongeRegistry(biomeRegistry));
        } else {
            backingVolume = null;
        }
        return VolumeStreamUtils.generateStream(options, this, (Chunk)this, VolumeStreamUtils.getBiomesForChunkByPos((IWorldReader)this, min2, max), (pos, biome) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBiome((BlockPos)pos, (net.minecraft.world.biome.Biome)biome);
            }
        }, (key, biome) -> key, (blockPos, world) -> {
            net.minecraft.world.biome.Biome biome = shouldCarbonCopy ? backingVolume.getNativeBiome(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()) : ((IWorldReader)world.world()).func_226691_t_(blockPos);
            return new Tuple(blockPos, (Object)biome);
        });
    }

    @Override
    public Vector3i min() {
        if (this.api$blockMin == null) {
            this.api$blockMin = SpongeChunkLayout.INSTANCE.forceToWorld(this.chunkPosition());
        }
        return this.api$blockMin;
    }

    @Override
    public Vector3i max() {
        if (this.api$blockMax == null) {
            this.api$blockMax = this.min().add(SpongeChunkLayout.CHUNK_SIZE).sub(1, 1, 1);
        }
        return this.api$blockMax;
    }

    @Override
    public Vector3i size() {
        return SpongeChunkLayout.CHUNK_SIZE;
    }

    @Override
    public Collection<? extends Player> players() {
        return this.field_76637_e.func_217369_A().stream().filter(x -> x.field_70175_ag && x.field_70176_ah == this.field_212816_F.field_77276_a && x.field_70164_aj == this.field_212816_F.field_77275_b).collect(Collectors.toList());
    }

    @Override
    public Optional<Entity> entity(UUID uuid) {
        return Arrays.stream(this.field_76645_j).flatMap(Collection::stream).filter(x -> x.func_110124_au().equals(uuid)).findAny();
    }

    @Override
    public Collection<? extends Entity> entities() {
        return (Collection)Arrays.stream(this.field_76645_j).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    @Override
    public <T extends Entity> Collection<? extends T> entities(Class<? extends T> entityClass, AABB box, @Nullable Predicate<? super T> predicate) {
        ArrayList entities = new ArrayList();
        this.shadow$func_177430_a(entityClass, VecHelper.toMinecraftAABB(box), entities, predicate);
        return entities;
    }

    @Override
    public Collection<? extends Entity> entities(AABB box, Predicate<? super Entity> filter) {
        ArrayList<net.minecraft.entity.Entity> entities = new ArrayList<net.minecraft.entity.Entity>();
        this.shadow$func_177414_a(null, VecHelper.toMinecraftAABB(box), entities, filter);
        return entities;
    }

    @Override
    public <E extends Entity> E createEntity(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        this.api$checkPositionInChunk(position);
        return ((LevelBridge)this.field_76637_e).bridge$createEntity(type, position, false);
    }

    @Override
    public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        this.api$checkPositionInChunk(position);
        return ((LevelBridge)this.field_76637_e).bridge$createEntity(type, position, true);
    }

    @Override
    public Optional<Entity> createEntity(DataContainer container) {
        return Optional.ofNullable(((LevelBridge)this.field_76637_e).bridge$createEntity(container, null, position -> VecHelper.inBounds(position, this.min(), this.max())));
    }

    @Override
    public Optional<Entity> createEntity(DataContainer container, Vector3d position) {
        this.api$checkPositionInChunk(position);
        return Optional.ofNullable(((LevelBridge)this.field_76637_e).bridge$createEntity(container, position, null));
    }

    @Override
    public boolean spawnEntity(Entity entity) {
        return ((LevelChunkBridge)((Object)this)).bridge$spawnEntity(entity);
    }

    @Override
    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        return EntityUtil.spawnEntities(entities, x -> this.api$isInBounds(x.position()), entity -> ((LevelChunkBridge)((Object)this)).bridge$spawnEntity((Entity)entity));
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState blockState, BlockChangeFlag flag) {
        this.api$checkPositionInChunk(x, y, z);
        return ((WorldLike)this.field_76637_e).setBlock(x, y, z, blockState, flag);
    }

    private void api$checkPositionInChunk(int x, int y, int z) {
        if (!VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max())) {
            throw new IllegalArgumentException("Supplied bounds are not within this chunk.");
        }
    }

    private void api$checkPositionInChunk(Vector3d position) {
        if (!this.api$isInBounds(position)) {
            throw new IllegalArgumentException("Supplied bounds are not within this chunk.");
        }
    }

    private boolean api$isInBounds(Vector3d position) {
        return VecHelper.inBounds(position, this.min(), this.max());
    }

    @Override
    public ServerLocation impl$dataholder(int x, int y, int z) {
        this.api$checkPositionInChunk(x, y, z);
        if (this.field_76637_e instanceof ServerWorld) {
            return (ServerLocation)((ServerWorld)this.field_76637_e).location(x, y, z);
        }
        throw new MissingImplementationException("LevelChunk", "impl$dataholder");
    }
}

