/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.chunk;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkPrimer;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.generation.GenerationChunk;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.holder.SpongeLocationBaseDataHolder;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

@Mixin(value={ChunkPrimer.class})
public abstract class ProtoChunkMixin_API
implements GenerationChunk,
SpongeLocationBaseDataHolder {
    @Shadow
    @Nullable
    private BiomeContainer field_201656_d;
    private @org.checkerframework.checker.nullness.qual.Nullable Vector3i api$blockMin;
    private @org.checkerframework.checker.nullness.qual.Nullable Vector3i api$blockMax;

    @Shadow
    @Nullable
    public abstract net.minecraft.block.BlockState shadow$func_177436_a(BlockPos var1, net.minecraft.block.BlockState var2, boolean var3);

    @Shadow
    public abstract Map<BlockPos, TileEntity> shadow$func_201627_k();

    @Shadow
    public abstract void shadow$func_177426_a(BlockPos var1, TileEntity var2);

    @Shadow
    public abstract void shadow$func_177425_e(BlockPos var1);

    @Override
    public VolumeStream<GenerationChunk, Biome> biomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        throw new UnsupportedOperationException("Cannot stream biomes on ProtoChunk");
    }

    @Override
    public VolumeStream<GenerationChunk, BlockState> blockStateStream(Vector3i min2, Vector3i max, StreamOptions options) {
        throw new UnsupportedOperationException("Cannot stream block states on ProtoChunk");
    }

    @Override
    public VolumeStream<GenerationChunk, BlockEntity> blockEntityStream(Vector3i min2, Vector3i max, StreamOptions options) {
        throw new UnsupportedOperationException("Cannot stream block entities on ProtoChunk");
    }

    @Override
    public Vector3i min() {
        if (this.api$blockMin == null) {
            this.api$blockMin = SpongeChunkLayout.INSTANCE.forceToWorld(this.chunkPosition());
        }
        return this.api$blockMin;
    }

    @Override
    public Vector3i max() {
        if (this.api$blockMax == null) {
            this.api$blockMax = this.min().add(SpongeChunkLayout.CHUNK_SIZE).sub(1, 1, 1);
        }
        return this.api$blockMax;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        return false;
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        return false;
    }

    @Override
    public Collection<? extends BlockEntity> blockEntities() {
        return Collections.unmodifiableCollection(this.shadow$func_201627_k().values());
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        this.shadow$func_177426_a(new BlockPos(x, y, z), (TileEntity)blockEntity);
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.shadow$func_177425_e(new BlockPos(x, y, z));
    }

    @Override
    public Biome biome(int x, int y, int z) {
        if (!this.contains(x, y, z)) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)Constants.World.BLOCK_MIN, (Vectori)Constants.World.BLOCK_MAX);
        }
        if (this.field_201656_d != null) {
            return (Biome)this.field_201656_d.func_225526_b_(x, y, z);
        }
        return null;
    }

    @Override
    public ServerLocation impl$dataholder(int x, int y, int z) {
        throw new MissingImplementationException("ProtoChunk", "impl$dataholder");
    }
}

