/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.saveddata;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import org.spongepowered.api.map.MapInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.storage.MapDecorationBridge;

@Mixin(value={MapDecoration.class})
public abstract class MapDecorationMixin
implements MapDecorationBridge {
    private final Set<MapData> impl$attachedMapDatas = new HashSet<MapData>();
    private boolean impl$isPersistent;
    private String impl$key = "sponge-" + UUID.randomUUID().toString();

    @Inject(method={"<init>(Lnet/minecraft/world/storage/MapDecoration$Type;BBBLnet/minecraft/util/text/ITextComponent;)V"}, at={@At(value="RETURN")})
    public void impl$setPersistenceOnInit(MapDecoration.Type typeIn, byte x, byte y, byte rot, ITextComponent name, CallbackInfo ci) {
        switch (typeIn) {
            case PLAYER: 
            case PLAYER_OFF_MAP: 
            case PLAYER_OFF_LIMITS: 
            case FRAME: {
                this.impl$isPersistent = false;
                break;
            }
            default: {
                this.impl$isPersistent = true;
            }
        }
    }

    @Override
    public void bridge$setPersistent(boolean persistent) {
        this.impl$isPersistent = persistent;
    }

    @Override
    public boolean bridge$isPersistent() {
        return this.impl$isPersistent;
    }

    @Override
    public void bridge$setKey(String key) {
        this.impl$key = key;
    }

    @Override
    public String bridge$getKey() {
        return this.impl$key;
    }

    @Override
    public void notifyAddedToMap(MapInfo mapInfo) {
        this.impl$attachedMapDatas.add((MapData)mapInfo);
    }

    @Override
    public void notifyRemovedFromMap(MapInfo mapInfo) {
        this.impl$attachedMapDatas.remove((MapData)mapInfo);
    }

    @Override
    public void bridge$markAllDirty() {
        if (!this.impl$isPersistent) {
            return;
        }
        for (MapData mapData : this.impl$attachedMapDatas) {
            mapData.func_76185_a();
        }
    }
}

