/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.storage;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.GameType;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.storage.IServerWorldInfo;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.trader.WanderingTrader;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherType;
import org.spongepowered.api.world.weather.WeatherTypes;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.world.weather.SpongeWeather;
import org.spongepowered.common.world.weather.SpongeWeatherType;

@Mixin(value={IServerWorldInfo.class})
@Implements(value={@Interface(iface=ServerWorldProperties.class, prefix="serverWorldProperties$", remap=Interface.Remap.NONE)})
public interface ServerLevelDataMixin_API
extends ServerWorldProperties {
    @Shadow
    public void shadow$func_76069_a(boolean var1);

    @Shadow
    public int shadow$func_76083_p();

    @Shadow
    public void shadow$func_76080_g(int var1);

    @Shadow
    public void shadow$func_76090_f(int var1);

    @Shadow
    public int shadow$func_76071_n();

    @Shadow
    public int shadow$func_230395_g_();

    @Shadow
    public void shadow$func_230391_a_(int var1);

    @Shadow
    public int shadow$func_230399_u_();

    @Shadow
    public void shadow$func_230396_g_(int var1);

    @Shadow
    public int shadow$func_230400_v_();

    @Shadow
    public void shadow$func_230397_h_(int var1);

    @Shadow
    public void shadow$func_230394_a_(UUID var1);

    @Shadow
    public GameType shadow$func_76077_q();

    @Shadow
    public WorldBorder.Serializer shadow$func_230398_q_();

    @Shadow
    public boolean shadow$func_76070_v();

    @Shadow
    public boolean shadow$func_76086_u();

    @Shadow
    public void shadow$func_230392_a_(GameType var1);

    @Shadow
    public void shadow$func_76068_b(long var1);

    @Override
    default public void setDayTime(MinecraftDayTime dayTime) {
        this.shadow$func_76068_b(dayTime.asTicks().ticks());
    }

    @Override
    default public GameMode gameMode() {
        return (GameMode)this.shadow$func_76077_q();
    }

    @Override
    default public void setGameMode(GameMode gamemode) {
        this.shadow$func_230392_a_((GameType)gamemode);
    }

    @Override
    default public boolean commands() {
        return this.shadow$func_76086_u();
    }

    @Intrinsic
    default public boolean serverWorldProperties$initialized() {
        return this.shadow$func_76070_v();
    }

    @Override
    default public Ticks wanderingTraderSpawnDelay() {
        return Ticks.of(this.shadow$func_230399_u_());
    }

    @Override
    default public void setWanderingTraderSpawnDelay(Ticks delay) {
        this.shadow$func_230396_g_((int)delay.ticks());
    }

    @Override
    default public int wanderingTraderSpawnChance() {
        return this.shadow$func_230400_v_();
    }

    @Override
    default public void setWanderingTraderSpawnChance(int chance) {
        this.shadow$func_230397_h_(chance);
    }

    @Override
    default public void setWanderingTrader(@Nullable WanderingTrader trader) {
        this.shadow$func_230394_a_(trader == null ? null : trader.uniqueId());
    }

    @Override
    default public Weather weather() {
        if (((IServerWorldInfo)this).func_76061_m()) {
            return new SpongeWeather((SpongeWeatherType)WeatherTypes.THUNDER.get(), new SpongeTicks(this.shadow$func_76071_n()), new SpongeTicks(6000 - this.shadow$func_76071_n()));
        }
        if (((IServerWorldInfo)this).func_76059_o()) {
            return new SpongeWeather((SpongeWeatherType)WeatherTypes.RAIN.get(), new SpongeTicks(this.shadow$func_76083_p()), new SpongeTicks(6000 - this.shadow$func_76083_p()));
        }
        return new SpongeWeather((SpongeWeatherType)WeatherTypes.CLEAR.get(), new SpongeTicks(this.shadow$func_230395_g_()), new SpongeTicks(6000 - this.shadow$func_230395_g_()));
    }

    @Override
    default public void setWeather(WeatherType type) {
        this.setWeather(Objects.requireNonNull(type, "type"), new SpongeTicks(120L));
    }

    @Override
    default public void setWeather(WeatherType type, Ticks ticks) {
        Objects.requireNonNull(type, "type");
        long time = Objects.requireNonNull(ticks, "ticks").ticks();
        if (type == WeatherTypes.CLEAR.get()) {
            this.shadow$func_230391_a_((int)time);
            ((IServerWorldInfo)this).func_76084_b(false);
            this.shadow$func_76080_g(0);
            this.shadow$func_76069_a(false);
            this.shadow$func_76090_f(0);
        } else if (type == WeatherTypes.RAIN.get()) {
            ((IServerWorldInfo)this).func_76084_b(true);
            this.shadow$func_76080_g((int)time);
            this.shadow$func_76069_a(false);
            this.shadow$func_76090_f(0);
            this.shadow$func_230391_a_(0);
        } else if (type == WeatherTypes.THUNDER.get()) {
            ((IServerWorldInfo)this).func_76084_b(true);
            this.shadow$func_76080_g((int)time);
            this.shadow$func_76069_a(true);
            this.shadow$func_76090_f((int)time);
            this.shadow$func_230391_a_(0);
        }
    }

    @Override
    default public WorldBorder worldBorder() {
        return (WorldBorder)this.shadow$func_230398_q_();
    }
}

