/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.concurrentcheck.util;

import net.minecraft.util.ClassInheritanceMultiMap;
import org.spongepowered.api.Platform;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.hooks.PlatformHooks;

@Mixin(value={ClassInheritanceMultiMap.class})
public abstract class ClassInstanceMultiMapMixin_ConcurrentCheck {
    @Inject(method={"add(Ljava/lang/Object;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void concurrentCheck$checkThreadOnAdd(Object entity, CallbackInfoReturnable<Boolean> cir) {
        if (SpongeCommon.game().platform().executionType() != Platform.Type.CLIENT && !PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            Thread.dumpStack();
            SpongeCommon.logger().error("Detected attempt to add entity '" + entity + "' to ClassInstanceMultiMap asynchronously.\n This is very bad as it can cause ConcurrentModificationException's during a server tick.\n Skipping...");
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"remove(Ljava/lang/Object;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void concurrentCheck$checkServerThreadSide(Object entity, CallbackInfoReturnable<Boolean> cir) {
        if (SpongeCommon.game().platform().executionType() != Platform.Type.CLIENT && !PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            Thread.dumpStack();
            SpongeCommon.logger().error("Detected attempt to remove entity '" + entity + "' from ClassInstanceMultiMap asynchronously.\n This is very bad as it can cause ConcurrentModificationException's during a server tick.\n Skipping...");
            cir.setReturnValue((Object)false);
        }
    }
}

