/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.block.BlockBridge;
import org.spongepowered.common.bridge.block.DyeColorBlockBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.ReflectionUtil;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={Block.class})
public abstract class BlockMixin
implements BlockBridge,
TrackableBridge {
    private final boolean impl$isVanilla = this.getClass().getName().startsWith("net.minecraft.");
    private final boolean impl$hasCollideLogic = ReflectionUtil.isStepOnDeclared(this.getClass());
    private final boolean impl$hasCollideWithStateLogic = ReflectionUtil.isEntityInsideDeclared(this.getClass());

    @Inject(method={"<init>(Lnet/minecraft/block/AbstractBlock$Properties;)V"}, at={@At(value="RETURN")})
    private void impl$setUpSpongeFields(AbstractBlock.Properties properties, CallbackInfo ci) {
        ((DyeColorBlockBridge)((Object)this)).bridge$setDyeColor(((DyeColorBlockBridge)properties).bridge$getDyeColor().orElse(null));
    }

    @Inject(method={"func_180635_a(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="NEW", target="Lnet/minecraft/entity/item/ItemEntity;<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;)V")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT, require=0, expect=0)
    private static void impl$throwConstructPreEvent(World level, BlockPos pos, ItemStack stack, CallbackInfo ci, float unused, double xOffset, double yOffset, double zOffset) {
        if (!ShouldFire.CONSTRUCT_ENTITY_EVENT_PRE) {
            return;
        }
        double xPos = (double)pos.func_177958_n() + xOffset;
        double yPos = (double)pos.func_177956_o() + yOffset;
        double zPos = (double)pos.func_177952_p() + zOffset;
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(level.func_180495_p(pos));
            ConstructEntityEvent.Pre eventPre = SpongeEventFactory.createConstructEntityEventPre(frame.currentCause(), ServerLocation.of((ServerWorld)level, xPos, yPos, zPos), new Vector3d(0.0f, 0.0f, 0.0f), EntityTypes.ITEM.get());
            SpongeCommon.post(eventPre);
            if (eventPre.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Override
    public boolean bridge$isVanilla() {
        return this.impl$isVanilla;
    }

    @Override
    public boolean bridge$hasCollideLogic() {
        return this.impl$hasCollideLogic;
    }

    @Override
    public boolean bridge$hasCollideWithStateLogic() {
        return this.impl$hasCollideWithStateLogic;
    }
}

