/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MapItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.map.MapInfo;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.bridge.world.storage.MapItemSavedDataBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.math.vector.Vector2i;

@Mixin(value={MapItem.class})
public abstract class EmptyMapItemMixin {
    @Redirect(method={"func_77659_a(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/FilledMapItem;func_195952_a(Lnet/minecraft/world/World;IIBZZ)Lnet/minecraft/item/ItemStack;"))
    private ItemStack impl$createMapWithSpongeData(World level, int x, int y, byte scale, boolean trackingPosition, boolean unlimitedTracking, World level2, PlayerEntity playerIn, Hand usedHand) {
        if (level.func_201670_d()) {
            return FilledMapItem.func_195952_a((World)level, (int)x, (int)y, (byte)scale, (boolean)trackingPosition, (boolean)unlimitedTracking);
        }
        Player player = (Player)playerIn;
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.PLAYER, player);
            HandType handType = (HandType)usedHand;
            frame.addContext(EventContextKeys.USED_HAND, handType);
            frame.addContext(EventContextKeys.USED_ITEM, player.itemInHand(handType).createSnapshot());
            HashSet mapValues = Sets.newHashSet((Object[])new Value[]{Value.immutableOf(Keys.MAP_LOCATION, Vector2i.from((int)((int)playerIn.func_226277_ct_()), (int)((int)playerIn.func_226281_cx_()))), Value.immutableOf(Keys.MAP_WORLD, ((ServerWorld)level).key()), Value.immutableOf(Keys.MAP_TRACKS_PLAYERS, Boolean.valueOf(trackingPosition)), Value.immutableOf(Keys.MAP_UNLIMITED_TRACKING, Boolean.valueOf(unlimitedTracking)), Value.immutableOf(Keys.MAP_SCALE, Integer.valueOf(scale))});
            Optional<MapInfo> optMapInfo = SpongeCommonEventFactory.fireCreateMapEvent(frame.currentCause(), mapValues);
            if (!optMapInfo.isPresent()) {
                ItemStack itemStack = ItemStack.field_190927_a;
                return itemStack;
            }
            int id = ((MapItemSavedDataBridge)((Object)optMapInfo.get())).bridge$getMapId();
            ItemStack newMap = new ItemStack((IItemProvider)Items.field_151098_aY, 1);
            CompoundNBT nbt = newMap.func_196082_o();
            nbt.func_74768_a("map", id);
            ItemStack itemStack = newMap;
            return itemStack;
        }
    }

    @Inject(method={"func_77659_a(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/player/PlayerEntity;func_184586_b(Lnet/minecraft/util/Hand;)Lnet/minecraft/item/ItemStack;")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void impl$returnFailResultIfMapWasNotCreated(World level, PlayerEntity playerIn, Hand handIn, CallbackInfoReturnable<ActionResult<ItemStack>> cir, ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            cir.cancel();
            cir.setReturnValue((Object)ActionResult.func_226251_d_((Object)playerIn.func_184586_b(handIn)));
        }
    }
}

