/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import com.google.inject.Injector;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectProxy;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.commands.CommandSourceBridge;
import org.spongepowered.common.bridge.commands.CommandSourceProviderBridge;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.players.GameProfileCacheBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.datapack.SpongeDataPackManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.resourcepack.SpongeResourcePack;
import org.spongepowered.common.service.server.SpongeServerScopedServiceProvider;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
implements SpongeServer,
MinecraftServerBridge,
CommandSourceProviderBridge,
SubjectProxy,
CommandSourceBridge {
    @Shadow
    @Final
    private Map<RegistryKey<World>, net.minecraft.world.server.ServerWorld> field_71305_c;
    @Shadow
    @Final
    private PlayerProfileCache field_152366_X;
    @Shadow
    @Final
    private static Logger field_147145_h;
    @Shadow
    private int field_71315_w;
    @Shadow
    @Final
    protected SaveFormat.LevelSave field_71310_m;
    @Nullable
    private SpongeServerScopedServiceProvider impl$serviceProvider;
    @Nullable
    private ResourcePack impl$resourcePack;

    @Shadow
    public abstract CommandSource shadow$func_195573_aM();

    @Shadow
    public abstract Iterable<net.minecraft.world.server.ServerWorld> shadow$func_212370_w();

    @Shadow
    public abstract boolean shadow$func_71262_S();

    @Shadow
    public abstract boolean shadow$func_71278_l();

    @Shadow
    public abstract PlayerList shadow$func_184103_al();

    @Shadow
    public abstract ResourcePackList shadow$func_195561_aH();

    @Shadow
    protected abstract void shadow$func_175584_a();

    @Shadow
    protected abstract void func_240800_l__();

    @Override
    public Subject subject() {
        return SpongeCommon.game().systemSubject();
    }

    @Inject(method={"func_240784_a_(Ljava/util/function/Function;)Lnet/minecraft/server/MinecraftServer;"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void impl$setThreadOnServerPhaseTracker(Function<Thread, MinecraftServer> p_240784_0_, CallbackInfoReturnable<MinecraftServerMixin> cir, AtomicReference<MinecraftServer> atomicReference, Thread thread) {
        try {
            PhaseTracker.SERVER.setThread(thread);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not initialize the server PhaseTracker!");
        }
    }

    @Inject(method={"func_180507_a_(Ljava/lang/String;Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    private void impl$createSpongeResourcePackWrapper(String url, String hash, CallbackInfo ci) {
        if (url.length() == 0) {
            this.impl$resourcePack = null;
        } else {
            try {
                this.impl$resourcePack = SpongeResourcePack.create(url, hash);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ResourcePack bridge$getResourcePack() {
        return this.impl$resourcePack;
    }

    @Inject(method={"func_71217_p(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="HEAD")})
    private void impl$onServerTickStart(CallbackInfo ci) {
        this.scheduler().tick();
    }

    @Override
    public CommandSource bridge$getCommandSource(Cause cause) {
        return this.shadow$func_195573_aM();
    }

    @Override
    public void bridge$addToCauseStack(CauseStackManager.StackFrame frame) {
        frame.pushCause(Sponge.systemSubject());
    }

    @Inject(method={"func_71260_j()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;func_213211_a(ZZZ)Z")})
    private void impl$callUnloadWorldEvents(CallbackInfo ci) {
        for (net.minecraft.world.server.ServerWorld level : this.shadow$func_212370_w()) {
            UnloadWorldEvent unloadWorldEvent = SpongeEventFactory.createUnloadWorldEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerWorld)level);
            SpongeCommon.post(unloadWorldEvent);
        }
    }

    @Inject(method={"func_71260_j()V"}, at={@At(value="TAIL")})
    private void impl$closeLevelSaveForOtherWorlds(CallbackInfo ci) {
        for (Map.Entry<RegistryKey<World>, net.minecraft.world.server.ServerWorld> entry : this.field_71305_c.entrySet()) {
            if (entry.getKey() == World.field_234918_g_) continue;
            SaveFormat.LevelSave levelSave = ((ServerLevelBridge)entry.getValue()).bridge$getLevelSave();
            try {
                levelSave.close();
            }
            catch (IOException e) {
                field_147145_h.error("Failed to unlock level {}", (Object)levelSave.func_237282_a_(), (Object)e);
            }
        }
    }

    @Inject(method={"func_145747_a(Lnet/minecraft/util/text/ITextComponent;Ljava/util/UUID;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$useTranslatingLogger(ITextComponent input, UUID sender, CallbackInfo ci) {
        field_147145_h.info(input);
        ci.cancel();
    }

    @ModifyConstant(method={"func_71217_p(Ljava/util/function/BooleanSupplier;)V"}, constant={@Constant(intValue=6000, ordinal=0)})
    private int getSaveTickInterval(int tickInterval) {
        if (!this.shadow$func_71262_S()) {
            return tickInterval;
        }
        if (!this.shadow$func_71278_l()) {
            return this.field_71315_w + 1;
        }
        int autoPlayerSaveInterval = SpongeConfigs.getCommon().get().world.playerAutoSaveInterval;
        if (autoPlayerSaveInterval > 0 && this.field_71315_w % autoPlayerSaveInterval == 0) {
            this.shadow$func_184103_al().func_72389_g();
        }
        this.func_213211_a(true, false, false);
        return this.field_71315_w + 1;
    }

    @Overwrite
    public boolean func_213211_a(boolean suppressLog, boolean flush, boolean isForced) {
        boolean var0 = false;
        for (net.minecraft.world.server.ServerWorld world : this.shadow$func_212370_w()) {
            int autoSaveInterval;
            boolean canSaveAtAll;
            SerializationBehavior serializationBehavior = ((PrimaryLevelDataBridge)world.func_72912_H()).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
            InheritableConfigHandle<WorldConfig> adapter = ((PrimaryLevelDataBridge)world.func_72912_H()).bridge$configAdapter();
            boolean log = ((WorldConfig)adapter.get()).world.logAutoSave;
            if (!this.shadow$func_71278_l() || this.field_71315_w % 6000 == 0 || isForced) {
                ((PrimaryLevelDataBridge)world.func_72912_H()).bridge$configAdapter().save();
            }
            if (!(canSaveAtAll = serializationBehavior != SerializationBehavior.NONE) || this.bridge$performAutosaveChecks() && !isForced && ((autoSaveInterval = ((WorldConfig)adapter.get()).world.autoSaveInterval) <= 0 || serializationBehavior != SerializationBehavior.AUTOMATIC || this.field_71315_w % autoSaveInterval != 0)) continue;
            if (log) {
                field_147145_h.info("Saving chunks for level '{}'/{}", (Object)world, (Object)world.func_234923_W_().func_240901_a_());
            }
            world.func_217445_a((IProgressUpdate)null, flush, world.field_73058_d && !isForced);
            var0 = true;
        }
        if (isForced || this.field_71315_w % 6000 == 0) {
            ((GameProfileCacheBridge)this.field_152366_X).bridge$setCanSave(true);
            this.field_152366_X.func_152658_c();
            ((GameProfileCacheBridge)this.field_152366_X).bridge$setCanSave(false);
        }
        return var0;
    }

    @Overwrite
    public void func_147139_a(Difficulty difficulty, boolean forceDifficulty) {
        for (net.minecraft.world.server.ServerWorld world : this.shadow$func_212370_w()) {
            this.bridge$setDifficulty(world, difficulty, forceDifficulty);
        }
    }

    @Override
    public void bridge$setDifficulty(net.minecraft.world.server.ServerWorld world, Difficulty newDifficulty, boolean forceDifficulty) {
        if (world.func_72912_H().func_176123_z() && !forceDifficulty) {
            return;
        }
        if (forceDifficulty) {
            if (!((PrimaryLevelDataBridge)world.func_72912_H()).bridge$customDifficulty()) {
                ((PrimaryLevelDataBridge)world.func_72912_H()).bridge$forceSetDifficulty(newDifficulty);
            }
        } else {
            ((ServerWorldInfo)world.func_72912_H()).func_230409_a_(newDifficulty);
        }
    }

    @Override
    public void bridge$initServices(Game game, Injector injector) {
        if (this.impl$serviceProvider == null) {
            this.impl$serviceProvider = new SpongeServerScopedServiceProvider(this, game, injector);
            this.impl$serviceProvider.init();
        }
    }

    @Override
    public SpongeServerScopedServiceProvider bridge$getServiceProvider() {
        return this.impl$serviceProvider;
    }

    @Inject(method={"func_240780_a_(Ljava/util/Collection;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="HEAD")})
    public void impl$reloadResources(Collection<String> datapacksToLoad, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        SpongeDataPackManager.INSTANCE.callRegisterDataPackValueEvents(this.field_71310_m.func_237285_a_(FolderName.field_237251_g_), datapacksToLoad);
        this.shadow$func_195561_aH().func_198983_a();
    }

    @Inject(method={"func_240780_a_(Ljava/util/Collection;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="RETURN")})
    public void impl$serializeDelayedDataPack(Collection<String> datapacksToLoad, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        ((CompletableFuture)cir.getReturnValue()).thenAccept(v -> SpongeDataPackManager.INSTANCE.serializeDelayedDataPack(DataPackTypes.WORLD));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

