/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SDisplayObjectivePacket;
import net.minecraft.network.play.server.SScoreboardObjectivePacket;
import net.minecraft.network.play.server.STeamsPacket;
import net.minecraft.network.play.server.SUpdateScorePacket;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.scores.PlayerTeamAccessor;
import org.spongepowered.common.accessor.world.scores.ScoreboardAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.bridge.world.scores.ScoreBridge;
import org.spongepowered.common.scoreboard.SpongeDisplaySlot;
import org.spongepowered.common.scoreboard.SpongeObjective;
import org.spongepowered.common.scoreboard.SpongeScore;

@Mixin(value={ServerScoreboard.class})
public abstract class ServerScoreboardMixin
extends net.minecraft.scoreboard.Scoreboard
implements ServerScoreboardBridge {
    private final List<ServerPlayerEntity> impl$players = new ArrayList<ServerPlayerEntity>();

    @Shadow
    protected abstract void shadow$func_96551_b();

    @Override
    public void bridge$updateDisplaySlot(@Nullable Objective objective, DisplaySlot displaySlot) throws IllegalStateException {
        this.bridge$updateDisplaySlot(objective, ((SpongeDisplaySlot)displaySlot).index());
    }

    @Override
    public void bridge$updateDisplaySlot(@Nullable Objective objective, int slot) throws IllegalStateException {
        if (objective != null && !objective.scoreboards().contains(this)) {
            throw new IllegalStateException("Attempting to set an objective's display slot that does not exist on this scoreboard!");
        }
        ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives()[slot] = objective == null ? null : ((SpongeObjective)objective).getObjectiveFor(this);
        this.bridge$sendToPlayers((IPacket<?>)new SDisplayObjectivePacket(slot, ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives()[slot]));
    }

    @Override
    public void bridge$addObjective(Objective objective) {
        ScoreObjective nmsObjective = this.func_96518_b(objective.name());
        if (nmsObjective != null) {
            throw new IllegalArgumentException(String.format("An objective with the name '%s' already exists!", objective.name()));
        }
        ScoreObjective scoreObjective = ((SpongeObjective)objective).getObjectiveFor(this);
        List<ScoreObjective> objectives = ((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().get(objective.criterion());
        if (objectives == null) {
            objectives = new ArrayList<ScoreObjective>();
            ((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().put((ScoreCriteria)objective.criterion(), objectives);
        }
        objectives.add(scoreObjective);
        ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().put(objective.name(), scoreObjective);
        this.func_96522_a(scoreObjective);
        ((SpongeObjective)objective).updateScores(this);
    }

    @Override
    public Optional<Objective> bridge$getObjective(String name) {
        ScoreObjective objective = this.func_96518_b(name);
        return Optional.ofNullable(objective == null ? null : ((ObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    @Override
    public Optional<Objective> bridge$getObjective(DisplaySlot slot) {
        ScoreObjective objective = ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives()[((SpongeDisplaySlot)slot).index()];
        if (objective != null) {
            return Optional.of(((ObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return Optional.empty();
    }

    @Override
    public Set<Objective> bridge$getObjectivesByCriterion(Criterion criterion) {
        if (((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().containsKey(criterion)) {
            return ((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().get(criterion).stream().map(objective -> ((ObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
        }
        return new HashSet<Objective>();
    }

    @Override
    public void bridge$removeObjective(Objective objective) {
        ScoreObjective scoreObjective = ((SpongeObjective)objective).getObjectiveFor(this);
        ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().remove(scoreObjective.func_96679_b());
        for (int i = 0; i < 19; ++i) {
            if (this.func_96539_a(i) != scoreObjective) continue;
            this.func_96530_a(i, null);
        }
        this.bridge$sendToPlayers((IPacket<?>)new SScoreboardObjectivePacket(scoreObjective, 1));
        List<ScoreObjective> list = ((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().get(scoreObjective.func_96680_c());
        if (list != null) {
            list.remove(scoreObjective);
        }
        for (Map<ScoreObjective, Score> scoreMap : ((ScoreboardAccessor)((Object)this)).accessor$playerScores().values()) {
            Score score = scoreMap.remove(scoreObjective);
            if (score == null) continue;
            ((ScoreBridge)score).bridge$getSpongeScore().removeScoreFor(scoreObjective);
        }
        this.shadow$func_96551_b();
        ((SpongeObjective)objective).removeObjectiveFor(this);
    }

    @Override
    public void bridge$registerTeam(Team spongeTeam) {
        ScorePlayerTeam team = (ScorePlayerTeam)spongeTeam;
        if (this.func_96508_e(spongeTeam.name()) != null) {
            throw new IllegalArgumentException(String.format("A team with the name '%s' already exists!", spongeTeam.name()));
        }
        if (((PlayerTeamAccessor)team).accessor$scoreboard() != null) {
            throw new IllegalArgumentException("The passed in team is already registered to a scoreboard!");
        }
        ((PlayerTeamAccessor)team).accessor$scoreboard(this);
        ((ScoreboardAccessor)((Object)this)).accessor$teamsByName().put(team.func_96661_b(), team);
        for (String entry : team.func_96670_d()) {
            this.func_197901_a(entry, team);
        }
        this.func_96523_a(team);
    }

    @Override
    public void bridge$sendToPlayers(IPacket<?> packet) {
        for (ServerPlayerEntity player : this.impl$players) {
            player.field_71135_a.func_147359_a(packet);
        }
    }

    @Override
    public void bridge$addPlayer(ServerPlayerEntity player, boolean sendPackets) {
        this.impl$players.add(player);
        if (sendPackets) {
            for (ScorePlayerTeam team : this.func_96525_g()) {
                player.field_71135_a.func_147359_a((IPacket)new STeamsPacket(team, 0));
            }
            for (ScoreObjective objective : this.func_96514_c()) {
                player.field_71135_a.func_147359_a((IPacket)new SScoreboardObjectivePacket(objective, 0));
                for (int i = 0; i < 19; ++i) {
                    if (this.func_96539_a(i) != objective) continue;
                    player.field_71135_a.func_147359_a((IPacket)new SDisplayObjectivePacket(i, objective));
                }
                for (Score score : this.func_96534_i(objective)) {
                    SUpdateScorePacket packetIn = new SUpdateScorePacket(ServerScoreboard.Action.CHANGE, score.func_96645_d().func_96679_b(), score.func_96653_e(), score.func_96652_c());
                    player.field_71135_a.func_147359_a((IPacket)packetIn);
                }
            }
        }
    }

    @Override
    public void bridge$removePlayer(ServerPlayerEntity player, boolean sendPackets) {
        this.impl$players.remove(player);
        if (sendPackets) {
            this.impl$removeScoreboard(player);
        }
    }

    public ScoreObjective func_199868_a(String name, ScoreCriteria criteria, ITextComponent text, ScoreCriteria.RenderType type) {
        SpongeObjective objective = new SpongeObjective(name, (Criterion)criteria);
        objective.setDisplayMode((ObjectiveDisplayMode)type);
        objective.setDisplayName(SpongeAdventure.asAdventure(text));
        ((Scoreboard)((Object)this)).addObjective(objective);
        return objective.getObjectiveFor(this);
    }

    public void func_96519_k(ScoreObjective objective) {
        this.bridge$removeObjective(((ObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    public void func_96511_d(ScorePlayerTeam team) {
        super.func_96511_d(team);
        ((PlayerTeamAccessor)team).accessor$scoreboard(null);
    }

    public Score func_96529_a(String name, ScoreObjective objective) {
        return ((SpongeScore)((ObjectiveBridge)objective).bridge$getSpongeObjective().findOrCreateScore((Component)LegacyComponentSerializer.legacySection().deserialize(name))).getScoreFor(objective);
    }

    public void func_178822_d(String name, ScoreObjective objective) {
        LegacyComponentSerializer lcs = LegacyComponentSerializer.legacySection();
        if (objective != null) {
            SpongeObjective spongeObjective = ((ObjectiveBridge)objective).bridge$getSpongeObjective();
            Optional<org.spongepowered.api.scoreboard.Score> score = spongeObjective.findScore((Component)lcs.deserialize(name));
            if (score.isPresent()) {
                spongeObjective.removeScore(score.get());
            } else {
                SpongeCommon.logger().warn("Objective {} did have have the score", (Object)name);
            }
        } else {
            TextComponent textName = lcs.deserialize(name);
            for (ScoreObjective scoreObjective : this.func_96514_c()) {
                ((ObjectiveBridge)scoreObjective).bridge$getSpongeObjective().removeScore((Component)textName);
            }
        }
    }

    @Redirect(method={"func_96536_a(Lnet/minecraft/scoreboard/Score;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_148540_a(Lnet/minecraft/network/IPacket;)V"))
    private void onUpdateScoreValue(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"func_96536_a(Lnet/minecraft/scoreboard/Score;)V"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean onUpdateScoreValue(Set<?> set, Object object) {
        return true;
    }

    @Redirect(method={"func_96516_a(Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_148540_a(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updatePlayersOnRemoval(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"func_178820_a(Ljava/lang/String;Lnet/minecraft/scoreboard/ScoreObjective;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_148540_a(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updatePlayersOnRemovalOfObjective(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Inject(method={"func_96522_a(Lnet/minecraft/scoreboard/ScoreObjective;)V"}, at={@At(value="RETURN")})
    private void impl$UpdatePlayersScoreObjective(ScoreObjective objective, CallbackInfo ci) {
        this.bridge$sendToPlayers((IPacket<?>)new SScoreboardObjectivePacket(objective, 0));
    }

    @Overwrite
    public void func_96530_a(int slot, @Nullable ScoreObjective objective) {
        SpongeObjective apiObjective = objective == null ? null : ((ObjectiveBridge)objective).bridge$getSpongeObjective();
        this.bridge$updateDisplaySlot((Objective)apiObjective, slot);
    }

    @Redirect(method={"func_197901_a(Ljava/lang/String;Lnet/minecraft/scoreboard/ScorePlayerTeam;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_148540_a(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updatePlayersOnPlayerAdd(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"func_96512_b(Ljava/lang/String;Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_148540_a(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updatePlayersOnPlayerRemoval(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"func_199869_b(Lnet/minecraft/scoreboard/ScoreObjective;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_148540_a(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updatePlayersOnObjectiveDisplay(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"func_199869_b(Lnet/minecraft/scoreboard/ScoreObjective;)V"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$alwaysReturnTrueForObjectivesDisplayName(Set<ScoreObjective> set, Object object) {
        return true;
    }

    @Redirect(method={"func_96533_c(Lnet/minecraft/scoreboard/ScoreObjective;)V"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$alwaysReturnTrueForObjectiveRemoval(Set<ScoreObjective> set, Object object) {
        return true;
    }

    @Redirect(method={"func_96523_a(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_148540_a(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updateAllPlayersOnTeamCreation(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"func_96538_b(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_148540_a(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updateAllPlayersOnTeamInfo(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"func_96513_c(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_148540_a(Lnet/minecraft/network/IPacket;)V"))
    private void impl$updateAllPlayersOnTeamRemoval(PlayerList manager, IPacket<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"func_96549_e(Lnet/minecraft/scoreboard/ScoreObjective;)V"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    private Iterator impl$useOurScoreboardForPlayers(List list) {
        return this.impl$players.iterator();
    }

    @Redirect(method={"func_96546_g(Lnet/minecraft/scoreboard/ScoreObjective;)V"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    private Iterator impl$useOurScoreboardForPlayersOnRemoval(List list) {
        return this.impl$players.iterator();
    }

    private void impl$removeScoreboard(ServerPlayerEntity player) {
        this.impl$removeTeams(player);
        this.impl$removeObjectives(player);
    }

    private void impl$removeTeams(ServerPlayerEntity player) {
        for (ScorePlayerTeam team : this.func_96525_g()) {
            player.field_71135_a.func_147359_a((IPacket)new STeamsPacket(team, 1));
        }
    }

    private void impl$removeObjectives(ServerPlayerEntity player) {
        for (ScoreObjective objective : this.func_96514_c()) {
            player.field_71135_a.func_147359_a((IPacket)new SScoreboardObjectivePacket(objective, 1));
        }
    }
}

