/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.chunk.ChunkEvent;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.level.ServerChunkCacheAccessor;
import org.spongepowered.common.bridge.world.DistanceManagerBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.bridge.world.server.ChunkMapBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DirectionUtil;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ChunkManager.class})
public abstract class ChunkMapMixin
implements ChunkMapBridge {
    @Shadow
    @Final
    private ServerWorld field_219255_i;

    @Override
    public DistanceManagerBridge bridge$distanceManager() {
        return (DistanceManagerBridge)((ServerChunkCacheAccessor)this.field_219255_i.func_72863_F()).accessor$distanceManager();
    }

    @Redirect(method={"func_219229_a(Lnet/minecraft/world/chunk/IChunk;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/village/PointOfInterestManager;func_219112_a(Lnet/minecraft/util/math/ChunkPos;)V"))
    private void impl$useSerializationBehaviorForPOI(PointOfInterestManager pointOfInterestManager, ChunkPos p_219112_1_) {
        PrimaryLevelDataBridge infoBridge = (PrimaryLevelDataBridge)this.field_219255_i.func_72912_H();
        SerializationBehavior serializationBehavior = infoBridge.bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
        if (serializationBehavior == SerializationBehavior.AUTOMATIC || serializationBehavior == SerializationBehavior.MANUAL) {
            pointOfInterestManager.func_219112_a(p_219112_1_);
        }
    }

    @Redirect(method={"func_219229_a(Lnet/minecraft/world/chunk/IChunk;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/storage/ChunkSerializer;func_222645_a(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/world/chunk/IChunk;)Lnet/minecraft/nbt/CompoundNBT;"))
    private CompoundNBT impl$useSerializationBehaviorForChunkSave(ServerWorld worldIn, IChunk chunkIn) {
        PrimaryLevelDataBridge infoBridge = (PrimaryLevelDataBridge)this.field_219255_i.func_72912_H();
        SerializationBehavior serializationBehavior = infoBridge.bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
        if (serializationBehavior == SerializationBehavior.AUTOMATIC || serializationBehavior == SerializationBehavior.MANUAL) {
            return ChunkSerializer.func_222645_a((ServerWorld)worldIn, (IChunk)chunkIn);
        }
        return null;
    }

    @Redirect(method={"func_219229_a(Lnet/minecraft/world/chunk/IChunk;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ChunkManager;func_219100_a(Lnet/minecraft/util/math/ChunkPos;Lnet/minecraft/nbt/CompoundNBT;)V"))
    private void impl$doNotWriteIfWeHaveNoData(ChunkManager chunkManager, ChunkPos pos, CompoundNBT compound) {
        if (compound == null) {
            return;
        }
        chunkManager.func_219100_a(pos, compound);
    }

    @Redirect(method={"func_219185_a(Lnet/minecraft/world/server/ChunkHolder;Ljava/util/concurrent/CompletableFuture;JLnet/minecraft/world/chunk/IChunk;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;func_217466_a(Lnet/minecraft/world/chunk/Chunk;)V"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/server/ChunkManager;func_219229_a(Lnet/minecraft/world/chunk/IChunk;)Z")))
    private void impl$onSetUnloaded(ServerWorld level, Chunk chunk) {
        Vector3i chunkPos = new Vector3i(chunk.func_76632_l().field_77276_a, 0, chunk.func_76632_l().field_77275_b);
        if (ShouldFire.CHUNK_EVENT_UNLOAD_PRE) {
            ChunkEvent.Unload.Pre pre = SpongeEventFactory.createChunkEventUnloadPre(PhaseTracker.getInstance().currentCause(), (WorldChunk)chunk, chunkPos, (ResourceKey)this.field_219255_i.func_234923_W_().func_240901_a_());
            SpongeCommon.post(pre);
        }
        level.func_217466_a(chunk);
        for (Direction dir : Constants.Chunk.CARDINAL_DIRECTIONS) {
            Vector3i neighborPos = chunkPos.add(dir.asBlockOffset());
            IChunk neighbor = this.field_219255_i.func_217353_a(neighborPos.x(), neighborPos.z(), ChunkStatus.field_223226_a_, false);
            if (!(neighbor instanceof Chunk)) continue;
            int index = DirectionUtil.directionToIndex(dir);
            int oppositeIndex = DirectionUtil.directionToIndex(dir.opposite());
            ((LevelChunkBridge)chunk).bridge$setNeighborChunk(index, null);
            ((LevelChunkBridge)neighbor).bridge$setNeighborChunk(oppositeIndex, null);
        }
        if (ShouldFire.CHUNK_EVENT_UNLOAD_POST) {
            ChunkEvent.Unload.Post post = SpongeEventFactory.createChunkEventUnloadPost(PhaseTracker.getInstance().currentCause(), chunkPos, (ResourceKey)this.field_219255_i.func_234923_W_().func_240901_a_());
            SpongeCommon.post(post);
        }
    }

    @Inject(method={"func_219229_a(Lnet/minecraft/world/chunk/IChunk;)Z"}, at={@At(value="RETURN")})
    private void impl$onSaved(IChunk var1, CallbackInfoReturnable<Boolean> cir) {
        if (ShouldFire.CHUNK_EVENT_SAVE_POST) {
            Vector3i chunkPos = new Vector3i(var1.func_76632_l().field_77276_a, 0, var1.func_76632_l().field_77275_b);
            ChunkEvent.Save.Post postSave = SpongeEventFactory.createChunkEventSavePost(PhaseTracker.getInstance().currentCause(), chunkPos, (ResourceKey)this.field_219255_i.func_234923_W_().func_240901_a_());
            SpongeCommon.post(postSave);
        }
    }

    @Inject(method={"func_219229_a(Lnet/minecraft/world/chunk/IChunk;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSave(IChunk var1, CallbackInfoReturnable<Boolean> cir) {
        if (var1 instanceof WorldChunk && ShouldFire.CHUNK_EVENT_SAVE_PRE) {
            Vector3i chunkPos = new Vector3i(var1.func_76632_l().field_77276_a, 0, var1.func_76632_l().field_77275_b);
            ChunkEvent.Save.Pre postSave = SpongeEventFactory.createChunkEventSavePre(PhaseTracker.getInstance().currentCause(), (WorldChunk)var1, chunkPos, (ResourceKey)this.field_219255_i.func_234923_W_().func_240901_a_());
            SpongeCommon.post(postSave);
            if (postSave.isCancelled()) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Redirect(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;func_177417_c(Z)V"), slice=@Slice(from=@At(value="INVOKE", remap=false, target="Lit/unimi/dsi/fastutil/longs/LongSet;add(J)Z"), to=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;func_147448_a(Ljava/util/Collection;)V")))
    private void impl$onLoad(Chunk levelChunk, boolean loaded) {
        levelChunk.func_177417_c(true);
        Vector3i chunkPos = new Vector3i(levelChunk.func_76632_l().field_77276_a, 0, levelChunk.func_76632_l().field_77275_b);
        if (ShouldFire.CHUNK_EVENT_LOAD) {
            ChunkEvent.Load loadEvent = SpongeEventFactory.createChunkEventLoad(PhaseTracker.getInstance().currentCause(), (WorldChunk)levelChunk, chunkPos, (ResourceKey)this.field_219255_i.func_234923_W_().func_240901_a_());
            SpongeCommon.post(loadEvent);
        }
        for (Direction dir : Constants.Chunk.CARDINAL_DIRECTIONS) {
            Vector3i neighborPos = chunkPos.add(dir.asBlockOffset());
            IChunk neighbor = this.field_219255_i.func_217353_a(neighborPos.x(), neighborPos.z(), ChunkStatus.field_223226_a_, false);
            if (neighbor instanceof ChunkPrimerWrapper) {
                neighbor = ((ChunkPrimerWrapper)neighbor).func_217336_u();
            }
            if (!(neighbor instanceof Chunk)) continue;
            int index = DirectionUtil.directionToIndex(dir);
            int oppositeIndex = DirectionUtil.directionToIndex(dir.opposite());
            ((LevelChunkBridge)levelChunk).bridge$setNeighborChunk(index, (Chunk)neighbor);
            ((LevelChunkBridge)neighbor).bridge$setNeighborChunk(oppositeIndex, levelChunk);
        }
    }
}

