/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.TicketManager;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.Ticket;
import org.spongepowered.api.world.server.TicketType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.accessor.server.level.TicketAccessor;
import org.spongepowered.common.bridge.world.DistanceManagerBridge;
import org.spongepowered.common.bridge.world.server.TicketBridge;
import org.spongepowered.common.bridge.world.server.TicketTypeBridge;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={TicketManager.class})
public abstract class DistanceManagerMixin
implements DistanceManagerBridge {
    @Shadow
    @Final
    private Long2ObjectOpenHashMap<SortedArraySet<net.minecraft.world.server.Ticket<?>>> field_219377_e;
    @Shadow
    private long field_219389_q;

    @Shadow
    private void shadow$func_219347_a(long chunkpos, net.minecraft.world.server.Ticket<?> ticket) {
    }

    @Shadow
    protected abstract void shadow$func_219349_b(long var1, net.minecraft.world.server.Ticket<?> var3);

    @Override
    public boolean bridge$checkTicketValid(Ticket<?> ticket) {
        net.minecraft.world.server.Ticket nativeTicket = (net.minecraft.world.server.Ticket)ticket;
        SortedArraySet ticketsForChunk = (SortedArraySet)this.field_219377_e.get(((TicketBridge)((Object)ticket)).bridge$chunkPosition());
        if (ticketsForChunk != null && ticketsForChunk.contains((Object)nativeTicket)) {
            return !((TicketAccessor)((Object)ticket)).invoker$timedOut(this.field_219389_q);
        }
        return false;
    }

    @Override
    public Ticks bridge$timeLeft(Ticket<?> ticket) {
        if (this.bridge$checkTicketValid(ticket)) {
            long ticksElapsed = this.field_219389_q - ((TicketAccessor)((Object)ticket)).accessor$createdTick();
            return new SpongeTicks(Math.max(0L, ((net.minecraft.world.server.Ticket)ticket).func_219479_a().func_223184_b() - ticksElapsed));
        }
        return Ticks.zero();
    }

    @Override
    public boolean bridge$renewTicket(Ticket<?> ticket) {
        if (this.bridge$checkTicketValid(ticket)) {
            net.minecraft.world.server.Ticket nativeTicket = (net.minecraft.world.server.Ticket)ticket;
            ((TicketAccessor)((Object)ticket)).invoker$setCreatedTick(this.field_219389_q + nativeTicket.func_219479_a().func_223184_b());
            return true;
        }
        return false;
    }

    @Override
    public <S, T> Optional<Ticket<T>> bridge$registerTicket(ServerWorld world, TicketType<T> ticketType, Vector3i pos, T value, int distanceLimit) {
        int distance = MathHelper.func_76125_a((int)(34 - distanceLimit), (int)0, (int)33);
        net.minecraft.world.server.TicketType type = (net.minecraft.world.server.TicketType)ticketType;
        net.minecraft.world.server.Ticket ticketToRequest = TicketAccessor.accessor$createInstance(type, distance, ((TicketTypeBridge)((Object)ticketType)).bridge$convertToNativeType(value));
        this.shadow$func_219347_a(VecHelper.toChunkPos(pos).func_201841_a(), ticketToRequest);
        return Optional.of(((TicketBridge)ticketToRequest).bridge$retrieveAppropriateTicket());
    }

    @Override
    public boolean bridge$releaseTicket(Ticket<?> ticket) {
        if (this.bridge$checkTicketValid(ticket)) {
            this.shadow$func_219349_b(((TicketBridge)((Object)ticket)).bridge$chunkPosition(), (net.minecraft.world.server.Ticket)ticket);
            return true;
        }
        return false;
    }

    @Override
    public <T> Collection<Ticket<T>> bridge$tickets(TicketType<T> ticketType) {
        return this.field_219377_e.values().stream().flatMap(x -> x.stream().filter(ticket -> ticket.func_219479_a().equals(ticketType))).map(x -> (Ticket)x).collect(Collectors.toList());
    }

    @Inject(method={"func_219347_a(JLnet/minecraft/world/server/Ticket;)V"}, at={@At(value="HEAD")})
    private void impl$addChunkPosToTicket(long chunkPos, net.minecraft.world.server.Ticket<?> ticket, CallbackInfo ci) {
        ((TicketBridge)ticket).bridge$setChunkPosition(chunkPos);
    }

    @Redirect(method={"func_219347_a(JLnet/minecraft/world/server/Ticket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/Ticket;func_229861_a_(J)V"))
    private void impl$setParentTicketIfApplicable(net.minecraft.world.server.Ticket<?> storedTicket, long ticketTickCounter, long chunkPosAsLong, net.minecraft.world.server.Ticket<?> originalTicket) {
        if (storedTicket != originalTicket) {
            ((TicketBridge)originalTicket).bridge$setParentTicket(storedTicket);
        }
        ((TicketAccessor)storedTicket).invoker$setCreatedTick(ticketTickCounter);
    }
}

