/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import java.util.Set;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.world.BossInfo;
import net.minecraft.world.server.ServerBossInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.mixin.core.world.BossEventMixin;

@Mixin(value={ServerBossInfo.class})
public abstract class ServerBossEventMixin
extends BossEventMixin
implements BossBar.Listener {
    private static final float EPSILON = 0.01f;
    private float impl$lastSentProgress = 0.0f;
    @Shadow
    @Final
    private Set<ServerPlayerEntity> field_186762_h;
    @Shadow
    private boolean field_186764_j;

    @Shadow
    protected abstract void func_186759_a(SUpdateBossInfoPacket.Operation var1);

    @Override
    public void bridge$setAdventure(BossBar adventure) {
        BossBar oldAdventure = this.impl$adventure;
        super.bridge$setAdventure(adventure);
        if (oldAdventure != adventure) {
            if (oldAdventure != null) {
                oldAdventure.removeListener((BossBar.Listener)this);
            }
            adventure.addListener((BossBar.Listener)this);
            this.field_186749_a = null;
            this.field_186750_b = Float.MIN_VALUE;
            this.field_186751_c = null;
            this.field_186752_d = null;
        }
    }

    @Override
    public void bridge$replacePlayer(ServerPlayerEntity oldPlayer, ServerPlayerEntity newPlayer) {
        super.bridge$replacePlayer(oldPlayer, newPlayer);
        if (this.field_186762_h.remove(oldPlayer)) {
            this.field_186762_h.add(newPlayer);
        }
    }

    @Inject(method={"func_186741_a(Z)Lnet/minecraft/world/BossInfo;"}, at={@At(value="HEAD")})
    private void impl$forceDarkenSkyUpdate(boolean darkenSky, CallbackInfoReturnable<BossInfo> ci) {
        this.field_186753_e = !darkenSky;
    }

    @Inject(method={"func_186742_b(Z)Lnet/minecraft/world/BossInfo;"}, at={@At(value="HEAD")})
    private void forcePlayEndBossMusicUpdate(boolean endBossMusic, CallbackInfoReturnable<BossInfo> ci) {
        this.field_186754_f = !endBossMusic;
    }

    @Inject(method={"func_186743_c(Z)Lnet/minecraft/world/BossInfo;"}, at={@At(value="HEAD")})
    private void forceCreateFogUpdate(boolean createFog, CallbackInfoReturnable<BossInfo> ci) {
        this.field_186755_g = !createFog;
    }

    @Redirect(method={"func_186735_a(F)V", "func_186745_a(Lnet/minecraft/world/BossInfo$Color;)V", "func_186746_a(Lnet/minecraft/world/BossInfo$Overlay;)V", "func_186741_a(Z)Lnet/minecraft/world/BossInfo;", "func_186742_b(Z)Lnet/minecraft/world/BossInfo;", "func_186743_c(Z)Lnet/minecraft/world/BossInfo;", "func_186739_a(Lnet/minecraft/util/text/ITextComponent;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerBossInfo;func_186759_a(Lnet/minecraft/network/play/server/SUpdateBossInfoPacket$Operation;)V"))
    private void redirectUpdatePacket(ServerBossInfo $this, SUpdateBossInfoPacket.Operation op) {
    }

    public void bossBarNameChanged(BossBar bar, Component oldName, Component newName) {
        this.func_186759_a(SUpdateBossInfoPacket.Operation.UPDATE_NAME);
    }

    public void bossBarProgressChanged(BossBar bar, float oldProgress, float newProgress) {
        if (Math.abs(newProgress - this.impl$lastSentProgress) > 0.01f) {
            this.impl$lastSentProgress = newProgress;
            this.func_186759_a(SUpdateBossInfoPacket.Operation.UPDATE_PCT);
        }
    }

    public void bossBarColorChanged(BossBar bar, BossBar.Color oldColor, BossBar.Color newColor) {
        this.func_186759_a(SUpdateBossInfoPacket.Operation.UPDATE_STYLE);
    }

    public void bossBarOverlayChanged(BossBar bar, BossBar.Overlay oldOverlay, BossBar.Overlay newOverlay) {
        this.func_186759_a(SUpdateBossInfoPacket.Operation.UPDATE_STYLE);
    }

    public void bossBarFlagsChanged(BossBar bar, Set<BossBar.Flag> flagsAdded, Set<BossBar.Flag> flagsRemoved) {
        this.func_186759_a(SUpdateBossInfoPacket.Operation.UPDATE_PROPERTIES);
    }

    @Inject(method={"func_186760_a(Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at={@At(value="TAIL")})
    private void impl$addPlayer(ServerPlayerEntity player, CallbackInfo ci) {
        if (!this.field_186762_h.isEmpty() && this.field_186764_j) {
            SpongeAdventure.registerBossBar((ServerBossInfo)this);
        }
    }

    @Inject(method={"func_186761_b(Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at={@At(value="TAIL")})
    private void impl$removePlayer(ServerPlayerEntity player, CallbackInfo ci) {
        if (this.field_186762_h.isEmpty()) {
            SpongeAdventure.unregisterBossBar((ServerBossInfo)this);
        }
    }

    @Inject(method={"func_201360_b()V"}, at={@At(value="HEAD")})
    private void impl$removeAllPlayers(CallbackInfo ci) {
        SpongeAdventure.unregisterBossBar((ServerBossInfo)this);
    }

    @Inject(method={"func_186758_d(Z)V"}, at={@At(value="HEAD")})
    private void impl$setVisible(boolean visible, CallbackInfo ci) {
        if (!this.field_186762_h.isEmpty()) {
            if (visible) {
                SpongeAdventure.registerBossBar((ServerBossInfo)this);
            } else {
                SpongeAdventure.unregisterBossBar((ServerBossInfo)this);
            }
        }
    }
}

