/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.server.CustomServerBossInfoManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.JukeboxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.LightningEvent;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.event.sound.PlaySoundEvent;
import org.spongepowered.api.event.world.ChangeWeatherEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.level.PlatformServerLevelBridge;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.level.LevelMixin;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={net.minecraft.world.server.ServerWorld.class})
public abstract class ServerLevelMixin
extends LevelMixin
implements ServerLevelBridge,
PlatformServerLevelBridge,
ResourceKeyBridge {
    @Shadow
    @Final
    private IServerWorldInfo field_241103_E_;
    private final long[] impl$recentTickTimes = new long[100];
    private SaveFormat.LevelSave impl$levelSave;
    private CustomServerBossInfoManager impl$bossBarManager;
    private IChunkStatusListener impl$chunkStatusListener;
    private Map<net.minecraft.entity.Entity, org.spongepowered.math.vector.Vector3d> impl$rotationUpdates;
    private Weather impl$prevWeather;
    private boolean impl$isManualSave = false;
    private long impl$preTickTime = 0L;

    @Shadow
    @Nonnull
    public abstract MinecraftServer shadow$func_73046_m();

    @Shadow
    protected abstract void shadow$func_73042_a();

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/storage/SaveFormat$LevelSave;Lnet/minecraft/world/storage/IServerWorldInfo;Lnet/minecraft/util/RegistryKey;Lnet/minecraft/world/DimensionType;Lnet/minecraft/world/chunk/listener/IChunkStatusListener;Lnet/minecraft/world/gen/ChunkGenerator;ZJLjava/util/List;Z)V"}, at={@At(value="TAIL")})
    private void impl$cacheLevelSave(MinecraftServer p_i241885_1_, Executor p_i241885_2_, SaveFormat.LevelSave p_i241885_3_, IServerWorldInfo p_i241885_4_, RegistryKey<World> p_i241885_5_, DimensionType p_i241885_6_, IChunkStatusListener p_i241885_7_, ChunkGenerator p_i241885_8_, boolean p_i241885_9_, long p_i241885_10_, List<ISpecialSpawner> p_i241885_12_, boolean p_i241885_13_, CallbackInfo ci) {
        this.impl$levelSave = p_i241885_3_;
        this.impl$chunkStatusListener = p_i241885_7_;
        this.impl$rotationUpdates = new Object2ObjectOpenHashMap();
        this.impl$prevWeather = ((ServerWorld)((Object)this)).weather();
    }

    @Redirect(method={"func_72905_C()J"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/IServerConfiguration;func_230418_z_()Lnet/minecraft/world/gen/settings/DimensionGeneratorSettings;"))
    public DimensionGeneratorSettings impl$onGetSeed(IServerConfiguration iServerConfiguration) {
        return ((ServerWorldInfo)this.field_241103_E_).func_230418_z_();
    }

    @Override
    public SaveFormat.LevelSave bridge$getLevelSave() {
        return this.impl$levelSave;
    }

    @Override
    public IChunkStatusListener bridge$getChunkStatusListener() {
        return this.impl$chunkStatusListener;
    }

    @Override
    public boolean bridge$isLoaded() {
        if (this.bridge$isFake()) {
            return false;
        }
        net.minecraft.world.server.ServerWorld world = this.shadow$func_73046_m().func_71218_a(this.shadow$func_234923_W_());
        if (world == null) {
            return false;
        }
        return world == this;
    }

    @Override
    public void bridge$adjustDimensionLogic(DimensionType dimensionType) {
        if (this.bridge$isFake()) {
            return;
        }
        super.bridge$adjustDimensionLogic(dimensionType);
        this.impl$setWorldOnBorder();
    }

    @Override
    public CustomServerBossInfoManager bridge$getBossBarManager() {
        if (this.impl$bossBarManager == null) {
            this.impl$bossBarManager = World.field_234918_g_.equals(this.shadow$func_234923_W_()) || this.bridge$isFake() ? this.shadow$func_73046_m().func_201300_aS() : new CustomServerBossInfoManager();
        }
        return this.impl$bossBarManager;
    }

    @Override
    public void bridge$addEntityRotationUpdate(net.minecraft.entity.Entity entity, org.spongepowered.math.vector.Vector3d rotation) {
        this.impl$rotationUpdates.put(entity, rotation);
    }

    @Override
    public void bridge$updateRotation(net.minecraft.entity.Entity entityIn) {
        org.spongepowered.math.vector.Vector3d rotationUpdate = this.impl$rotationUpdates.get(entityIn);
        if (rotationUpdate != null) {
            entityIn.field_70125_A = (float)rotationUpdate.x();
            entityIn.field_70177_z = (float)rotationUpdate.y();
        }
        this.impl$rotationUpdates.remove(entityIn);
    }

    @Override
    public void bridge$triggerExplosion(org.spongepowered.api.world.explosion.Explosion explosion) {
        if (ShouldFire.EXPLOSION_EVENT_PRE) {
            ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre(PhaseTracker.getCauseStackManager().currentCause(), explosion, (ServerWorld)((Object)this));
            if (SpongeCommon.post(event)) {
                return;
            }
            explosion = event.explosion();
        }
        Explosion mcExplosion = (Explosion)explosion;
        try (Object ignored = GeneralPhase.State.EXPLOSION.createPhaseContext(PhaseTracker.SERVER).explosion((Explosion)explosion).source(explosion.sourceExplosive().isPresent() ? explosion.sourceExplosive() : this);){
            ((PhaseContext)ignored).buildAndSwitch();
            boolean shouldBreakBlocks = explosion.shouldBreakBlocks();
            mcExplosion.func_77278_a();
            mcExplosion.func_77279_a(explosion.shouldPlaySmoke());
            if (!shouldBreakBlocks) {
                mcExplosion.func_180342_d();
            }
        }
    }

    @Override
    public void bridge$setManualSave(boolean state) {
        this.impl$isManualSave = state;
    }

    @Override
    public BlockSnapshot bridge$createSnapshot(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!World.func_175701_a((BlockPos)pos)) {
            return BlockSnapshot.empty();
        }
        if (!this.func_217354_b(x >> 4, z >> 4)) {
            return BlockSnapshot.empty();
        }
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled();
        builder.world((net.minecraft.world.server.ServerWorld)this).position(new Vector3i(x, y, z));
        Chunk chunk = this.shadow$func_175726_f(pos);
        BlockState state = chunk.func_180495_p(pos);
        builder.blockState(state);
        TileEntity blockEntity = chunk.func_177424_a(pos, Chunk.CreateEntityType.CHECK);
        if (blockEntity != null) {
            TrackingUtil.addTileEntityToBuilder(blockEntity, builder);
        }
        ((LevelChunkBridge)chunk).bridge$getBlockCreatorUUID(pos).ifPresent(builder::creator);
        ((LevelChunkBridge)chunk).bridge$getBlockNotifierUUID(pos).ifPresent(builder::notifier);
        builder.flag(BlockChangeFlags.NONE);
        return builder.build();
    }

    @Override
    public ResourceKey bridge$getKey() {
        return (ResourceKey)this.shadow$func_234923_W_().func_240901_a_();
    }

    @Override
    public long[] bridge$recentTickTimes() {
        return this.impl$recentTickTimes;
    }

    @Redirect(method={"func_73042_a()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;func_240793_aU_()Lnet/minecraft/world/storage/IServerConfiguration;"))
    private IServerConfiguration impl$usePerWorldLevelDataForDragonFight(MinecraftServer server) {
        return (IServerConfiguration)this.shadow$func_72912_H();
    }

    @Redirect(method={"func_241124_a__(Lnet/minecraft/util/math/BlockPos;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerChunkProvider;func_217228_a(Lnet/minecraft/world/server/TicketType;Lnet/minecraft/util/math/ChunkPos;ILjava/lang/Object;)V"))
    private void impl$respectKeepSpawnLoaded(ServerChunkProvider serverChunkProvider, TicketType<Object> p_217228_1_, ChunkPos p_217228_2_, int p_217228_3_, Object p_217228_4_) {
        if (((ServerWorldProperties)this.shadow$func_72912_H()).performsSpawnLogic()) {
            serverChunkProvider.func_217228_a(p_217228_1_, p_217228_2_, p_217228_3_, p_217228_4_);
        }
    }

    @Overwrite
    public void func_217445_a(@Nullable IProgressUpdate progress, boolean flush, boolean skipSave) {
        Cause currentCause = Sponge.server().causeStackManager().currentCause();
        if (Sponge.eventManager().post(SpongeEventFactory.createSaveWorldEventPre(currentCause, (ServerWorld)((Object)this)))) {
            return;
        }
        ServerWorldInfo levelData = (ServerWorldInfo)this.shadow$func_72912_H();
        ServerChunkProvider chunkProvider = ((net.minecraft.world.server.ServerWorld)this).func_72863_F();
        if (!skipSave) {
            boolean canManuallySave;
            SerializationBehavior behavior = ((PrimaryLevelDataBridge)levelData).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
            if (progress != null) {
                progress.func_200210_a((ITextComponent)new TranslationTextComponent("menu.savingLevel"));
            }
            if (behavior != SerializationBehavior.NONE) {
                this.shadow$func_73042_a();
                levelData.func_230393_a_(this.func_175723_af().func_235927_t_());
                levelData.func_230414_b_(this.bridge$getBossBarManager().func_201380_c());
                this.bridge$getLevelSave().func_237288_a_(SpongeCommon.server().func_244267_aX(), (IServerConfiguration)((ServerWorldInfo)this.shadow$func_72912_H()), this.shadow$func_234923_W_() == World.field_234918_g_ ? SpongeCommon.server().func_184103_al().func_72378_q() : null);
            }
            if (progress != null) {
                progress.func_200209_c((ITextComponent)new TranslationTextComponent("menu.savingChunks"));
            }
            boolean canAutomaticallySave = !this.impl$isManualSave && behavior == SerializationBehavior.AUTOMATIC;
            boolean bl = canManuallySave = this.impl$isManualSave && behavior == SerializationBehavior.MANUAL;
            if (canAutomaticallySave || canManuallySave) {
                chunkProvider.func_217210_a(flush);
            }
            Sponge.eventManager().post(SpongeEventFactory.createSaveWorldEventPost(currentCause, (ServerWorld)((Object)this)));
        }
        this.impl$isManualSave = false;
    }

    @Inject(method={"func_72835_b(Ljava/util/function/BooleanSupplier;)V"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="FIELD", target="Lnet/minecraft/world/server/ServerWorld;field_73003_n:F", shift=At.Shift.BEFORE, ordinal=1)})
    public void impl$onSetWeatherParameters(BooleanSupplier param0, CallbackInfo ci, IProfiler var0, boolean wasRaining) {
        boolean isRaining = this.shadow$func_72896_J();
        if (this.field_73003_n != this.field_73004_o || this.field_73018_p != this.field_73017_q || wasRaining != isRaining) {
            Weather newWeather = ((ServerWorld)((Object)this)).properties().weather();
            Cause currentCause = Sponge.server().causeStackManager().currentCause();
            Transaction<Weather> weatherTransaction = new Transaction<Weather>(this.impl$prevWeather, newWeather);
            ChangeWeatherEvent event = SpongeEventFactory.createChangeWeatherEvent(currentCause, (ServerWorld)((Object)this), weatherTransaction);
            newWeather = Sponge.eventManager().post(event) ? event.weather().original() : event.weather().finalReplacement();
            this.impl$prevWeather = newWeather;
            if (newWeather.type() == WeatherTypes.CLEAR.get()) {
                this.field_241103_E_.func_76090_f(0);
                this.field_241103_E_.func_76080_g(0);
                this.field_241103_E_.func_230391_a_((int)newWeather.remainingDuration().ticks());
                this.field_241103_E_.func_76069_a(false);
                this.field_241103_E_.func_76084_b(false);
            } else {
                int newTime = (int)newWeather.remainingDuration().ticks();
                this.field_241103_E_.func_76084_b(true);
                this.field_241103_E_.func_230391_a_(0);
                this.field_241103_E_.func_76080_g(newTime);
                if (newWeather.type() == WeatherTypes.THUNDER.get()) {
                    this.field_241103_E_.func_76090_f(newTime);
                    this.field_241103_E_.func_76069_a(true);
                } else {
                    this.field_241103_E_.func_76090_f(0);
                    this.field_241103_E_.func_76069_a(false);
                }
            }
        }
    }

    @Redirect(method={"func_217441_a(Lnet/minecraft/world/chunk/Chunk;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;func_175727_C(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean impl$onBeforeThunder(net.minecraft.world.server.ServerWorld serverLevel, BlockPos param0) {
        boolean rainingAt = serverLevel.func_175727_C(param0);
        if (rainingAt) {
            LightningEvent.Pre strike = SpongeEventFactory.createLightningEventPre(Sponge.server().causeStackManager().currentCause());
            if (Sponge.eventManager().post(strike)) {
                return false;
            }
        }
        return rainingAt;
    }

    @Inject(method={"func_72835_b(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="HEAD")})
    private void impl$capturePreTickTime(BooleanSupplier param0, CallbackInfo ci) {
        this.impl$preTickTime = Util.func_211178_c();
    }

    @Inject(method={"func_72835_b(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="RETURN")})
    private void impl$capturePostTickTime(BooleanSupplier param0, CallbackInfo ci) {
        long postTickTime = Util.func_211178_c();
        this.impl$recentTickTimes[this.shadow$func_73046_m().func_71259_af() % 100] = postTickTime - this.impl$preTickTime;
    }

    private void impl$setWorldOnBorder() {
        ((WorldBorderBridge)this.shadow$func_175723_af()).bridge$setAssociatedWorld(this.bridge$getKey());
    }

    @Redirect(method={"func_72854_c()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;func_175149_v()Z"))
    private boolean impl$handleSleepingIgnored(ServerPlayerEntity serverPlayer) {
        return serverPlayer.func_175149_v() || ((ServerPlayerBridge)serverPlayer).bridge$sleepingIgnored();
    }

    @Inject(method={"func_175669_a(ILnet/minecraft/util/math/BlockPos;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwBroadcastGlobalEvent(int effectID, BlockPos pos, int pitch, CallbackInfo ci) {
        if (!this.bridge$isFake() && ShouldFire.PLAY_SOUND_EVENT_BROADCAST) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.SERVER.pushCauseFrame();){
                PlaySoundEvent.Broadcast event = SpongeCommonEventFactory.callPlaySoundBroadcastEvent(frame, this, pos, effectID);
                if (event != null && event.isCancelled()) {
                    ci.cancel();
                }
            }
        }
    }

    @Inject(method={"func_217378_a(Lnet/minecraft/entity/player/PlayerEntity;ILnet/minecraft/util/math/BlockPos;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwBroadcastEvent(PlayerEntity player, int eventID, BlockPos pos, int dataID, CallbackInfo ci) {
        if (eventID == 1010 && ShouldFire.PLAY_SOUND_EVENT_RECORD) {
            try (CauseStackManager.StackFrame frame = Sponge.server().causeStackManager().pushCauseFrame();){
                TileEntity tileEntity = this.shadow$func_175625_s(pos);
                if (tileEntity instanceof JukeboxTileEntity) {
                    JukeboxTileEntity jukebox = (JukeboxTileEntity)tileEntity;
                    ItemStack record = jukebox.func_195537_c();
                    frame.pushCause(jukebox);
                    frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(record));
                    if (!record.func_190926_b()) {
                        Optional<MusicDisc> recordProperty = ((org.spongepowered.api.item.inventory.ItemStack)record).get(Keys.MUSIC_DISC);
                        if (!recordProperty.isPresent()) {
                            return;
                        }
                        MusicDisc recordType = recordProperty.get();
                        PlaySoundEvent.Record event = SpongeCommonEventFactory.callPlaySoundRecordEvent(frame.currentCause(), jukebox, recordType, dataID);
                        if (event.isCancelled()) {
                            ci.cancel();
                        }
                    }
                }
            }
        }
    }

    @Redirect(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/village/PointOfInterestManager;func_219135_a(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/village/PointOfInterestType;)V"))
    private void impl$avoidAddingPoiUpdatesOnUnloadedWorld(PointOfInterestManager manager, BlockPos pos, PointOfInterestType type) {
        if (!SpongeCommon.server().func_240770_D_().contains(this.shadow$func_234923_W_())) {
            return;
        }
        manager.func_219135_a(pos, type);
    }

    @Inject(method={"func_217465_m(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void impl$constructPostEventForAdd(net.minecraft.entity.Entity entity, CallbackInfo cir) {
        this.impl$constructPostEventForEntityAdd(entity, null);
    }

    @Inject(method={"func_72838_d(Lnet/minecraft/entity/Entity;)Z"}, at={@At(value="HEAD")})
    private void impl$constructPostEventForEntityAdd(net.minecraft.entity.Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (!(entity instanceof EntityBridge)) {
            return;
        }
        if (!((EntityBridge)entity).bridge$isConstructing()) {
            return;
        }
        ((EntityBridge)entity).bridge$fireConstructors();
        Vector3d position = entity.func_213303_ch();
        ServerLocation location = ServerLocation.of((ServerWorld)((Object)this), position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        Vector2f rotationVector = entity.func_189653_aC();
        org.spongepowered.math.vector.Vector3d rotation = new org.spongepowered.math.vector.Vector3d(rotationVector.field_189982_i, rotationVector.field_189983_j, 0.0f);
        try (CauseStackManager.StackFrame frame = PhaseTracker.SERVER.pushCauseFrame();){
            frame.pushCause(entity);
            ConstructEntityEvent.Post construct = SpongeEventFactory.createConstructEntityEventPost(frame.currentCause(), (Entity)entity, location, rotation, (EntityType)entity.func_200600_R());
            SpongeCommon.post(construct);
        }
    }

    public String toString() {
        Optional<ResourceKey> worldTypeKey = RegistryTypes.WORLD_TYPE.get().findValueKey((WorldType)this.shadow$func_230315_m_());
        return new StringJoiner(",", net.minecraft.world.server.ServerWorld.class.getSimpleName() + "[", "]").add("key=" + this.shadow$func_234923_W_()).add("worldType=" + worldTypeKey.map(Object::toString).orElse("inline")).toString();
    }
}

