/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CAnimateHandPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.client.CTabCompletePacket;
import net.minecraft.network.play.client.CUpdateSignPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.network.play.server.SPlayerDiggingPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.network.play.server.STabCompletePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.entity.Sign;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.player.PlayerChatFormatter;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.entity.ChangeSignEvent;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.living.AnimateHandEvent;
import org.spongepowered.api.event.entity.living.player.RespawnPlayerEvent;
import org.spongepowered.api.event.message.PlayerChatEvent;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundMovePlayerPacketAccessor;
import org.spongepowered.common.accessor.server.level.ServerPlayerGameModeAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionHolderBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.server.network.ServerGamePacketListenerImplBridge;
import org.spongepowered.common.bridge.server.players.PlayerListBridge;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.command.registrar.BrigadierBasedRegistrar;
import org.spongepowered.common.data.value.ImmutableSpongeListValue;
import org.spongepowered.common.entity.player.tab.SpongeTabList;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.CommandUtil;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={ServerPlayNetHandler.class})
public abstract class ServerGamePacketListenerImplMixin
implements ServerGamePacketListenerImplBridge,
ConnectionHolderBridge {
    @Shadow
    @Final
    public NetworkManager field_147371_a;
    @Shadow
    public ServerPlayerEntity field_147369_b;
    @Shadow
    @Final
    private MinecraftServer field_147367_d;
    @Shadow
    private Vector3d field_184362_y;
    @Shadow
    private double field_184349_l;
    @Shadow
    private double field_184350_m;
    @Shadow
    private double field_184351_n;
    @Shadow
    private int field_184347_F;
    @Shadow
    private int field_184348_G;
    @Shadow
    private int field_147368_e;
    @Shadow
    private int field_184343_A;
    @Shadow
    private int field_147374_l;
    private int impl$ignorePackets;

    @Shadow
    protected abstract boolean shadow$func_217264_d();

    @Shadow
    public abstract void shadow$func_147364_a(double var1, double var3, double var5, float var7, float var8);

    @Shadow
    protected abstract void shadow$func_244537_a(List<String> var1, Consumer<List<String>> var2);

    @Shadow
    public abstract void shadow$func_184342_d();

    @Override
    public NetworkManager bridge$getConnection() {
        return this.field_147371_a;
    }

    @Inject(method={"func_211148_a(Lnet/minecraft/network/IPacket;Lio/netty/util/concurrent/GenericFutureListener;)V"}, at={@At(value="HEAD")})
    private void impl$onClientboundPacketSend(IPacket<?> packet, GenericFutureListener<? extends Future<? super Void>> listener, CallbackInfo ci) {
        if (packet instanceof SPlayerListItemPacket) {
            ((SpongeTabList)((ServerPlayer)this.field_147369_b).tabList()).updateEntriesOnSend((SPlayerListItemPacket)packet);
        }
    }

    @Inject(method={"func_195518_a(Lnet/minecraft/network/play/client/CTabCompletePacket;)V"}, at={@At(value="NEW", target="com/mojang/brigadier/StringReader", remap=false)}, cancellable=true)
    private void impl$getSuggestionsFromNonBrigCommand(CTabCompletePacket packet, CallbackInfo ci) {
        String rawCommand = packet.func_197707_b();
        String[] command = CommandUtil.extractCommandString(rawCommand);
        CommandCause cause = CommandCause.create();
        SpongeCommandManager manager = SpongeCommandManager.get(this.field_147367_d);
        if (!rawCommand.contains(" ")) {
            SuggestionsBuilder builder = new SuggestionsBuilder(command[0], 0);
            if (command[0].isEmpty()) {
                manager.getAliasesForCause(cause).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            } else {
                manager.getAliasesThatStartWithForCause(cause, command[0]).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            this.field_147371_a.func_179290_a((IPacket)new STabCompletePacket(packet.func_197709_a(), builder.build()));
            ci.cancel();
        } else {
            Optional<CommandMapping> mappingOptional = manager.commandMapping(command[0].toLowerCase(Locale.ROOT)).filter(x -> !(x.registrar() instanceof BrigadierBasedRegistrar));
            if (mappingOptional.isPresent()) {
                CommandMapping mapping = mappingOptional.get();
                if (mapping.registrar().canExecute(cause, mapping)) {
                    SuggestionsBuilder builder = CommandUtil.createSuggestionsForRawCommand(rawCommand, command, cause, mapping);
                    this.field_147371_a.func_179290_a((IPacket)new STabCompletePacket(packet.func_197709_a(), builder.build()));
                } else {
                    this.field_147371_a.func_179290_a((IPacket)new STabCompletePacket(packet.func_197709_a(), (Suggestions)Suggestions.empty().join()));
                }
                ci.cancel();
            }
        }
    }

    @Redirect(method={"func_195518_a(Lnet/minecraft/network/play/client/CTabCompletePacket;)V"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/CommandDispatcher;parse(Lcom/mojang/brigadier/StringReader;Ljava/lang/Object;)Lcom/mojang/brigadier/ParseResults;", remap=false))
    private ParseResults<CommandSource> impl$informParserThisIsASuggestionCheck(CommandDispatcher<CommandSource> commandDispatcher, StringReader command, Object source) {
        return SpongeCommandManager.get(this.field_147367_d).getDispatcher().parse(command, (CommandSource)source, true);
    }

    @ModifyConstant(method={"func_147340_a(Lnet/minecraft/network/play/client/CUseEntityPacket;)V"}, constant={@Constant(doubleValue=36.0)})
    private double impl$getPlatformReach(double thirtySix, CUseEntityPacket p_147340_1_) {
        return PlatformHooks.INSTANCE.getGeneralHooks().getEntityReachDistanceSq(this.field_147369_b, p_147340_1_.func_149564_a(this.field_147369_b.field_70170_p));
    }

    @Inject(method={"func_147347_a(Lnet/minecraft/network/play/client/CPlayerPacket;)V"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/network/play/ServerPlayNetHandler;field_184362_y:Lnet/minecraft/util/math/vector/Vector3d;")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/entity/player/ServerPlayerEntity;field_71136_j:Z"), to=@At(value="FIELD", target="Lnet/minecraft/network/play/ServerPlayNetHandler;field_147368_e:I", ordinal=1))}, cancellable=true)
    private void impl$callMoveEntityEvent(CPlayerPacket packetIn, CallbackInfo ci) {
        Event event;
        ServerboundMovePlayerPacketAccessor packetInAccessor = (ServerboundMovePlayerPacketAccessor)packetIn;
        if (!packetInAccessor.accessor$hasPos() && !packetInAccessor.accessor$hasRot()) {
            return;
        }
        boolean goodMovementPacket = this.field_184347_F - this.field_184348_G <= 5;
        boolean fireMoveEvent = goodMovementPacket && packetInAccessor.accessor$hasPos() && ShouldFire.MOVE_ENTITY_EVENT;
        boolean fireRotationEvent = goodMovementPacket && packetInAccessor.accessor$hasRot() && ShouldFire.ROTATE_ENTITY_EVENT;
        ServerPlayer player = (ServerPlayer)this.field_147369_b;
        org.spongepowered.math.vector.Vector3d fromRotation = new org.spongepowered.math.vector.Vector3d(this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A, 0.0f);
        org.spongepowered.math.vector.Vector3d fromPosition = player.position();
        org.spongepowered.math.vector.Vector3d toPosition = new org.spongepowered.math.vector.Vector3d(packetIn.func_186997_a(this.field_147369_b.func_226277_ct_()), packetIn.func_186996_b(this.field_147369_b.func_226278_cu_()), packetIn.func_187000_c(this.field_147369_b.func_226281_cx_()));
        org.spongepowered.math.vector.Vector3d toRotation = new org.spongepowered.math.vector.Vector3d(packetIn.func_186999_a(this.field_147369_b.field_70177_z), packetIn.func_186998_b(this.field_147369_b.field_70125_A), 0.0f);
        boolean significantRotation = fromRotation.distanceSquared(toRotation) > (double)0.0225f;
        org.spongepowered.math.vector.Vector3d originalToPosition = toPosition;
        boolean cancelMovement = false;
        boolean cancelRotation = false;
        if (fireMoveEvent) {
            PhaseTracker.getCauseStackManager().addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.NATURAL);
            event = SpongeEventFactory.createMoveEntityEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerPlayer)this.field_147369_b, fromPosition, toPosition, toPosition);
            if (SpongeCommon.post(event)) {
                cancelMovement = true;
            } else {
                toPosition = event.destinationPosition();
            }
            PhaseTracker.getCauseStackManager().removeContext(EventContextKeys.MOVEMENT_TYPE);
        }
        if (significantRotation && fireRotationEvent) {
            event = SpongeEventFactory.createRotateEntityEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerPlayer)this.field_147369_b, fromRotation, toRotation);
            if (SpongeCommon.post(event)) {
                cancelRotation = true;
                toRotation = fromRotation;
            } else {
                toRotation = event.toRotation();
            }
        }
        if (cancelMovement) {
            if (fromPosition.distanceSquared(toPosition) > 0.0) {
                this.field_184343_A = this.field_147368_e;
                this.shadow$func_147364_a(fromPosition.x(), fromPosition.y(), fromPosition.z(), (float)toRotation.x(), (float)toRotation.y());
            } else {
                this.field_147369_b.func_70080_a(fromPosition.x(), fromPosition.y(), fromPosition.z(), (float)toRotation.x(), (float)toRotation.y());
            }
            ci.cancel();
            return;
        }
        if (!toPosition.equals((Object)originalToPosition)) {
            int i;
            float f2;
            double d10;
            double d6;
            double d9;
            double d5;
            double d8;
            double d4 = packetIn.func_186997_a(this.field_147369_b.func_226277_ct_());
            double d7 = d4 - this.field_184349_l;
            double d11 = d7 * d7 + (d8 = (d5 = packetIn.func_186996_b(this.field_147369_b.func_226278_cu_())) - this.field_184350_m) * d8 + (d9 = (d6 = packetIn.func_187000_c(this.field_147369_b.func_226281_cx_())) - this.field_184351_n) * d9;
            if (d11 - (d10 = this.field_147369_b.func_213322_ci().func_189985_c()) > (double)((f2 = this.field_147369_b.func_184613_cA() ? 300.0f : 100.0f) * (float)(i = this.field_184347_F - this.field_184348_G)) && !this.shadow$func_217264_d()) {
                this.field_184362_y = VecHelper.toVanillaVector3d(toPosition);
                ((EntityAccessor)this.field_147369_b).invoker$setRot((float)toRotation.x(), (float)toRotation.y());
                this.field_184343_A = this.field_147368_e - 21;
            } else {
                packetInAccessor.accessor$hasPos(true);
                packetInAccessor.accessor$x(toPosition.x());
                packetInAccessor.accessor$y(toPosition.y());
                packetInAccessor.accessor$z(toPosition.z());
            }
        }
    }

    @Inject(method={"func_147340_a(Lnet/minecraft/network/play/client/CUseEntityPacket;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;func_184199_a(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/math/vector/Vector3d;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResultType;")})
    public void impl$onRightClickAtEntity(CUseEntityPacket p_147340_1, CallbackInfo ci) {
        Entity entity = p_147340_1.func_149564_a((World)this.field_147369_b.func_71121_q());
        ItemStack itemInHand = p_147340_1.func_186994_b() == null ? ItemStack.field_190927_a : this.field_147369_b.func_184586_b(p_147340_1.func_186994_b());
        InteractEntityEvent.Secondary event = SpongeCommonEventFactory.callInteractEntityEventSecondary(this.field_147369_b, itemInHand, entity, p_147340_1.func_186994_b(), VecHelper.toVector3d(p_147340_1.func_179712_b()));
        if (event.isCancelled()) {
            ci.cancel();
        } else {
            ++this.impl$ignorePackets;
        }
    }

    @Inject(method={"func_147340_a(Lnet/minecraft/network/play/client/CUseEntityPacket;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;func_71059_n(Lnet/minecraft/entity/Entity;)V")})
    public void impl$onLeftClickEntity(CUseEntityPacket p_147340_1_, CallbackInfo ci) {
        Entity entity = p_147340_1_.func_149564_a((World)this.field_147369_b.func_71121_q());
        InteractEntityEvent.Primary event = SpongeCommonEventFactory.callInteractEntityEventPrimary(this.field_147369_b, this.field_147369_b.func_184586_b(this.field_147369_b.func_184600_cs()), entity, this.field_147369_b.func_184600_cs());
        if (event.isCancelled()) {
            ci.cancel();
        } else {
            ++this.impl$ignorePackets;
        }
    }

    @Inject(method={"func_175087_a(Lnet/minecraft/network/play/client/CAnimateHandPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;func_143004_u()V")}, cancellable=true)
    private void impl$throwAnimationAndInteractEvents(CAnimateHandPacket packetIn, CallbackInfo ci) {
        if (PhaseTracker.getInstance().getPhaseContext().isEmpty()) {
            return;
        }
        Hand hand = packetIn.func_187018_a();
        if (!((ServerPlayerGameModeAccessor)this.field_147369_b.field_71134_c).accessor$isDestroyingBlock()) {
            if (this.impl$ignorePackets > 0) {
                --this.impl$ignorePackets;
            } else if (ShouldFire.INTERACT_ITEM_EVENT_PRIMARY) {
                Vector3d startPos = this.field_147369_b.func_174824_e(1.0f);
                Vector3d endPos = startPos.func_178787_e(this.field_147369_b.func_70040_Z().func_186678_a(5.0));
                BlockRayTraceResult result = this.field_147369_b.func_71121_q().func_217299_a(new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this.field_147369_b));
                if (result.func_216346_c() == RayTraceResult.Type.MISS) {
                    ItemStack heldItem = this.field_147369_b.func_184586_b(hand);
                    SpongeCommonEventFactory.callInteractItemEventPrimary((PlayerEntity)this.field_147369_b, heldItem, hand);
                }
            }
        }
        if (ShouldFire.ANIMATE_HAND_EVENT) {
            HandType handType = (HandType)hand;
            ItemStack heldItem = this.field_147369_b.func_184586_b(hand);
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(heldItem));
                frame.addContext(EventContextKeys.USED_HAND, handType);
                AnimateHandEvent event = SpongeEventFactory.createAnimateHandEvent(frame.currentCause(), handType, (Humanoid)this.field_147369_b);
                if (SpongeCommon.post(event)) {
                    ci.cancel();
                }
            }
        }
    }

    @Inject(method={"func_147345_a(Lnet/minecraft/network/play/client/CPlayerDiggingPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;func_225609_n_(Z)Z")})
    public void impl$dropItem(CPlayerDiggingPacket p_147345_1_, CallbackInfo ci) {
        ++this.impl$ignorePackets;
    }

    @Redirect(method={"func_147345_a(Lnet/minecraft/network/play/client/CPlayerDiggingPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerInteractionManager;func_225416_a(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/network/play/client/CPlayerDiggingPacket$Action;Lnet/minecraft/util/Direction;I)V"))
    public void impl$callInteractBlockPrimaryEvent(PlayerInteractionManager playerInteractionManager, BlockPos p_225416_1_, CPlayerDiggingPacket.Action p_225416_2_, Direction p_225416_3_, int p_225416_4_) {
        BlockSnapshot snapshot = ((ServerWorld)playerInteractionManager.field_73092_a).createSnapshot(VecHelper.toVector3i(p_225416_1_));
        InteractBlockEvent.Primary event = SpongeCommonEventFactory.callInteractBlockEventPrimary(p_225416_2_, (PlayerEntity)this.field_147369_b, this.field_147369_b.func_184586_b(Hand.MAIN_HAND), snapshot, Hand.MAIN_HAND, p_225416_3_);
        if (event instanceof Cancellable && ((Cancellable)((Object)event)).isCancelled()) {
            this.field_147369_b.field_71135_a.func_147359_a((IPacket)new SPlayerDiggingPacket(p_225416_1_, playerInteractionManager.field_73092_a.func_180495_p(p_225416_1_), p_225416_2_, false, "block action restricted"));
            ++this.impl$ignorePackets;
        } else {
            if (p_225416_2_ == CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK && !Objects.equals(((ServerPlayerGameModeAccessor)playerInteractionManager).accessor$destroyPos(), p_225416_1_)) {
                return;
            }
            playerInteractionManager.func_225416_a(p_225416_1_, p_225416_2_, p_225416_3_, p_225416_4_);
            if (p_225416_2_ == CPlayerDiggingPacket.Action.START_DESTROY_BLOCK) {
                ++this.impl$ignorePackets;
            }
        }
    }

    @Redirect(method={"func_147342_a(Lnet/minecraft/network/play/client/CClientStatusPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_232644_a_(Lnet/minecraft/entity/player/ServerPlayerEntity;Z)Lnet/minecraft/entity/player/ServerPlayerEntity;"))
    private ServerPlayerEntity impl$usePlayerDimensionForRespawn(PlayerList playerList, ServerPlayerEntity player, boolean keepAllPlayerData) {
        RegistryKey respawnDimension = player.func_241141_L_();
        @Nullable net.minecraft.world.server.ServerWorld destinationWorld = this.field_147367_d.func_71218_a(respawnDimension);
        net.minecraft.world.server.ServerWorld overworld = this.field_147367_d.func_71218_a(World.field_234918_g_);
        if (overworld == null) {
            throw new IllegalStateException("Somehow the Overworld is not retrievable while trying to respawn player " + player.func_146103_bH().getName());
        }
        net.minecraft.world.server.ServerWorld destination = destinationWorld == null ? overworld : destinationWorld;
        RespawnPlayerEvent.SelectWorld event = SpongeEventFactory.createRespawnPlayerEventSelectWorld(PhaseTracker.getCauseStackManager().currentCause(), (ServerWorld)destination, (ServerWorld)player.func_71121_q(), (ServerWorld)overworld, (ServerPlayer)player);
        SpongeCommon.post(event);
        ((PlayerListBridge)this.field_147367_d.func_184103_al()).bridge$setOriginalDestinationDimension((RegistryKey<World>)((net.minecraft.world.server.ServerWorld)event.originalDestinationWorld()).func_234923_W_());
        ((PlayerListBridge)this.field_147367_d.func_184103_al()).bridge$setNewDestinationDimension((RegistryKey<World>)((net.minecraft.world.server.ServerWorld)event.destinationWorld()).func_234923_W_());
        return playerList.func_232644_a_(player, keepAllPlayerData);
    }

    @Redirect(method={"func_147231_a(Lnet/minecraft/util/text/ITextComponent;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_232641_a_(Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/util/text/ChatType;Ljava/util/UUID;)V"))
    public void impl$handlePlayerDisconnect(PlayerList playerList, ITextComponent component, ChatType chatType, UUID uuid) {
        if (this.field_147369_b.field_71135_a == null) {
            return;
        }
        ServerPlayer spongePlayer = (ServerPlayer)this.field_147369_b;
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this.field_147369_b);
            Component message = SpongeAdventure.asAdventure(component);
            Audience audience = Sponge.server().broadcastAudience();
            ServerSideConnectionEvent.Disconnect event = SpongeEventFactory.createServerSideConnectionEventDisconnect(PhaseTracker.getCauseStackManager().currentCause(), audience, Optional.of(audience), message, message, spongePlayer.connection(), spongePlayer);
            SpongeCommon.post(event);
            event.audience().ifPresent(a -> a.sendMessage((Identified)spongePlayer, event.message()));
        }
        ((ServerPlayerBridge)this.field_147369_b).bridge$getWorldBorderListener().onPlayerDisconnect();
    }

    @Redirect(method={"func_147343_a(Lnet/minecraft/network/play/client/CUpdateSignPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;func_244537_a(Ljava/util/List;Ljava/util/function/Consumer;)V"))
    private void impl$switchToSignPhaseState(ServerPlayNetHandler serverPlayNetHandler, List<String> p_244537_1_, Consumer<List<String>> p_244537_2_) {
        try (BasicPacketContext context = (BasicPacketContext)((BasicPacketContext)PacketPhase.General.UPDATE_SIGN.createPhaseContext(PhaseTracker.getInstance()).packetPlayer(this.field_147369_b)).buildAndSwitch();){
            this.shadow$func_244537_a(p_244537_1_, p_244537_2_);
        }
    }

    @Redirect(method={"func_244542_a(Lnet/minecraft/network/play/client/CUpdateSignPacket;Ljava/util/List;)V"}, at=@At(value="INVOKE", remap=false, target="Ljava/util/List;size()I"))
    private int impl$callChangeSignEvent(List<String> list, CUpdateSignPacket p_244542_1_, List<String> p_244542_2_) {
        SignTileEntity blockEntity = (SignTileEntity)this.field_147369_b.field_70170_p.func_175625_s(p_244542_1_.func_179722_a());
        ListValue.Mutable<Component> originalLinesValue = ((Sign)blockEntity).getValue(Keys.SIGN_LINES).orElseGet(() -> new ImmutableSpongeListValue(Keys.SIGN_LINES, ImmutableList.of()));
        ArrayList<TextComponent> newLines = new ArrayList<TextComponent>();
        for (String line : list) {
            newLines.add(Component.text((String)SharedConstants.func_71565_a((String)line)));
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this.field_147369_b);
            ListValue.Mutable<Component> newLinesValue = ListValue.mutableOf(Keys.SIGN_LINES, newLines);
            ChangeSignEvent event = SpongeEventFactory.createChangeSignEvent(PhaseTracker.getCauseStackManager().currentCause(), (ListValue.Immutable<Component>)originalLinesValue.asImmutable(), newLinesValue, (Sign)blockEntity);
            ListValue.Mutable<Component> toApply = SpongeCommon.post(event) ? originalLinesValue : newLinesValue;
            ((Sign)blockEntity).offer(toApply);
        }
        return 0;
    }

    @Override
    public void bridge$captureCurrentPlayerPosition() {
        this.shadow$func_184342_d();
    }

    @Redirect(method={"func_244548_c(Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_232641_a_(Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/util/text/ChatType;Ljava/util/UUID;)V"))
    private void impl$postChatMessageEventAndSend(PlayerList playerList, ITextComponent component, ChatType chatType, UUID playerUUID, String initialMessage) {
        ServerPlayer player = (ServerPlayer)this.field_147369_b;
        PlayerChatFormatter chatFormatter = player.chatFormatter();
        TextComponent currentMessage = Component.text((String)initialMessage);
        if (component instanceof TranslationTextComponent && ((TranslationTextComponent)component).func_150271_j().length == 2) {
            if (((TranslationTextComponent)component).func_150271_j()[1] instanceof ITextComponent) {
                currentMessage = SpongeAdventure.asAdventure((ITextComponent)((TranslationTextComponent)component).func_150271_j()[1]);
            } else if (((TranslationTextComponent)component).func_150271_j()[1] instanceof String) {
                currentMessage = Component.text((String)((String)((TranslationTextComponent)component).func_150271_j()[1]));
            }
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.SERVER.pushCauseFrame();){
            frame.pushCause(this.field_147369_b);
            Audience audience = (Audience)this.field_147367_d;
            PlayerChatEvent event = SpongeEventFactory.createPlayerChatEvent(frame.currentCause(), audience, Optional.of(audience), chatFormatter, Optional.of(chatFormatter), (Component)currentMessage, (Component)currentMessage);
            if (SpongeCommon.post(event)) {
                this.field_147374_l -= 20;
            } else {
                event.chatFormatter().ifPresent(formatter -> event.audience().map(SpongeAdventure::unpackAudiences).ifPresent(targets -> {
                    for (Audience target : targets) {
                        formatter.format(player, target, event.message(), event.originalMessage()).ifPresent(formattedMessage -> target.sendMessage((Identified)player, formattedMessage));
                    }
                }));
            }
        }
    }
}

