/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.mojang.authlib.GameProfile;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.network.login.server.SEnableCompressionPacket;
import net.minecraft.network.login.server.SLoginSuccessPacket;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.network.ConnectionHolderBridge;
import org.spongepowered.common.bridge.server.network.ServerLoginPacketListenerImplBridge;
import org.spongepowered.common.bridge.server.players.PlayerListBridge;
import org.spongepowered.common.network.channel.SpongeChannelManager;

@Mixin(value={ServerLoginNetHandler.class})
public abstract class ServerLoginPacketListenerImplMixin
implements ServerLoginPacketListenerImplBridge,
ConnectionHolderBridge {
    @Shadow
    @Final
    public NetworkManager field_147333_a;
    @Shadow
    private GameProfile field_147337_i;
    @Shadow
    @Final
    private MinecraftServer field_147327_f;
    @Shadow
    private ServerLoginNetHandler.State field_147328_g;
    @Shadow
    private ServerPlayerEntity field_181025_l;
    private boolean impl$accepted = false;

    @Shadow
    protected abstract GameProfile shadow$func_152506_a(GameProfile var1);

    @Shadow
    public abstract void shadow$func_194026_b(ITextComponent var1);

    @Shadow
    public abstract void func_194026_b(ITextComponent var1);

    @Override
    public NetworkManager bridge$getConnection() {
        return this.field_147333_a;
    }

    @Overwrite
    public void func_147326_c() {
        if (!this.field_147337_i.isComplete()) {
            this.field_147337_i = this.shadow$func_152506_a(this.field_147337_i);
        }
        if (this.impl$accepted) {
            return;
        }
        this.impl$accepted = true;
        PlayerList playerList = this.field_147327_f.func_184103_al();
        ((CompletableFuture)((CompletableFuture)((PlayerListBridge)playerList).bridge$canPlayerLogin(this.field_147333_a.func_74430_c(), this.field_147337_i).handle((componentOpt, throwable) -> {
            if (throwable != null) {
                ((ConnectionBridge)this.field_147333_a).bridge$setKickReason((ITextComponent)new StringTextComponent("An error occurred checking ban/whitelist status."));
                SpongeCommon.logger().error("An error occurred when checking the ban/whitelist status of {}.", (Object)this.field_147337_i.getId().toString());
                SpongeCommon.logger().error(throwable);
            } else if (componentOpt != null) {
                ((ConnectionBridge)this.field_147333_a).bridge$setKickReason((ITextComponent)componentOpt);
            }
            try {
                ((SpongeServer)SpongeCommon.server()).userManager().handlePlayerLogin(this.field_147337_i);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            return null;
        })).handleAsync((ignored, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throw (CompletionException)throwable;
                }
                throw new CompletionException((Throwable)throwable);
            }
            this.field_147328_g = ServerLoginNetHandler.State.ACCEPTED;
            if (this.field_147327_f.func_175577_aI() >= 0 && !this.field_147333_a.func_150731_c()) {
                this.field_147333_a.func_201058_a((IPacket)new SEnableCompressionPacket(this.field_147327_f.func_175577_aI()), param0 -> this.field_147333_a.func_179289_a(this.field_147327_f.func_175577_aI()));
            }
            this.field_147333_a.func_179290_a((IPacket)new SLoginSuccessPacket(this.field_147337_i));
            ServerPlayerEntity var1 = this.field_147327_f.func_184103_al().func_177451_a(this.field_147337_i.getId());
            if (var1 != null) {
                this.field_147328_g = ServerLoginNetHandler.State.DELAY_ACCEPT;
                this.field_181025_l = this.field_147327_f.func_184103_al().func_148545_a(this.field_147337_i);
            } else {
                ServerSideConnection connection = (ServerSideConnection)((Object)this);
                ((SpongeChannelManager)Sponge.channelManager()).sendChannelRegistrations(connection);
                try {
                    this.field_147327_f.func_184103_al().func_72355_a(this.field_147333_a, this.field_147327_f.func_184103_al().func_148545_a(this.field_147337_i));
                    Sponge.server().userManager().removeFromCache(this.field_147337_i.getId());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }, (Executor)SpongeCommon.server())).exceptionally(throwable -> {
            if (throwable != null) {
                this.impl$disconnectError((Throwable)throwable, this.field_147328_g == ServerLoginNetHandler.State.ACCEPTED || this.field_147328_g == ServerLoginNetHandler.State.READY_TO_ACCEPT);
            }
            return null;
        });
    }

    @Redirect(method={"func_73660_a()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"))
    private void impl$catchErrorWhenTickingNewPlayer(PlayerList playerList, NetworkManager param0, ServerPlayerEntity param1) {
        try {
            playerList.func_72355_a(param0, param1);
        }
        catch (Exception e) {
            this.impl$disconnectError(e, true);
        }
    }

    private void impl$disconnectError(Throwable throwable, boolean gameDisconnect) {
        SpongeCommon.logger().error("Forcibly disconnecting user {} due to an error during login.", (Object)this.field_147337_i, (Object)throwable);
        StringTextComponent message = new StringTextComponent("Internal Server Error: unable to complete login.");
        if (gameDisconnect) {
            this.field_147333_a.func_201058_a((IPacket)new SDisconnectPacket((ITextComponent)message), arg_0 -> this.lambda$impl$disconnectError$4((ITextComponent)message, arg_0));
        } else {
            this.shadow$func_194026_b((ITextComponent)message);
        }
    }

    private void impl$disconnectClient(Component disconnectMessage) {
        ITextComponent reason = SpongeAdventure.asVanilla(disconnectMessage);
        this.shadow$func_194026_b(reason);
    }

    @Override
    public boolean bridge$fireAuthEvent() {
        TextComponent disconnectMessage = Component.text((String)"You are not allowed to log in to this server.");
        Cause cause = Cause.of(EventContext.empty(), this);
        ServerSideConnectionEvent.Auth event = SpongeEventFactory.createServerSideConnectionEventAuth(cause, (Component)disconnectMessage, (Component)disconnectMessage, (ServerSideConnection)((Object)this));
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            this.impl$disconnectClient(event.message());
        }
        return event.isCancelled();
    }

    @Inject(method={"func_147316_a(Lnet/minecraft/network/login/client/CLoginStartPacket;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/network/login/ServerLoginNetHandler;field_147328_g:Lnet/minecraft/network/login/ServerLoginNetHandler$State;", opcode=181, ordinal=1)}, cancellable=true)
    private void impl$fireAuthEventOffline(CallbackInfo ci) {
        if (!this.field_147337_i.isComplete()) {
            this.field_147337_i = this.shadow$func_152506_a(this.field_147337_i);
        }
        if (this.bridge$fireAuthEvent()) {
            ci.cancel();
        }
    }

    private /* synthetic */ void lambda$impl$disconnectError$4(ITextComponent message, Future param1) throws Exception {
        this.field_147333_a.func_150718_a(message);
    }
}

