/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.players;

import com.mojang.authlib.GameProfile;
import io.netty.channel.local.LocalAddress;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.CustomServerBossInfoManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.BanList;
import net.minecraft.server.management.IPBanList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.WhiteList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.adventure.Audiences;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.living.player.RespawnPlayerEvent;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerPlayerConnection;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundPlayerInfoPacketAccessor;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundRespawnPacketAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.client.server.IntegratedPlayerListBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.server.players.PlayerListBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.entity.player.SpongeUserView;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.effect.BroadcastInventoryChangesEffect;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.server.PerWorldBorderListener;
import org.spongepowered.common.service.server.ban.SpongeIPBanList;
import org.spongepowered.common.service.server.ban.SpongeUserBanList;
import org.spongepowered.common.service.server.whitelist.SpongeUserWhiteList;
import org.spongepowered.common.util.NetworkUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin
implements PlayerListBridge {
    @Shadow
    @Final
    private static Logger field_148546_d;
    @Shadow
    @Final
    private static SimpleDateFormat field_72403_e;
    @Shadow
    @Final
    private MinecraftServer field_72400_f;
    @Shadow
    private int field_72402_d;
    @Shadow
    @Final
    @Mutable
    private BanList field_72401_g;
    @Shadow
    @Final
    @Mutable
    private IPBanList field_72413_h;
    @Shadow
    @Final
    @Mutable
    private WhiteList field_72411_j;
    @Shadow
    @Final
    private List<ServerPlayerEntity> field_72404_b;
    @Shadow
    @Final
    protected int field_72405_c;
    @Shadow
    @Final
    private Map<UUID, ServerPlayerEntity> field_177454_f;
    private boolean impl$isGameMechanicRespawn = false;
    RegistryKey<World> impl$newDestination = null;
    RegistryKey<World> impl$originalDestination = null;

    @Shadow
    public abstract MinecraftServer shadow$func_72365_p();

    @Shadow
    @Nullable
    public abstract CompoundNBT shadow$func_72380_a(ServerPlayerEntity var1);

    @Shadow
    public abstract boolean shadow$func_183023_f(GameProfile var1);

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/util/registry/DynamicRegistries$Impl;Lnet/minecraft/world/storage/PlayerData;I)V"}, at={@At(value="RETURN")})
    private void impl$setSpongeLists(CallbackInfo callbackInfo) {
        this.field_72401_g = new SpongeUserBanList(PlayerList.field_152613_a);
        this.field_72413_h = new SpongeIPBanList(PlayerList.field_152614_b);
        this.field_72411_j = new SpongeUserWhiteList(PlayerList.field_152616_d);
    }

    @Override
    public void bridge$setOriginalDestinationDimension(RegistryKey<World> dimension) {
        this.impl$originalDestination = dimension;
    }

    @Override
    public void bridge$setNewDestinationDimension(RegistryKey<World> dimension) {
        this.impl$newDestination = dimension;
    }

    @Override
    public CompletableFuture<ITextComponent> bridge$canPlayerLogin(SocketAddress param0, GameProfile param1) {
        if (this instanceof IntegratedPlayerListBridge) {
            return ((IntegratedPlayerListBridge)((Object)this)).bridge$canPlayerLoginClient(param0, param1);
        }
        return this.impl$canPlayerLoginServer(param0, param1);
    }

    protected final CompletableFuture<ITextComponent> impl$canPlayerLoginServer(SocketAddress param0, GameProfile param1) {
        SpongeGameProfile profile = SpongeGameProfile.basicOf(param1);
        return ((CompletableFuture)Sponge.server().serviceProvider().banService().find(profile).thenCompose(profileBanOpt -> {
            InetAddress address;
            if (profileBanOpt.isPresent()) {
                Ban.Profile var0 = (Ban.Profile)profileBanOpt.get();
                TranslationTextComponent var1 = new TranslationTextComponent("multiplayer.disconnect.banned.reason", new Object[]{var0.reason().orElse((Component)Component.empty())});
                if (var0.expirationDate().isPresent()) {
                    var1.func_230529_a_((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.banned.expiration", new Object[]{field_72403_e.format(var0.expirationDate().get())}));
                }
                return CompletableFuture.completedFuture(var1);
            }
            if (param0 instanceof LocalAddress) {
                return CompletableFuture.completedFuture(null);
            }
            try {
                address = InetAddress.getByName(NetworkUtil.getHostString(param0));
            }
            catch (UnknownHostException ex) {
                return CompletableFuture.completedFuture(new StringTextComponent(ex.getMessage()));
            }
            return Sponge.server().serviceProvider().banService().find(address).thenCompose(ipBanOpt -> {
                if (ipBanOpt.isPresent()) {
                    Ban.IP var2 = (Ban.IP)ipBanOpt.get();
                    TranslationTextComponent var3 = new TranslationTextComponent("multiplayer.disconnect.banned_ip.reason", new Object[]{var2.reason().orElse((Component)Component.empty())});
                    if (var2.expirationDate().isPresent()) {
                        var3.func_230529_a_((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.banned_ip.expiration", new Object[]{field_72403_e.format(var2.expirationDate().get())}));
                    }
                    return CompletableFuture.completedFuture(var3);
                }
                return CompletableFuture.supplyAsync(() -> {
                    if (!Sponge.server().isWhitelistEnabled()) {
                        return true;
                    }
                    PermissionService permissionService = Sponge.server().serviceProvider().permissionService();
                    Subject subject = permissionService.userSubjects().subject(param1.getId().toString()).orElse(null);
                    if (subject == null) {
                        subject = permissionService.defaults();
                    }
                    return subject.hasPermission("minecraft.login.bypass-whitelist");
                }, (Executor)SpongeCommon.server()).thenCompose(w -> {
                    if (w.booleanValue()) {
                        return CompletableFuture.completedFuture(null);
                    }
                    return Sponge.server().serviceProvider().whitelistService().isWhitelisted(profile).thenApply(whitelisted -> {
                        if (!whitelisted.booleanValue()) {
                            return new TranslationTextComponent("multiplayer.disconnect.not_whitelisted");
                        }
                        return null;
                    });
                });
            });
        })).thenApplyAsync(component -> {
            if (component != null) {
                return component;
            }
            if (this.field_72404_b.size() >= this.field_72405_c && !this.shadow$func_183023_f(param1)) {
                return new TranslationTextComponent("multiplayer.disconnect.server_full");
            }
            return null;
        }, (Executor)SpongeCommon.server());
    }

    @Redirect(method={"func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_72380_a(Lnet/minecraft/entity/player/ServerPlayerEntity;)Lnet/minecraft/nbt/CompoundNBT;"))
    private CompoundNBT impl$setPlayerDataForNewPlayers(PlayerList playerList, ServerPlayerEntity playerIn) {
        CompoundNBT compound = this.shadow$func_72380_a(playerIn);
        if (compound == null) {
            ((SpongeServer)SpongeCommon.server()).getPlayerDataManager().setPlayerInfo(playerIn.func_110124_au(), Instant.now(), Instant.now());
        }
        return compound;
    }

    @Redirect(method={"func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;func_71218_a(Lnet/minecraft/util/RegistryKey;)Lnet/minecraft/world/server/ServerWorld;"))
    private net.minecraft.world.server.ServerWorld impl$onInitPlayer_getWorld(MinecraftServer minecraftServer, RegistryKey<World> dimension, NetworkManager networkManager, ServerPlayerEntity mcPlayer) {
        ITextComponent kickReason = ((ConnectionBridge)networkManager).bridge$getKickReason();
        Object disconnectMessage = kickReason != null ? SpongeAdventure.asAdventure(kickReason) : Component.text((String)"You are not allowed to log in to this server.");
        net.minecraft.world.server.ServerWorld mcWorld = minecraftServer.func_71218_a(dimension);
        if (mcWorld == null) {
            SpongeCommon.logger().warn("The player '{}' was located in a world that isn't loaded or doesn't exist. This is not safe so the player will be moved to the spawn of the default world.", (Object)mcPlayer.func_146103_bH().getName());
            mcWorld = minecraftServer.func_241755_D_();
            BlockPos spawnPoint = mcWorld.func_241135_u_();
            mcPlayer.func_70107_b((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o() + 0.5, (double)spawnPoint.func_177952_p() + 0.5);
        }
        mcPlayer.func_70029_a((World)mcWorld);
        ServerPlayer player = (ServerPlayer)mcPlayer;
        ServerLocation location = player.serverLocation();
        Vector3d rotation = player.rotation();
        ServerSideConnection connection = (ServerSideConnection)networkManager.func_150729_e();
        User user = SpongeUserView.createLoginEventUser(player);
        Cause cause = Cause.of(EventContext.empty(), connection, user);
        ServerSideConnectionEvent.Login event = SpongeEventFactory.createServerSideConnectionEventLogin(cause, disconnectMessage, disconnectMessage, location, location, rotation, rotation, connection, user);
        if (kickReason != null) {
            event.setCancelled(true);
        }
        if (SpongeCommon.post(event)) {
            this.impl$disconnectClient(networkManager, event.message(), player.profile());
            return null;
        }
        ServerLocation toLocation = event.toLocation();
        Vector3d toRotation = event.toRotation();
        mcPlayer.func_70080_a(toLocation.x(), toLocation.y(), toLocation.z(), (float)toRotation.y(), (float)toRotation.x());
        return (net.minecraft.world.server.ServerWorld)toLocation.world();
    }

    @Inject(method={"func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;func_71218_a(Lnet/minecraft/util/RegistryKey;)Lnet/minecraft/world/server/ServerWorld;", shift=At.Shift.AFTER)})
    private void impl$onInitPlayer_BeforeSetWorld(NetworkManager p_72355_1_, ServerPlayerEntity p_72355_2_, CallbackInfo ci) {
        if (!p_72355_1_.func_150724_d()) {
            ci.cancel();
        }
    }

    @Redirect(method={"func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;info(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", remap=false))
    private void impl$onInitPlayer_printPlayerWorldInJoinFeedback(Logger logger, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, NetworkManager manager, ServerPlayerEntity entity) {
        logger.info("{}[{}] logged in to world '{}' with entity id {} at ({}, {}, {})", p0, p1, (Object)((ServerWorld)entity.func_71121_q()).key(), p2, p3, p4, p5);
    }

    @Redirect(method={"func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;func_147132_au()V"), to=@At(value="FIELD", opcode=178, target="Lnet/minecraft/util/text/TextFormatting;YELLOW:Lnet/minecraft/util/text/TextFormatting;")), at=@At(value="INVOKE", remap=false, target="Ljava/lang/String;equalsIgnoreCase(Ljava/lang/String;)Z"))
    private boolean impl$onInitPlayer_dontClassSpongeNameAsModified(String currentName, String originalName) {
        if (originalName.equals("[sponge]")) {
            return true;
        }
        return currentName.equalsIgnoreCase(originalName);
    }

    @Redirect(method={"func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_232641_a_(Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/util/text/ChatType;Ljava/util/UUID;)V"))
    private void impl$onInitPlayer_delaySendMessage(PlayerList playerList, ITextComponent message, ChatType p_232641_2_, UUID p_232641_3_, NetworkManager manager, ServerPlayerEntity playerIn) {
        ((ServerPlayerBridge)playerIn).bridge$setConnectionMessageToSend(message);
    }

    @Redirect(method={"func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at=@At(value="NEW", target="Lnet/minecraft/network/play/server/SJoinGamePacket;"))
    private SJoinGamePacket impl$usePerWorldViewDistance(int p_i242082_1_, GameType p_i242082_2_, GameType p_i242082_3_, long p_i242082_4_, boolean p_i242082_6_, Set<RegistryKey<World>> p_i242082_7_, DynamicRegistries.Impl p_i242082_8_, DimensionType p_i242082_9_, RegistryKey<World> p_i242082_10_, int p_i242082_11_, int p_i242082_12_, boolean p_i242082_13_, boolean p_i242082_14_, boolean p_i242082_15_, boolean p_i242082_16_, NetworkManager p_72355_1_, ServerPlayerEntity player) {
        return new SJoinGamePacket(p_i242082_1_, p_i242082_2_, p_i242082_3_, p_i242082_4_, p_i242082_6_, p_i242082_7_, p_i242082_8_, p_i242082_9_, p_i242082_10_, p_i242082_11_, ((PrimaryLevelDataBridge)player.func_71121_q().func_72912_H()).bridge$viewDistance().orElse(this.field_72402_d).intValue(), p_i242082_13_, p_i242082_14_, p_i242082_15_, p_i242082_16_);
    }

    @Redirect(method={"func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;func_201300_aS()Lnet/minecraft/server/CustomServerBossInfoManager;"))
    private CustomServerBossInfoManager impl$getPerWorldBossBarManager(MinecraftServer minecraftServer, NetworkManager netManager, ServerPlayerEntity playerIn) {
        return ((ServerLevelBridge)playerIn.func_71121_q()).bridge$getBossBarManager();
    }

    @Redirect(method={"func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_96456_a(Lnet/minecraft/scoreboard/ServerScoreboard;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"))
    private void impl$sendScoreboard(PlayerList playerList, ServerScoreboard scoreboardIn, ServerPlayerEntity playerIn) {
        ((ServerPlayerBridge)playerIn).bridge$initScoreboard();
    }

    @Redirect(method={"func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_148540_a(Lnet/minecraft/network/IPacket;)V"))
    private void impl$sendScoreboard(PlayerList playerList, IPacket<?> addPlayer, NetworkManager playerConnection, ServerPlayerEntity serverPlayer) {
        if (((VanishableBridge)serverPlayer).bridge$vanishState().invisible()) {
            return;
        }
        playerList.func_148540_a(addPlayer);
    }

    @Redirect(method={"func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;func_147359_a(Lnet/minecraft/network/IPacket;)V"), slice=@Slice(from=@At(value="INVOKE", target="Ljava/util/List;size()I", remap=false), to=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;func_217435_c(Lnet/minecraft/entity/player/ServerPlayerEntity;)V")))
    private void impl$onlySendAddPlayerForUnvanishedPlayers(ServerPlayNetHandler connection, IPacket<?> packet) {
        ClientboundPlayerInfoPacketAccessor playerInfoPacketAccessor = (ClientboundPlayerInfoPacketAccessor)packet;
        VanishableBridge p = (VanishableBridge)this.field_177454_f.get(playerInfoPacketAccessor.accessor$entries().get(0).func_179962_a().getId());
        if (p.bridge$vanishState().invisible()) {
            return;
        }
        connection.func_147359_a(packet);
    }

    @Inject(method={"func_72355_a(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at={@At(value="RETURN")})
    private void impl$onInitPlayer_join(NetworkManager networkManager, ServerPlayerEntity mcPlayer, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)mcPlayer;
        ServerPlayerConnection connection = player.connection();
        Cause cause = Cause.of(EventContext.empty(), connection, player);
        Audience audience = Audiences.onlinePlayers();
        Component joinComponent = SpongeAdventure.asAdventure(((ServerPlayerBridge)mcPlayer).bridge$getConnectionMessageToSend());
        ServerSideConnectionEvent.Join event = SpongeEventFactory.createServerSideConnectionEventJoin(cause, audience, Optional.of(audience), joinComponent, joinComponent, connection, player, false);
        SpongeCommon.post(event);
        if (!event.isMessageCancelled()) {
            event.audience().ifPresent(audience1 -> audience1.sendMessage(Identity.nil(), event.message()));
        }
        ((ServerPlayerBridge)mcPlayer).bridge$setConnectionMessageToSend(null);
        PhaseContext<?> context = PhaseTracker.SERVER.getPhaseContext();
        PhaseTracker.SERVER.pushCause(event);
        TransactionalCaptureSupplier transactor = context.getTransactor();
        transactor.logPlayerInventoryChange((PlayerEntity)mcPlayer, PlayerInventoryTransaction.EventCreator.STANDARD);
        try (EffectTransactor ignored = BroadcastInventoryChangesEffect.transact(transactor);){
            mcPlayer.field_71069_bz.func_75142_b();
        }
    }

    @Redirect(method={"func_72367_e(Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;func_201300_aS()Lnet/minecraft/server/CustomServerBossInfoManager;"))
    private CustomServerBossInfoManager impl$getPerWorldBossBarManager(MinecraftServer minecraftServer, ServerPlayerEntity playerIn) {
        return ((ServerLevelBridge)playerIn.func_71121_q()).bridge$getBossBarManager();
    }

    @Inject(method={"func_72367_e(Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at={@At(value="HEAD")})
    private void impl$RemovePlayerReferenceFromScoreboard(ServerPlayerEntity player, CallbackInfo ci) {
        ((ServerScoreboardBridge)((Object)((ServerPlayer)player).scoreboard())).bridge$removePlayer(player, false);
    }

    @Redirect(method={"func_212504_a(Lnet/minecraft/world/server/ServerWorld;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/border/WorldBorder;func_177737_a(Lnet/minecraft/world/border/IBorderListener;)V"))
    private void impl$usePerWorldBorderListener(WorldBorder worldBorder, IBorderListener listener, net.minecraft.world.server.ServerWorld serverWorld) {
        worldBorder.func_177737_a((IBorderListener)new PerWorldBorderListener(serverWorld));
    }

    @Redirect(method={"func_72380_a(Lnet/minecraft/entity/player/ServerPlayerEntity;)Lnet/minecraft/nbt/CompoundNBT;"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;func_70020_e(Lnet/minecraft/nbt/CompoundNBT;)V"))
    private void impl$setSpongePlayerDataForSinglePlayer(ServerPlayerEntity entity, CompoundNBT compound) {
        entity.func_70020_e(compound);
        ((SpongeServer)this.shadow$func_72365_p()).getPlayerDataManager().readPlayerData(compound, entity.func_110124_au(), null);
    }

    @Redirect(method={"func_232644_a_(Lnet/minecraft/entity/player/ServerPlayerEntity;Z)Lnet/minecraft/entity/player/ServerPlayerEntity;"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z", remap=false), slice=@Slice(from=@At(value="INVOKE", target="Ljava/util/Optional;empty()Ljava/util/Optional;", remap=false), to=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;func_71242_L()Z")))
    private boolean impl$flagIfRespawnLocationIsGameMechanic(Optional<?> optional) {
        this.impl$isGameMechanicRespawn = optional.isPresent();
        return this.impl$isGameMechanicRespawn;
    }

    @Redirect(method={"func_232644_a_(Lnet/minecraft/entity/player/ServerPlayerEntity;Z)Lnet/minecraft/entity/player/ServerPlayerEntity;"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;func_147359_a(Lnet/minecraft/network/IPacket;)V", ordinal=1))
    private void impl$callRespawnPlayerRecreateEvent(ServerPlayNetHandler serverPlayNetHandler, IPacket<?> packetIn, ServerPlayerEntity originalPlayer, boolean keepAllPlayerData) {
        ServerPlayerEntity recreatedPlayer = serverPlayNetHandler.field_147369_b;
        Vector3d originalPosition = VecHelper.toVector3d(originalPlayer.func_213303_ch());
        Vector3d destinationPosition = VecHelper.toVector3d(recreatedPlayer.func_213303_ch());
        ServerWorld originalWorld = (ServerWorld)originalPlayer.field_70170_p;
        ServerWorld originalDestinationWorld = (ServerWorld)this.field_72400_f.func_71218_a(this.impl$originalDestination == null ? World.field_234918_g_ : this.impl$originalDestination);
        ServerWorld destinationWorld = (ServerWorld)this.field_72400_f.func_71218_a(this.impl$newDestination == null ? World.field_234918_g_ : this.impl$newDestination);
        RespawnPlayerEvent.Recreate event = SpongeEventFactory.createRespawnPlayerEventRecreate(PhaseTracker.getCauseStackManager().currentCause(), destinationPosition, originalWorld, originalPosition, destinationWorld, originalDestinationWorld, destinationPosition, (ServerPlayer)originalPlayer, (ServerPlayer)recreatedPlayer, this.impl$isGameMechanicRespawn, !keepAllPlayerData);
        SpongeCommon.post(event);
        recreatedPlayer.func_70107_b(event.destinationPosition().x(), event.destinationPosition().y(), event.destinationPosition().z());
        this.impl$isGameMechanicRespawn = false;
        this.impl$originalDestination = null;
        this.impl$newDestination = null;
        net.minecraft.world.server.ServerWorld targetWorld = (net.minecraft.world.server.ServerWorld)event.destinationWorld();
        ((ServerPlayerBridge)recreatedPlayer).bridge$sendChangeDimension(targetWorld.func_230315_m_(), ((ClientboundRespawnPacketAccessor)packetIn).accessor$dimension(), ((ClientboundRespawnPacketAccessor)packetIn).accessor$seed(), recreatedPlayer.field_71134_c.func_73081_b(), recreatedPlayer.field_71134_c.func_241815_c_(), targetWorld.func_234925_Z_(), targetWorld.func_241109_A_(), keepAllPlayerData);
    }

    @Inject(method={"func_232644_a_(Lnet/minecraft/entity/player/ServerPlayerEntity;Z)Lnet/minecraft/entity/player/ServerPlayerEntity;"}, at={@At(value="RETURN")})
    private void impl$callRespawnPlayerPostEvent(ServerPlayerEntity player, boolean keepAllPlayerData, CallbackInfoReturnable<ServerPlayerEntity> cir) {
        ServerWorld originalWorld = (ServerWorld)player.field_70170_p;
        ServerWorld originalDestinationWorld = (ServerWorld)this.field_72400_f.func_71218_a(this.impl$originalDestination == null ? World.field_234918_g_ : this.impl$originalDestination);
        ServerWorld destinationWorld = (ServerWorld)this.field_72400_f.func_71218_a(this.impl$newDestination == null ? World.field_234918_g_ : this.impl$newDestination);
        RespawnPlayerEvent.Post event = SpongeEventFactory.createRespawnPlayerEventPost(PhaseTracker.getCauseStackManager().currentCause(), destinationWorld, originalWorld, originalDestinationWorld, (ServerPlayer)cir.getReturnValue());
        SpongeCommon.post(event);
    }

    @Redirect(method={"func_72354_b(Lnet/minecraft/entity/player/ServerPlayerEntity;Lnet/minecraft/world/server/ServerWorld;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;func_241755_D_()Lnet/minecraft/world/server/ServerWorld;"))
    private net.minecraft.world.server.ServerWorld impl$usePerWorldWorldBorder(MinecraftServer minecraftServer, ServerPlayerEntity playerIn, net.minecraft.world.server.ServerWorld worldIn) {
        return worldIn;
    }

    private void impl$disconnectClient(NetworkManager netManager, Component disconnectMessage, @Nullable org.spongepowered.api.profile.GameProfile profile) {
        ITextComponent reason = SpongeAdventure.asVanilla(disconnectMessage);
        try {
            field_148546_d.info("Disconnecting " + (profile != null ? profile.toString() + " (" + netManager.func_74430_c().toString() + ")" : netManager.func_74430_c() + ": " + reason.getString()));
            netManager.func_179290_a((IPacket)new SDisconnectPacket(reason));
            netManager.func_150718_a(reason);
        }
        catch (Exception exception) {
            field_148546_d.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    @Inject(method={"func_72389_g()V"}, at={@At(value="RETURN")})
    private void impl$saveDirtyUsersOnSaveAll(CallbackInfo ci) {
        ((SpongeServer)SpongeCommon.server()).userManager().saveDirtyUsers();
    }
}

