/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.damagesource;

import com.google.common.base.MoreObjects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.accessor.world.level.ExplosionAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.damagesource.DamageSourceBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.registry.provider.DamageSourceToTypeProvider;
import org.spongepowered.common.util.MemoizedSupplier;

@Mixin(value={DamageSource.class})
public abstract class DamageSourceMixin
implements DamageSourceBridge {
    @Shadow
    @Final
    @Mutable
    public static DamageSource field_76371_c;
    @Shadow
    @Final
    @Mutable
    public static DamageSource field_76372_a;
    @Shadow
    @Final
    @Mutable
    public static DamageSource field_180137_b;
    @Shadow
    @Final
    @Mutable
    public static DamageSource field_190095_e;
    @Shadow
    @Final
    @Mutable
    public static DamageSource field_82728_o;
    @Shadow
    @Final
    @Mutable
    public static DamageSource field_82729_p;
    @Shadow
    @Final
    @Mutable
    public static DamageSource field_76367_g;
    @Shadow
    @Final
    public String field_76373_n;
    Supplier<DamageType> impl$damageType;

    @Shadow
    @Nullable
    public abstract Entity shadow$func_76346_g();

    @Inject(method={"<init>(Ljava/lang/String;)V"}, at={@At(value="RETURN")})
    private void impl$setDamageTypeOnConstruction(String damageType, CallbackInfo ci) {
        this.bridge$resetDamageType();
    }

    @Inject(method={"func_151519_b(Lnet/minecraft/entity/LivingEntity;)Lnet/minecraft/util/text/ITextComponent;"}, cancellable=true, at={@At(value="RETURN")})
    private void beforeGetDeathMessageReturn(LivingEntity livingEntity, CallbackInfoReturnable<ITextComponent> cir) {
        if (((ITextComponent)cir.getReturnValue()).getString().equals("death.attack." + this.field_76373_n)) {
            cir.setReturnValue((Object)new TranslationTextComponent("death.attack.generic", new Object[]{livingEntity.func_145748_c_()}));
        }
    }

    @Inject(method={"func_94539_a(Lnet/minecraft/world/Explosion;)Lnet/minecraft/util/DamageSource;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onSetExplosionSource(@Nullable Explosion explosion, CallbackInfoReturnable<DamageSource> cir) {
        Entity entity;
        if (explosion != null && (entity = ((ExplosionAccessor)explosion).accessor$source()) != null && !((LevelBridge)((ExplosionAccessor)explosion).accessor$level()).bridge$isFake() && explosion.func_94613_c() == null && entity instanceof CreatorTrackedBridge) {
            CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)entity;
            creatorBridge.tracker$getCreatorUUID().flatMap(x -> Sponge.server().player((UUID)x)).ifPresent(player -> {
                IndirectEntityDamageSource damageSource = new IndirectEntityDamageSource("explosion.player", entity, (Entity)player);
                damageSource.func_76351_m().func_94540_d();
                cir.setReturnValue((Object)damageSource);
            });
        }
    }

    @Override
    public DamageType bridge$getDamageType() {
        return this.impl$damageType.get();
    }

    @Override
    public void bridge$resetDamageType() {
        this.impl$damageType = !this.field_76373_n.contains(":") ? MemoizedSupplier.memoize(() -> DamageSourceToTypeProvider.INSTANCE.getOrCustom(this.field_76373_n).get()) : MemoizedSupplier.memoize(() -> Sponge.game().registry(RegistryTypes.DAMAGE_TYPE).findValue(ResourceKey.resolve(this.field_76373_n)).orElseGet(DamageTypes.CUSTOM));
    }

    @Override
    public void bridge$setLava() {
        field_76371_c = (DamageSource)this;
    }

    @Override
    public void bridge$setFireSource() {
        field_76372_a = (DamageSource)this;
    }

    @Override
    public void bridge$setLightningSource() {
        field_180137_b = (DamageSource)this;
    }

    @Override
    public void bridge$setHotFloorSource() {
        field_190095_e = (DamageSource)this;
    }

    @Override
    public void bridge$setFallingBlockSource() {
        field_82729_p = (DamageSource)this;
    }

    @Override
    public void bridge$setAnvilSource() {
        field_82728_o = (DamageSource)this;
    }

    @Override
    public void bridge$setCactusSource() {
        field_76367_g = (DamageSource)this;
    }

    public String toString() {
        ResourceKey resourceKey = Sponge.game().registry(RegistryTypes.DAMAGE_TYPE).valueKey(this.impl$damageType.get());
        return MoreObjects.toStringHelper((String)"DamageSource").add("Name", (Object)this.field_76373_n).add("Key", (Object)resourceKey).toString();
    }
}

