/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.LightningEvent;
import org.spongepowered.api.event.entity.ExpireEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;

@Mixin(value={LightningBoltEntity.class})
public abstract class LightningBoltMixin
extends EntityMixin {
    @Shadow
    private boolean field_184529_d;
    @Shadow
    private int field_70262_b;

    @Redirect(method={"func_70071_h_()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;func_175674_a(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;Ljava/util/function/Predicate;)Ljava/util/List;"))
    private List<Entity> impl$ThrowEventAndProcess(World level, Entity thisEntity, AxisAlignedBB boundingBox, Predicate<Entity> predicate) {
        if (this.field_70128_L || this.field_70170_p.field_72995_K) {
            return Collections.emptyList();
        }
        List originalEntities = level.func_175674_a(thisEntity, boundingBox, predicate);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            LightningEvent.Strike strike = SpongeEventFactory.createLightningEventStrike(frame.currentCause(), originalEntities);
            Sponge.eventManager().post(strike);
            if (strike.isCancelled()) {
                List<Entity> list = Collections.emptyList();
                return list;
            }
        }
        return originalEntities;
    }

    @Inject(method={"func_70071_h_()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/effect/LightningBoltEntity;func_70106_y()V")})
    private void impl$ThrowLightningPost(CallbackInfo ci) {
        if (this.field_70170_p.field_72995_K || this.field_70262_b >= 0) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            LightningEvent.Post strike = SpongeEventFactory.createLightningEventPost(frame.currentCause());
            Sponge.eventManager().post(strike);
            ExpireEntityEvent event = SpongeEventFactory.createExpireEntityEvent(frame.currentCause(), (org.spongepowered.api.entity.Entity)((Object)this));
            Sponge.eventManager().post(event);
        }
    }
}

