/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.stats.Stats;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.SleepingEvent;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.item.inventory.UseItemStackEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.entity.LivingEntityBridge;
import org.spongepowered.common.bridge.world.entity.PlatformLivingEntityBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.entity.living.human.HumanEntity;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.cause.entity.damage.SpongeDamageSources;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;
import org.spongepowered.common.util.DamageEventUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends EntityMixin
implements LivingEntityBridge,
PlatformLivingEntityBridge {
    @Shadow
    protected int field_184628_bn;
    @Shadow
    protected boolean field_70729_aU;
    @Shadow
    protected int field_70744_aE;
    @Shadow
    protected ItemStack field_184627_bm;
    @Nullable
    private ItemStack impl$activeItemStackCopy;
    @Nullable
    private Vector3d impl$preTeleportPosition;
    private int impl$deathEventsPosted;

    @Shadow
    public abstract ModifiableAttributeInstance shadow$func_110148_a(Attribute var1);

    @Shadow
    public abstract void shadow$func_70606_j(float var1);

    @Shadow
    public abstract void shadow$func_110149_m(float var1);

    @Shadow
    public abstract void shadow$func_184611_a(Hand var1, @Nullable ItemStack var2);

    @Shadow
    public abstract void shadow$func_184602_cy();

    @Shadow
    public abstract int shadow$func_184605_cv();

    @Shadow
    public abstract float shadow$func_110139_bj();

    @Shadow
    public abstract float shadow$func_110143_aJ();

    @Shadow
    public abstract boolean shadow$func_70644_a(Effect var1);

    @Shadow
    public abstract ItemStack shadow$func_184582_a(EquipmentSlotType var1);

    @Shadow
    public abstract ItemStack shadow$func_184614_ca();

    @Shadow
    public abstract CombatTracker shadow$func_110142_aN();

    @Shadow
    public void shadow$func_174812_G() {
    }

    @Shadow
    public abstract Hand shadow$func_184600_cs();

    @Shadow
    protected abstract void shadow$func_184590_k(float var1);

    @Shadow
    protected abstract void shadow$func_190629_c(LivingEntity var1);

    @Shadow
    public abstract Optional<BlockPos> shadow$func_213374_dv();

    @Shadow
    protected abstract void shadow$func_195062_a(ItemStack var1, int var2);

    @Shadow
    public abstract boolean shadow$func_70617_f_();

    @Shadow
    public abstract void shadow$func_70031_b(boolean var1);

    @Shadow
    public abstract void shadow$func_130011_c(net.minecraft.entity.Entity var1);

    @Shadow
    protected abstract void shadow$func_230294_b_(DamageSource var1, float var2);

    @Shadow
    public abstract ItemStack shadow$func_184586_b(Hand var1);

    @Shadow
    protected abstract void shadow$func_213337_cE();

    @Shadow
    protected abstract void shadow$func_213345_d(DamageSource var1);

    @Shadow
    @Nullable
    public abstract LivingEntity shadow$func_94060_bK();

    @Shadow
    protected abstract void shadow$func_226298_f_(@Nullable LivingEntity var1);

    @Shadow
    public abstract Collection<EffectInstance> shadow$func_70651_bq();

    @Shadow
    public abstract float shadow$func_110138_aP();

    @Shadow
    public abstract AttributeModifierManager shadow$func_233645_dx_();

    @Shadow
    public abstract void shadow$func_213372_dw();

    @Shadow
    protected abstract float shadow$func_70655_b(DamageSource var1, float var2);

    @Shadow
    protected abstract float shadow$func_70672_c(DamageSource var1, float var2);

    @Override
    public boolean bridge$damageEntity(DamageSource damageSource, float damage) {
        if (this.shadow$func_180431_b(damageSource)) {
            return false;
        }
        boolean isHuman = (LivingEntity)this instanceof PlayerEntity;
        float originalDamage = damage = this.bridge$applyModDamage((LivingEntity)this, damageSource, damage);
        if (damage <= 0.0f) {
            return false;
        }
        ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
        Optional<DamageFunction> hardHatFunction = DamageEventUtil.createHardHatModifier((LivingEntity)this, damageSource);
        Optional<DamageFunction> armorFunction = DamageEventUtil.createArmorModifiers((LivingEntity)this, damageSource);
        Optional<DamageFunction> resistanceFunction = DamageEventUtil.createResistanceModifier((LivingEntity)this, damageSource);
        Optional<List<DamageFunction>> armorEnchantments = DamageEventUtil.createEnchantmentModifiers((LivingEntity)this, damageSource);
        Optional<DamageFunction> absorptionFunction = DamageEventUtil.createAbsorptionModifier((LivingEntity)this);
        Optional<DamageFunction> shieldFunction = DamageEventUtil.createShieldFunction((LivingEntity)this, damageSource, damage);
        hardHatFunction.ifPresent(originalFunctions::add);
        shieldFunction.ifPresent(originalFunctions::add);
        armorFunction.ifPresent(originalFunctions::add);
        resistanceFunction.ifPresent(originalFunctions::add);
        armorEnchantments.ifPresent(originalFunctions::addAll);
        absorptionFunction.ifPresent(originalFunctions::add);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            float f2;
            DamageEventUtil.generateCauseFor(damageSource, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.currentCause(), (Entity)((Object)this), originalFunctions, originalDamage);
            if (damageSource != SpongeDamageSources.IGNORED) {
                SpongeCommon.post(event);
            }
            if (event.isCancelled()) {
                boolean bl = false;
                return bl;
            }
            damage = (float)event.finalDamage();
            damage = this.bridge$applyModDamageBeforeFunctions((LivingEntity)this, damageSource, damage);
            ItemStack helmet = this.shadow$func_184582_a(EquipmentSlotType.HEAD);
            if (damageSource instanceof FallingBlockDamageSource || damageSource == DamageSource.field_82728_o || damageSource == DamageSource.field_82729_p && !helmet.func_190926_b()) {
                helmet.func_222118_a((int)(event.baseDamage() * 4.0 + (double)this.field_70146_Z.nextFloat() * event.baseDamage() * 2.0), (LivingEntity)this, entity -> entity.func_213361_c(EquipmentSlotType.HEAD));
            }
            boolean hurtStack = false;
            if (shieldFunction.isPresent()) {
                net.minecraft.entity.Entity entity2;
                this.shadow$func_184590_k((float)event.baseDamage());
                hurtStack = true;
                if (!damageSource.func_76352_a() && (entity2 = damageSource.func_76364_f()) instanceof LivingEntity) {
                    this.shadow$func_190629_c((LivingEntity)entity2);
                }
            }
            if (!damageSource.func_76363_c() && armorFunction.isPresent()) {
                this.shadow$func_230294_b_(damageSource, (float)event.baseDamage());
                hurtStack = true;
            }
            if (hurtStack && isHuman) {
                PhaseTracker.SERVER.getPhaseContext().getTransactor().logPlayerInventoryChange((PlayerEntity)this, PlayerInventoryTransaction.EventCreator.STANDARD);
                ((PlayerEntity)this).field_71069_bz.func_75142_b();
            }
            if (resistanceFunction.isPresent() && (f2 = (float)event.damage(resistanceFunction.get().modifier()) - damage) > 0.0f && f2 < 3.4028235E37f) {
                if ((LivingEntity)this instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)((LivingEntity)this)).func_195067_a(Stats.field_212739_K, Math.round(f2 * 10.0f));
                } else if (damageSource.func_76346_g() instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)damageSource.func_76346_g()).func_195067_a(Stats.field_212736_G, Math.round(f2 * 10.0f));
                }
            }
            double absorptionModifier = absorptionFunction.map(function -> event.damage(function.modifier())).orElse(0.0);
            if (absorptionFunction.isPresent()) {
                absorptionModifier = event.damage(absorptionFunction.get().modifier());
            }
            float f = (float)event.finalDamage() - (float)absorptionModifier;
            this.shadow$func_110149_m(Math.max(this.shadow$func_110139_bj() + (float)absorptionModifier, 0.0f));
            if (f > 0.0f && f < 3.4028235E37f && (LivingEntity)this instanceof ServerPlayerEntity) {
                ((PlayerEntity)this).func_195067_a(Stats.field_212735_F, Math.round(f * 10.0f));
            }
            if (damage != 0.0f) {
                if (isHuman) {
                    ((PlayerEntity)this).func_71020_j(damageSource.func_76345_d());
                }
                float f22 = this.shadow$func_110143_aJ();
                this.shadow$func_70606_j(f22 - damage);
                this.shadow$func_110142_aN().func_94547_a(damageSource, f22, damage);
                if (isHuman) {
                    if (damage < 3.4028235E37f) {
                        ((PlayerEntity)this).func_195067_a(Stats.field_188112_z, Math.round(damage * 10.0f));
                    }
                    boolean bl = true;
                    return bl;
                }
                this.shadow$func_110149_m(this.shadow$func_110139_bj() - damage);
            }
            boolean bl = true;
            return bl;
        }
    }

    @Inject(method={"func_70606_j(F)V"}, at={@At(value="HEAD")})
    private void impl$resetDeathEventCounter(float health, CallbackInfo info) {
        if (this.shadow$func_110143_aJ() <= 0.0f && health > 0.0f) {
            this.impl$deathEventsPosted = 0;
        }
    }

    @Redirect(method={"func_226294_cV_()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;func_70693_a(Lnet/minecraft/entity/player/PlayerEntity;)I"))
    protected int impl$exposeGetExperienceForDeath(LivingEntity entity, PlayerEntity attackingPlayer) {
        return this.bridge$getExperiencePointsOnDeath(entity, attackingPlayer);
    }

    @Overwrite
    protected void func_70665_d(DamageSource damageSource, float damage) {
        this.bridge$damageEntity(damageSource, damage);
    }

    @Inject(method={"func_70645_a(Lnet/minecraft/util/DamageSource;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwDestructEntityDeath(DamageSource cause, CallbackInfo ci) {
        boolean throwEvent;
        boolean bl = throwEvent = !((LevelBridge)this.field_70170_p).bridge$isFake() && Sponge.isServerAvailable() && Sponge.server().onMainThread();
        if (!this.field_70729_aU) {
            if (throwEvent && this.impl$deathEventsPosted <= 3) {
                ++this.impl$deathEventsPosted;
                if (SpongeCommonEventFactory.callDestructEntityEventDeath((LivingEntity)this, cause).isCancelled()) {
                    ci.cancel();
                }
            }
        } else {
            this.impl$deathEventsPosted = 0;
        }
    }

    @Inject(method={"func_70645_a(Lnet/minecraft/util/DamageSource;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;func_72960_a(Lnet/minecraft/entity/Entity;B)V")}, cancellable=true)
    private void impl$doNotSendStateForHumans(DamageSource cause, CallbackInfo ci) {
        if ((LivingEntity)this instanceof HumanEntity) {
            ci.cancel();
        }
    }

    @Redirect(method={"func_213345_d(Lnet/minecraft/util/DamageSource;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;func_213337_cE()V"))
    private void tracker$dropInventory(LivingEntity thisEntity) {
        if (thisEntity instanceof PlayerBridge && ((PlayerBridge)thisEntity).bridge$keepInventory()) {
            return;
        }
        this.shadow$func_213337_cE();
    }

    @Inject(method={"func_85033_bc()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$pushEntitiesIfNotVanished(CallbackInfo ci) {
        if (this.bridge$vanishState().ignoresCollisions()) {
            ci.cancel();
        }
    }

    @Redirect(method={"func_226293_b_(Lnet/minecraft/item/ItemStack;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;func_195062_a(Lnet/minecraft/item/ItemStack;I)V"))
    private void impl$hideItemParticlesIfVanished(LivingEntity livingEntity, ItemStack stack, int count) {
        if (this.bridge$vanishState().createsParticles()) {
            this.shadow$func_195062_a(stack, count);
        }
    }

    @Inject(method={"func_213373_a(DDDZ)Z"}, at={@At(value="HEAD")})
    private void impl$snapshotPositionBeforeVanillaTeleportLogic(double x, double y, double z, boolean changeState, CallbackInfoReturnable<Boolean> cir) {
        this.impl$preTeleportPosition = new Vector3d(this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_());
    }

    @Inject(method={"func_213373_a(DDDZ)Z"}, at={@At(value="RETURN", ordinal=0, shift=At.Shift.BY, by=2)}, cancellable=true)
    private void impl$callMoveEntityEventForTeleport(double x, double y, double z, boolean changeState, CallbackInfoReturnable<Boolean> cir) {
        if (!ShouldFire.MOVE_ENTITY_EVENT) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            MoveEntityEvent event;
            frame.pushCause(this);
            if (!frame.currentContext().containsKey(EventContextKeys.MOVEMENT_TYPE)) {
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.ENTITY_TELEPORT);
            }
            if (SpongeCommon.post(event = SpongeEventFactory.createMoveEntityEvent(frame.currentCause(), (Entity)((Object)this), this.impl$preTeleportPosition, new Vector3d(this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_()), new Vector3d(x, y, z)))) {
                this.shadow$func_70634_a(this.impl$preTeleportPosition.x(), this.impl$preTeleportPosition.y(), this.impl$preTeleportPosition.z());
                cir.setReturnValue((Object)false);
                return;
            }
            this.shadow$func_70634_a(event.destinationPosition().x(), event.destinationPosition().y(), event.destinationPosition().z());
        }
    }

    @Inject(method={"func_70067_L()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$ifVanishedDoNotPick(CallbackInfoReturnable<Boolean> cir) {
        if (this.bridge$vanishState().ignoresCollisions()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"func_213357_a(Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;func_184148_a(Lnet/minecraft/entity/player/PlayerEntity;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V"))
    private void impl$ignoreExperienceLevelSoundsWhileVanished(World world, PlayerEntity player, double x, double y, double z, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        if (!this.bridge$vanishState().createsSounds()) {
            return;
        }
        world.func_184148_a(player, x, y, z, sound, category, volume, pitch);
    }

    @Redirect(method={"func_184231_a(DZLnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;func_195598_a(Lnet/minecraft/particles/IParticleData;DDDIDDDD)I"))
    private <T extends IParticleData> int impl$vanishSpawnParticleForFallState(net.minecraft.world.server.ServerWorld serverLevel, T options, double xCoord, double yCoord, double zCoord, int numberOfParticles, double xOffset, double yOffset, double zOffset, double particleSpeed) {
        if (this.bridge$vanishState().createsParticles()) {
            return serverLevel.func_195598_a(options, xCoord, yCoord, zCoord, numberOfParticles, xOffset, yOffset, zOffset, particleSpeed);
        }
        return 0;
    }

    @Inject(method={"func_213361_c(Lnet/minecraft/inventory/EquipmentSlotType;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$vanishDoesNotBroadcastBreakEvents(EquipmentSlotType slot, CallbackInfo ci) {
        if (this.bridge$vanishState().invisible()) {
            ci.cancel();
        }
    }

    @Inject(method={"func_184608_ct()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;func_184602_cy()V")})
    protected void impl$updateHealthForUseFinish(CallbackInfo ci) {
    }

    @Inject(method={"func_184598_c(Lnet/minecraft/util/Hand;)V"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="FIELD", target="Lnet/minecraft/entity/LivingEntity;field_184627_bm:Lnet/minecraft/item/ItemStack;")})
    private void impl$onSetActiveItemStack(Hand hand, CallbackInfo ci, ItemStack stack) {
        UseItemStackEvent.Start event;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            HandType handType = (HandType)hand;
            this.impl$addSelfToFrame(frame, snapshot, handType);
            Ticks useDuration = Ticks.of(stack.func_77988_m());
            event = SpongeEventFactory.createUseItemStackEventStart(PhaseTracker.getCauseStackManager().currentCause(), useDuration, useDuration, snapshot);
        }
        if (SpongeCommon.post(event)) {
            ci.cancel();
        } else {
            this.field_184628_bn = (int)event.remainingDuration().ticks();
        }
    }

    @Redirect(method={"func_184598_c(Lnet/minecraft/util/Hand;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/LivingEntity;field_184628_bn:I"))
    private void impl$getItemDuration(LivingEntity this$0, int count) {
        if (this.field_70170_p.field_72995_K) {
            this.field_184628_bn = count;
        }
    }

    private void impl$addSelfToFrame(CauseStackManager.StackFrame frame, ItemStackSnapshot snapshot, HandType hand) {
        frame.addContext(EventContextKeys.USED_HAND, hand);
        this.impl$addSelfToFrame(frame, snapshot);
    }

    private void impl$addSelfToFrame(CauseStackManager.StackFrame frame, ItemStackSnapshot snapshot) {
        frame.pushCause(this);
        frame.addContext(EventContextKeys.USED_ITEM, snapshot);
        if (this instanceof ServerPlayer) {
            frame.addContext(EventContextKeys.CREATOR, ((ServerPlayer)((Object)this)).uniqueId());
            frame.addContext(EventContextKeys.NOTIFIER, ((ServerPlayer)((Object)this)).uniqueId());
        }
    }

    @Redirect(method={"func_184608_ct()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;func_184605_cv()I", ordinal=0))
    private int impl$onGetRemainingItemDuration(LivingEntity self) {
        UseItemStackEvent.Tick event;
        if (this.field_70170_p.field_72995_K) {
            return self.func_184605_cv();
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.field_184627_bm);
            HandType handType = (HandType)this.shadow$func_184600_cs();
            this.impl$addSelfToFrame(frame, snapshot, handType);
            Ticks useItemRemainingTicks = Ticks.of(this.field_184628_bn);
            event = SpongeEventFactory.createUseItemStackEventTick(PhaseTracker.getCauseStackManager().currentCause(), useItemRemainingTicks, useItemRemainingTicks, snapshot);
            SpongeCommon.post(event);
        }
        this.field_184628_bn = Math.max((int)event.remainingDuration().ticks(), 1);
        if (event.isCancelled()) {
            return 26;
        }
        return this.shadow$func_184605_cv();
    }

    @Inject(method={"func_71036_o()V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;func_226293_b_(Lnet/minecraft/item/ItemStack;I)V")})
    private void impl$onUpdateItemUse(CallbackInfo ci) {
        UseItemStackEvent.Finish event;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.field_184627_bm);
            HandType handType = (HandType)this.shadow$func_184600_cs();
            this.impl$addSelfToFrame(frame, snapshot, handType);
            Ticks useItemRemainingTicks = Ticks.of(this.field_184628_bn);
            event = SpongeEventFactory.createUseItemStackEventFinish(PhaseTracker.getCauseStackManager().currentCause(), useItemRemainingTicks, useItemRemainingTicks, snapshot);
        }
        SpongeCommon.post(event);
        if (event.remainingDuration().ticks() > 0L) {
            this.field_184628_bn = (int)event.remainingDuration().ticks();
            ci.cancel();
        } else if (event.isCancelled()) {
            this.shadow$func_184602_cy();
            ci.cancel();
        } else {
            this.impl$activeItemStackCopy = this.field_184627_bm.func_77946_l();
        }
    }

    @Redirect(method={"func_71036_o()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;func_184611_a(Lnet/minecraft/util/Hand;Lnet/minecraft/item/ItemStack;)V"))
    private void impl$onSetHeldItem(LivingEntity self, Hand hand, ItemStack stack) {
        UseItemStackEvent.Replace event;
        if (this.field_70170_p.field_72995_K) {
            self.func_184611_a(hand, stack);
            return;
        }
        ItemStackSnapshot activeItemStackSnapshot = ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy == null ? ItemStack.field_190927_a : this.impl$activeItemStackCopy);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack == null ? ItemStack.field_190927_a : stack);
            HandType handType = (HandType)hand;
            this.impl$addSelfToFrame(frame, activeItemStackSnapshot, handType);
            Ticks useItemRemainingTicks = Ticks.of(this.field_184628_bn);
            event = SpongeEventFactory.createUseItemStackEventReplace(PhaseTracker.getCauseStackManager().currentCause(), useItemRemainingTicks, useItemRemainingTicks, activeItemStackSnapshot, new Transaction<ItemStackSnapshot>(ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy), snapshot));
        }
        if (SpongeCommon.post(event)) {
            this.shadow$func_184611_a(hand, this.impl$activeItemStackCopy.func_77946_l());
            return;
        }
        if (!event.itemStackResult().isValid()) {
            this.shadow$func_184611_a(hand, this.impl$activeItemStackCopy.func_77946_l());
            return;
        }
        this.shadow$func_184611_a(hand, ItemStackUtil.fromSnapshotToNative(event.itemStackResult().finalReplacement()));
    }

    @Redirect(method={"func_184597_cx()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;func_77974_b(Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;I)V"))
    private void impl$onStopPlayerUsing(ItemStack stack, World world, LivingEntity self, int duration) {
        if (this.field_70170_p.field_72995_K) {
            stack.func_77974_b(world, self, duration);
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            HandType handType = (HandType)this.shadow$func_184600_cs();
            this.impl$addSelfToFrame(frame, snapshot, handType);
            Ticks ticksDuration = Ticks.of(duration);
            if (!SpongeCommon.post(SpongeEventFactory.createUseItemStackEventStop(PhaseTracker.getCauseStackManager().currentCause(), ticksDuration, ticksDuration, snapshot))) {
                stack.func_77974_b(world, self, duration);
                if (self instanceof ServerPlayerEntity) {
                    PhaseTracker.SERVER.getPhaseContext().getTransactor().logPlayerInventoryChange((PlayerEntity)((ServerPlayerEntity)self), PlayerInventoryTransaction.EventCreator.STANDARD);
                    ((ServerPlayerEntity)self).field_71069_bz.func_75142_b();
                }
            }
        }
    }

    @Inject(method={"func_184602_cy()V"}, at={@At(value="HEAD")})
    private void impl$onResetActiveHand(CallbackInfo ci) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy != null ? this.impl$activeItemStackCopy : this.field_184627_bm);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            this.impl$addSelfToFrame(frame, snapshot);
            Ticks useItemRemainingTicks = Ticks.of(this.field_184628_bn);
            SpongeCommon.post(SpongeEventFactory.createUseItemStackEventReset(PhaseTracker.getCauseStackManager().currentCause(), useItemRemainingTicks, useItemRemainingTicks, snapshot));
        }
        this.impl$activeItemStackCopy = null;
    }

    @Inject(method={"func_213366_dy()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;func_213372_dw()V")})
    private void impl$callFinishSleepingEvent(CallbackInfo ci) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Optional<BlockPos> sleepingPos = this.shadow$func_213374_dv();
        if (!sleepingPos.isPresent()) {
            return;
        }
        BlockSnapshot snapshot = ((ServerWorld)this.field_70170_p).createSnapshot(sleepingPos.get().func_177958_n(), sleepingPos.get().func_177956_o(), sleepingPos.get().func_177952_p());
        Cause currentCause = Sponge.server().causeStackManager().currentCause();
        ServerLocation loc = ServerLocation.of((ServerWorld)this.field_70170_p, VecHelper.toVector3d(this.shadow$func_213303_ch()));
        Vector3d rot = ((Living)((Object)this)).rotation();
        SleepingEvent.Finish event = SpongeEventFactory.createSleepingEventFinish(currentCause, loc, loc, rot, rot, snapshot, (Living)((Object)this));
        Sponge.eventManager().post(event);
        this.shadow$func_213372_dw();
        if (event.toLocation().world() != this.field_70170_p) {
            throw new UnsupportedOperationException("World change is not supported here.");
        }
        this.shadow$func_70107_b(event.toLocation().x(), event.toLocation().y(), event.toLocation().z());
        ((Living)((Object)this)).setRotation(event.toRotation());
    }
}

