/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.ai.goal.GoalExecutorTypes;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.entity.UnleashEntityEvent;
import org.spongepowered.api.event.entity.ai.SetAITargetEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.entity.GrieferBridge;
import org.spongepowered.common.bridge.world.entity.ai.goal.GoalSelectorBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.LivingEntityMixin;
import org.spongepowered.common.util.DamageEventUtil;

@Mixin(value={MobEntity.class})
public abstract class MobMixin
extends LivingEntityMixin {
    @Shadow
    @Final
    protected GoalSelector field_70714_bg;
    @Shadow
    @Final
    protected GoalSelector field_70715_bh;
    @Shadow
    @Nullable
    private LivingEntity field_70696_bz;

    @Shadow
    @Nullable
    public abstract Entity shadow$func_110166_bE();

    @Shadow
    protected abstract void shadow$func_184651_r();

    @Shadow
    protected abstract void shadow$func_233655_a_(PlayerEntity var1, ItemStack var2, ItemStack var3);

    @Redirect(method={"<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;func_184651_r()V"))
    private void impl$registerGoals(MobEntity this$0) {
        this.impl$setupGoalSelectors();
        this.shadow$func_184651_r();
    }

    private void impl$setupGoalSelectors() {
        if (!((GoalSelectorBridge)this.field_70714_bg).bridge$initialized()) {
            ((GoalSelectorBridge)this.field_70714_bg).bridge$setOwner((MobEntity)this);
            ((GoalSelectorBridge)this.field_70714_bg).bridge$setType(GoalExecutorTypes.NORMAL.get());
            ((GoalSelectorBridge)this.field_70714_bg).bridge$setInitialized(true);
        }
        if (!((GoalSelectorBridge)this.field_70715_bh).bridge$initialized()) {
            ((GoalSelectorBridge)this.field_70715_bh).bridge$setOwner((MobEntity)this);
            ((GoalSelectorBridge)this.field_70715_bh).bridge$setType(GoalExecutorTypes.TARGET.get());
            ((GoalSelectorBridge)this.field_70715_bh).bridge$setInitialized(true);
        }
    }

    @Inject(method={"func_110160_i(ZZ)V"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/MobEntity;field_110168_bw:Lnet/minecraft/entity/Entity;", opcode=181)}, cancellable=true)
    private void impl$ThrowUnleashEvent(boolean sendPacket, boolean dropLead, CallbackInfo ci) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Entity entity = this.shadow$func_110166_bE();
        CauseStackManager csm = PhaseTracker.getCauseStackManager();
        if (entity == null) {
            csm.pushCause(this);
        } else {
            csm.pushCause(entity);
        }
        UnleashEntityEvent event = SpongeEventFactory.createUnleashEntityEvent(csm.currentCause(), (Living)((Object)this));
        SpongeCommon.post(event);
        csm.popCause();
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"func_70624_b(Lnet/minecraft/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetAttackTarget(@Nullable LivingEntity entitylivingbaseIn, CallbackInfo ci) {
        if (this.field_70170_p.field_72995_K || entitylivingbaseIn == null) {
            return;
        }
        if (EntityUtil.isUntargetable((Entity)this, (Entity)entitylivingbaseIn)) {
            this.field_70696_bz = null;
            ci.cancel();
            return;
        }
        if (ShouldFire.SET_A_I_TARGET_EVENT) {
            SetAITargetEvent event = SpongeCommonEventFactory.callSetAttackTargetEvent((org.spongepowered.api.entity.Entity)entitylivingbaseIn, (Agent)((Object)this));
            if (event.isCancelled()) {
                ci.cancel();
            } else {
                this.field_70696_bz = event.target().orElse(null);
            }
        }
    }

    @Nullable
    @Overwrite
    public LivingEntity func_70638_az() {
        if (this.field_70696_bz != null && EntityUtil.isUntargetable((Entity)this, (Entity)this.field_70696_bz)) {
            this.field_70696_bz = null;
        }
        return this.field_70696_bz;
    }

    @Redirect(method={"func_70636_d()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;func_98052_bS()Z"))
    private boolean impl$onCanGrief(MobEntity thisEntity) {
        return thisEntity.func_98052_bS() && ((GrieferBridge)((Object)this)).bridge$canGrief();
    }

    @Overwrite
    public boolean func_70652_k(Entity targetEntity) {
        double originalBaseDamage = this.shadow$func_110148_a(Attributes.field_233823_f_).func_111126_e();
        ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
        float knockbackModifier = (float)this.shadow$func_110148_a(Attributes.field_233824_g_).func_111126_e();
        if (targetEntity instanceof LivingEntity) {
            originalFunctions.addAll(DamageEventUtil.createAttackEnchantmentFunction(this.shadow$func_184614_ca(), ((LivingEntity)targetEntity).func_70668_bt(), 1.0f));
            knockbackModifier += (float)EnchantmentHelper.func_77501_a((LivingEntity)((MobEntity)this));
        }
        DamageSource damageSource = DamageSource.func_76358_a((LivingEntity)((MobEntity)this));
        PhaseTracker.getCauseStackManager().pushCause(damageSource);
        AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(PhaseTracker.getCauseStackManager().currentCause(), (org.spongepowered.api.entity.Entity)targetEntity, originalFunctions, knockbackModifier, originalBaseDamage);
        SpongeCommon.post(event);
        PhaseTracker.getCauseStackManager().popCause();
        if (event.isCancelled()) {
            return false;
        }
        knockbackModifier = event.knockbackModifier();
        boolean attackSucceeded = targetEntity.func_70097_a(damageSource, (float)event.finalOutputDamage());
        if (attackSucceeded) {
            int j;
            if (knockbackModifier > 0.0f && targetEntity instanceof LivingEntity) {
                ((LivingEntity)targetEntity).func_233627_a_(knockbackModifier * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.shadow$func_213317_d(this.shadow$func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if ((j = EnchantmentHelper.func_90036_a((LivingEntity)((MobEntity)this))) > 0) {
                targetEntity.func_70015_d(j * 4);
            }
            if (targetEntity instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)targetEntity;
                ItemStack mainHandItem = this.shadow$func_184614_ca();
                ItemStack useItem = playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a;
                this.shadow$func_233655_a_(playerentity, mainHandItem, useItem);
            }
            this.shadow$func_174815_a((LivingEntity)((MobEntity)this), targetEntity);
            this.shadow$func_130011_c(targetEntity);
        }
        return attackSucceeded;
    }

    @Nullable
    @Redirect(method={"func_70623_bb()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;func_217362_a(Lnet/minecraft/entity/Entity;D)Lnet/minecraft/entity/player/PlayerEntity;"))
    private PlayerEntity impl$getClosestPlayerForSpawning(World world, Entity entityIn, double distance) {
        double bestDistance = -1.0;
        PlayerEntity result = null;
        for (PlayerEntity player : world.func_217369_A()) {
            if (player == null || player.field_70128_L || !((PlayerBridge)player).bridge$affectsSpawning()) continue;
            double playerDistance = player.func_70068_e(entityIn);
            if (!(distance < 0.0) && !(playerDistance < distance * distance) || bestDistance != -1.0 && !(playerDistance < bestDistance)) continue;
            bestDistance = playerDistance;
            result = player;
        }
        return result;
    }

    @Inject(method={"func_110162_b(Lnet/minecraft/entity/Entity;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetLeashedTo(Entity param0, boolean param1, CallbackInfo ci) {
        if (!this.field_70170_p.field_72995_K) {
            Cause currentCause = Sponge.server().causeStackManager().currentCause();
            if (Sponge.eventManager().post(SpongeEventFactory.createLeashEntityEvent(currentCause, (org.spongepowered.api.entity.Entity)((Object)this)))) {
                ci.cancel();
            }
        }
    }
}

