/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.ai.goal;

import com.google.common.base.MoreObjects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import org.spongepowered.api.entity.ai.goal.Goal;
import org.spongepowered.api.entity.ai.goal.GoalExecutor;
import org.spongepowered.api.entity.ai.goal.GoalExecutorType;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ai.goal.GoalEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.entity.ai.GoalBridge;
import org.spongepowered.common.bridge.world.entity.ai.goal.GoalSelectorBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={GoalSelector.class})
public abstract class GoalSelectorMixin
implements GoalSelectorBridge {
    @Shadow
    @Final
    private Set<PrioritizedGoal> field_220892_d;
    @Nullable
    private MobEntity owner;
    @Nullable
    private GoalExecutorType type;
    private boolean initialized;

    @Redirect(method={"func_75776_a(ILnet/minecraft/entity/ai/goal/Goal;)V"}, at=@At(value="INVOKE", target="Ljava/util/Set;add(Ljava/lang/Object;)Z", remap=false))
    private boolean onAddEntityTask(Set<PrioritizedGoal> goals, Object task, int priority, net.minecraft.entity.ai.goal.Goal base) {
        ((GoalBridge)base).bridge$setGoalExecutor((GoalExecutor)((Object)this));
        if (!ShouldFire.GOAL_EVENT_ADD || this.owner == null || ((EntityBridge)this.owner).bridge$isConstructing()) {
            return goals.add(new PrioritizedGoal(priority, base));
        }
        GoalEvent.Add event = SpongeEventFactory.createGoalEventAdd(PhaseTracker.getCauseStackManager().currentCause(), priority, priority, (Agent)this.owner, (GoalExecutor)((Object)this), (Goal)base);
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            ((GoalBridge)base).bridge$setGoalExecutor(null);
            return false;
        }
        return goals.add(new PrioritizedGoal(event.priority(), base));
    }

    @Override
    public MobEntity bridge$getOwner() {
        return this.owner;
    }

    @Override
    public void bridge$setOwner(MobEntity owner) {
        this.owner = owner;
    }

    @Override
    public GoalExecutorType bridge$getType() {
        return this.type;
    }

    @Override
    public void bridge$setType(GoalExecutorType type) {
        this.type = type;
    }

    @Overwrite
    public void func_85156_a(net.minecraft.entity.ai.goal.Goal task) {
        this.field_220892_d.removeIf(prioritizedGoal -> {
            if (prioritizedGoal.func_220772_j() == task) {
                if (ShouldFire.GOAL_EVENT_REMOVE && this.owner != null && !((EntityBridge)this.owner).bridge$isConstructing()) {
                    GoalEvent.Remove event = SpongeEventFactory.createGoalEventRemove(PhaseTracker.getCauseStackManager().currentCause(), (Agent)this.owner, (GoalExecutor)((Object)this), (Goal)task, prioritizedGoal.func_220770_h());
                    SpongeCommon.post(event);
                    if (event.isCancelled()) {
                        return false;
                    }
                }
                if (prioritizedGoal.func_220773_g()) {
                    prioritizedGoal.func_75251_c();
                }
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean bridge$initialized() {
        return this.initialized;
    }

    @Override
    public void bridge$setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.bridge$getOwner()).addValue((Object)this.bridge$getType()).toString();
    }
}

