/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.player;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.Stat;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.authlib.GameProfileHolderBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;
import org.spongepowered.common.bridge.world.food.FoodDataBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.entity.LivingEntityMixin;
import org.spongepowered.common.util.ExperienceHolderUtil;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerMixin
extends LivingEntityMixin
implements PlayerBridge,
GameProfileHolderBridge {
    @Shadow
    @Final
    protected static DataParameter<Byte> field_184827_bp;
    @Shadow
    public int field_71068_ca;
    @Shadow
    public int field_71067_cb;
    @Shadow
    public float field_71106_cc;
    @Shadow
    @Final
    public PlayerAbilities field_71075_bZ;
    @Shadow
    @Final
    public PlayerInventory field_71071_by;
    @Shadow
    public Container field_71070_bA;
    @Shadow
    @Final
    public PlayerContainer field_71069_bz;
    @Shadow
    @Final
    private GameProfile field_146106_i;
    private boolean impl$affectsSpawning = true;
    protected final boolean impl$isFake = ((PlatformEntityBridge)((PlayerEntity)this)).bridge$isFakePlayer();

    @Shadow
    public abstract boolean shadow$func_175149_v();

    @Shadow
    public abstract int shadow$func_71050_bK();

    @Shadow
    @Nullable
    public abstract ItemEntity shadow$func_146097_a(ItemStack var1, boolean var2, boolean var3);

    @Shadow
    public abstract FoodStats shadow$func_71024_bL();

    @Shadow
    public abstract Scoreboard shadow$func_96123_co();

    @Shadow
    public abstract boolean shadow$func_184812_l_();

    @Shadow
    public abstract String shadow$func_195047_I_();

    @Shadow
    public abstract void shadow$func_71029_a(Stat<?> var1);

    @Shadow
    public abstract ITextComponent shadow$func_145748_c_();

    @Shadow
    protected abstract void shadow$func_192030_dh();

    @Shadow
    public abstract void shadow$func_195066_a(ResourceLocation var1);

    @Shadow
    public Either<PlayerEntity.SleepResult, Unit> shadow$func_213819_a(BlockPos param0) {
        return null;
    }

    @Shadow
    protected abstract void shadow$func_192028_j(CompoundNBT var1);

    @Override
    public boolean bridge$affectsSpawning() {
        return this.impl$affectsSpawning && !this.shadow$func_175149_v() && !this.bridge$vanishState().untargetable();
    }

    @Override
    public void bridge$setAffectsSpawning(boolean affectsSpawning) {
        this.impl$affectsSpawning = affectsSpawning;
    }

    @Override
    public GameProfile bridge$getGameProfile() {
        return this.field_146106_i;
    }

    @Override
    public int bridge$getExperienceSinceLevel() {
        return this.field_71067_cb - ExperienceHolderUtil.xpAtLevel(this.field_71068_ca);
    }

    @Override
    public void bridge$setExperienceSinceLevel(int experience) {
        this.field_71067_cb = ExperienceHolderUtil.xpAtLevel(this.field_71068_ca) + experience;
        this.field_71106_cc = (float)experience / (float)this.shadow$func_71050_bK();
    }

    @Redirect(method={"func_70636_d()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;func_72839_b(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/util/List;"))
    private List<Entity> impl$ignoreOtherEntitiesWhenUncollideable(World level, Entity entity, AxisAlignedBB aabb) {
        if (this.bridge$vanishState().ignoresCollisions()) {
            return Collections.emptyList();
        }
        return level.func_72839_b(entity, aabb);
    }

    @Redirect(method={"func_70071_h_()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;func_70608_bn()Z"))
    private boolean impl$postSleepingEvent(PlayerEntity self) {
        if (self.func_70608_bn()) {
            if (!((LevelBridge)this.field_70170_p).bridge$isFake()) {
                CauseStackManager csm = PhaseTracker.getCauseStackManager();
                csm.pushCause(this);
                BlockPos bedLocation = this.shadow$func_213374_dv().get();
                BlockSnapshot snapshot = ((ServerWorld)this.field_70170_p).createSnapshot(bedLocation.func_177958_n(), bedLocation.func_177956_o(), bedLocation.func_177952_p());
                SpongeCommon.post(SpongeEventFactory.createSleepingEventTick(csm.currentCause(), snapshot, (Living)((Object)this)));
                csm.popCause();
            }
            return true;
        }
        return false;
    }

    @Redirect(method={"func_145748_c_()Lnet/minecraft/util/text/ITextComponent;"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;func_200200_C_()Lnet/minecraft/util/text/ITextComponent;"))
    private ITextComponent impl$useCustomNameIfSet(PlayerEntity playerEntity) {
        if (playerEntity instanceof ServerPlayerEntity) {
            if (playerEntity.func_145818_k_()) {
                return playerEntity.func_200201_e();
            }
            return playerEntity.func_200200_C_();
        }
        return playerEntity.func_200200_C_();
    }

    @Redirect(method={"func_70636_d()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;func_192028_j(Lnet/minecraft/nbt/CompoundNBT;)V"))
    private void impl$ignoreShoulderSoundsWhileVanished(PlayerEntity thisPlayer, CompoundNBT tag) {
        if (!this.bridge$vanishState().createsSounds()) {
            return;
        }
        this.shadow$func_192028_j(tag);
    }

    @Redirect(method={"func_184185_a(Lnet/minecraft/util/SoundEvent;FF)V", "func_82242_a(I)V", "func_213357_a(Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;func_184148_a(Lnet/minecraft/entity/player/PlayerEntity;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V"))
    private void impl$ignoreExperienceLevelSoundsWhileVanished(World world, PlayerEntity player, double x, double y, double z, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        if (!this.bridge$vanishState().createsSounds()) {
            return;
        }
        this.field_70170_p.func_184148_a(player, x, y, z, sound, category, volume, pitch);
    }

    @Redirect(method={"func_195070_dx()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;func_184840_I()I"))
    private int impl$checkPermissionForCommandBlock(PlayerEntity playerEntity) {
        if (this instanceof Subject) {
            return ((Subject)((Object)this)).hasPermission("minecraft.commandblock") ? 2 : 0;
        }
        return this.shadow$func_184840_I();
    }

    @Redirect(method={"func_175151_a(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/Direction;Lnet/minecraft/item/ItemStack;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;func_206847_b(Lnet/minecraft/tags/ITagCollectionSupplier;Lnet/minecraft/util/CachedBlockInfo;)Z"))
    private boolean impl$callChangeBlockPre(ItemStack stack, ITagCollectionSupplier tagSupplier, CachedBlockInfo cachedBlockInfo) {
        if (!stack.func_206847_b(tagSupplier, cachedBlockInfo)) {
            return false;
        }
        if (this.field_70170_p instanceof LevelBridge && !((LevelBridge)this.field_70170_p).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
                boolean bl = !SpongeCommonEventFactory.callChangeBlockEventPre((ServerLevelBridge)this.field_70170_p, cachedBlockInfo.func_177508_d(), (Object)this).isCancelled();
                return bl;
            }
        }
        return true;
    }

    @Overwrite
    @Nullable
    public ItemEntity func_71019_a(ItemStack itemStackIn, boolean traceItem) {
        return this.shadow$func_146097_a(itemStackIn, false, traceItem);
    }

    @Inject(method={"func_190531_bD()I"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$useCustomFireImmuneTicks(CallbackInfoReturnable<Integer> ci) {
        if (this.impl$hasCustomFireImmuneTicks) {
            ci.setReturnValue((Object)this.impl$fireImmuneTicks);
        }
    }

    @Inject(method={"func_190775_a(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResultType;"}, at={@At(value="HEAD")}, cancellable=true)
    protected void impl$onRightClickEntity(Entity entityToInteractOn, Hand hand, CallbackInfoReturnable<ActionResultType> cir) {
    }

    @Override
    public boolean impl$canCallIgniteEntityEvent() {
        return super.impl$canCallIgniteEntityEvent() && !this.shadow$func_175149_v() && !this.shadow$func_184812_l_();
    }

    @Inject(method={"func_96122_a(Lnet/minecraft/entity/player/PlayerEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onCanHarmPlayer(PlayerEntity other, CallbackInfoReturnable<Boolean> cir) {
        if (!(other instanceof ServerPlayer)) {
            return;
        }
        Team otherTeam = other.func_96124_cp();
        ScorePlayerTeam thisTeam = ((Scoreboard)((ServerPlayerBridge)other).bridge$getScoreboard()).func_96509_i(this.shadow$func_195047_I_());
        cir.setReturnValue((Object)(otherTeam == null || !otherTeam.func_142054_a((Team)thisTeam) || otherTeam.func_96665_g() ? 1 : 0));
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;FLcom/mojang/authlib/GameProfile;)V"}, at={@At(value="RETURN")})
    private void impl$foodData(CallbackInfo ci) {
        ((FoodDataBridge)this.shadow$func_71024_bL()).bridge$setPlayer((PlayerEntity)this);
    }
}

