/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.player;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.api.event.cause.entity.damage.ModifierFunction;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.hooks.EventHooks;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.entity.LivingEntityMixin;
import org.spongepowered.common.util.DamageEventUtil;

@Mixin(value={PlayerEntity.class}, priority=900)
public abstract class PlayerMixin_Attack_Impl
extends LivingEntityMixin {
    @Shadow
    @Final
    public PlayerContainer field_71069_bz;

    @Shadow
    public abstract float shadow$func_184825_o(float var1);

    @Shadow
    public abstract void shadow$func_184821_cY();

    @Shadow
    public abstract float shadow$func_70689_ay();

    @Shadow
    public abstract void shadow$func_184810_cG();

    @Shadow
    public abstract void shadow$func_71009_b(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void shadow$func_71047_c(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void shadow$func_195067_a(ResourceLocation var1, int var2);

    @Shadow
    public abstract void shadow$func_71020_j(float var1);

    @Overwrite
    public void func_71059_n(net.minecraft.entity.Entity targetEntity) {
        if (!PlatformHooks.INSTANCE.getEntityHooks().checkAttackEntity((PlayerEntity)this, targetEntity)) {
            return;
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((net.minecraft.entity.Entity)((PlayerEntity)this))) {
            double originalBaseDamage = this.shadow$func_110148_a(Attributes.field_233823_f_).func_111126_e();
            float damage = (float)originalBaseDamage;
            float enchantmentDamage = 0.0f;
            float attackStrength = this.shadow$func_184825_o(0.5f);
            ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
            CreatureAttribute creatureAttribute = targetEntity instanceof LivingEntity ? ((LivingEntity)targetEntity).func_70668_bt() : CreatureAttribute.field_223222_a_;
            List<DamageFunction> enchantmentModifierFunctions = DamageEventUtil.createAttackEnchantmentFunction(this.shadow$func_184614_ca(), creatureAttribute, attackStrength);
            List enchantmentModifiers = enchantmentModifierFunctions.stream().map(ModifierFunction::modifier).collect(Collectors.toList());
            enchantmentDamage = (float)enchantmentModifierFunctions.stream().map(ModifierFunction::function).mapToDouble(function -> function.applyAsDouble(originalBaseDamage)).sum();
            originalFunctions.addAll(enchantmentModifierFunctions);
            originalFunctions.add(DamageEventUtil.provideCooldownAttackStrengthFunction((PlayerEntity)this, attackStrength));
            enchantmentDamage *= attackStrength;
            this.shadow$func_184821_cY();
            if ((damage *= 0.2f + attackStrength * attackStrength * 0.8f) > 0.0f || enchantmentDamage > 0.0f) {
                boolean isMainthread;
                boolean isStrongAttack = attackStrength > 0.9f;
                boolean isSprintingAttack = false;
                boolean isCriticalAttack = false;
                boolean isSweapingAttack = false;
                int knockbackModifier = 0;
                knockbackModifier += EnchantmentHelper.func_77501_a((LivingEntity)((PlayerEntity)this));
                if (this.shadow$func_70051_ag() && isStrongAttack) {
                    ++knockbackModifier;
                    isSprintingAttack = true;
                }
                isCriticalAttack = isStrongAttack && this.field_70143_R > 0.0f && !this.field_70122_E && !this.shadow$func_70617_f_() && !this.shadow$func_70090_H() && !this.shadow$func_70644_a(Effects.field_76440_q) && !this.shadow$func_184218_aH() && targetEntity instanceof LivingEntity;
                isCriticalAttack = isCriticalAttack && !this.shadow$func_70051_ag();
                EventHooks.CriticalHitResult criticalResult = PlatformHooks.INSTANCE.getEventHooks().callCriticalHitEvent((PlayerEntity)this, targetEntity, isCriticalAttack, isCriticalAttack ? 1.5f : 1.0f);
                isCriticalAttack = criticalResult.criticalHit;
                if (isCriticalAttack) {
                    originalFunctions.add(DamageEventUtil.provideCriticalAttackTuple((PlayerEntity)this, criticalResult.modifier));
                }
                double distanceWalkedDelta = this.field_70140_Q - this.field_70141_P;
                ItemStack heldItem = this.shadow$func_184614_ca();
                if (isStrongAttack && !isCriticalAttack && !isSprintingAttack && this.field_70122_E && distanceWalkedDelta < (double)this.shadow$func_70689_ay() && heldItem.func_77973_b() instanceof SwordItem) {
                    isSweapingAttack = true;
                }
                DamageSource damageSource = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this));
                boolean bl = isMainthread = !this.field_70170_p.field_72995_K;
                if (isMainthread) {
                    PhaseTracker.getInstance().pushCause(damageSource);
                }
                Cause currentCause = isMainthread ? PhaseTracker.getInstance().currentCause() : Cause.of(EventContext.empty(), damageSource);
                AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(currentCause, (Entity)targetEntity, originalFunctions, knockbackModifier, originalBaseDamage);
                SpongeCommon.post(event);
                if (isMainthread) {
                    PhaseTracker.getInstance().popCause();
                }
                if (event.isCancelled()) {
                    return;
                }
                damage = (float)event.finalOutputDamage();
                double attackDamage = damage;
                knockbackModifier = (int)event.knockbackModifier();
                enchantmentDamage = (float)enchantmentModifiers.stream().mapToDouble(event::outputDamage).sum();
                float targetOriginalHealth = 0.0f;
                boolean litEntityOnFire = false;
                int fireAspectModifier = EnchantmentHelper.func_90036_a((LivingEntity)((PlayerEntity)this));
                if (targetEntity instanceof LivingEntity) {
                    targetOriginalHealth = ((LivingEntity)targetEntity).func_110143_aJ();
                    if (fireAspectModifier > 0 && !targetEntity.func_70027_ad()) {
                        litEntityOnFire = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                Vector3d targetMotion = targetEntity.func_213322_ci();
                boolean attackSucceeded = targetEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this)), damage);
                if (attackSucceeded) {
                    if (knockbackModifier > 0) {
                        if (targetEntity instanceof LivingEntity) {
                            ((LivingEntity)targetEntity).func_233627_a_((float)knockbackModifier * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f));
                        }
                        this.shadow$func_213317_d(this.shadow$func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                        this.shadow$func_70031_b(false);
                    }
                    if (isSweapingAttack) {
                        for (LivingEntity livingEntity : this.field_70170_p.func_217357_a(LivingEntity.class, targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (livingEntity == (PlayerEntity)this || livingEntity == targetEntity || this.shadow$func_184191_r((net.minecraft.entity.Entity)livingEntity) || livingEntity instanceof ArmorStandEntity && ((ArmorStandEntity)livingEntity).func_181026_s() || !(this.shadow$func_70068_e((net.minecraft.entity.Entity)livingEntity) < 9.0)) continue;
                            EntityDamageSource sweepingAttackSource = (EntityDamageSource)((EntityDamageSource.Builder)((EntityDamageSource.Builder)EntityDamageSource.builder().entity((Player)((Object)this))).type(DamageTypes.SWEEPING_ATTACK)).build();
                            CauseStackManager.StackFrame frame = isMainthread ? PhaseTracker.getInstance().pushCauseFrame() : null;
                            try {
                                if (isMainthread) {
                                    frame.pushCause(sweepingAttackSource);
                                }
                                ItemStackSnapshot heldSnapshot = ItemStackUtil.snapshotOf(heldItem);
                                if (isMainthread) {
                                    frame.addContext(EventContextKeys.WEAPON, heldSnapshot);
                                }
                                DamageFunction sweapingFunction = DamageFunction.of(DamageModifier.builder().cause(Cause.of(EventContext.empty(), heldSnapshot)).item(heldSnapshot).type(DamageModifierTypes.SWEEPING).build(), incoming -> (double)EnchantmentHelper.func_191527_a((LivingEntity)((PlayerEntity)this)) * attackDamage);
                                ArrayList<DamageFunction> sweapingFunctions = new ArrayList<DamageFunction>();
                                sweapingFunctions.add(sweapingFunction);
                                AttackEntityEvent sweepingAttackEvent = SpongeEventFactory.createAttackEntityEvent(currentCause, (Entity)livingEntity, sweapingFunctions, 1.0f, 1.0);
                                SpongeCommon.post(sweepingAttackEvent);
                                if (sweepingAttackEvent.isCancelled()) continue;
                                livingEntity.func_233627_a_(sweepingAttackEvent.knockbackModifier() * 0.4f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                                livingEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this)), (float)sweepingAttackEvent.finalOutputDamage());
                            }
                            finally {
                                if (frame == null) continue;
                                frame.close();
                            }
                        }
                        if (this.bridge$vanishState().createsSounds()) {
                            this.field_70170_p.func_184148_a(null, this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_(), SoundEvents.field_187730_dW, this.shadow$func_184176_by(), 1.0f, 1.0f);
                        }
                        this.shadow$func_184810_cG();
                    }
                    if (targetEntity instanceof ServerPlayerEntity && targetEntity.field_70133_I) {
                        ((ServerPlayerEntity)targetEntity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.func_213317_d(targetMotion);
                    }
                    if (isCriticalAttack) {
                        if (this.bridge$vanishState().createsSounds()) {
                            this.field_70170_p.func_184148_a(null, this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_(), SoundEvents.field_187718_dS, this.shadow$func_184176_by(), 1.0f, 1.0f);
                        }
                        this.shadow$func_71009_b(targetEntity);
                    }
                    if (!isCriticalAttack && !isSweapingAttack && this.bridge$vanishState().createsSounds()) {
                        if (isStrongAttack) {
                            this.field_70170_p.func_184148_a(null, this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_(), SoundEvents.field_187727_dV, this.shadow$func_184176_by(), 1.0f, 1.0f);
                        } else {
                            this.field_70170_p.func_184148_a(null, this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_(), SoundEvents.field_187733_dX, this.shadow$func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    if (enchantmentDamage > 0.0f) {
                        this.shadow$func_71047_c(targetEntity);
                    }
                    this.shadow$func_130011_c(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)((LivingEntity)targetEntity), (net.minecraft.entity.Entity)((PlayerEntity)this));
                    }
                    EnchantmentHelper.func_151385_b((LivingEntity)((PlayerEntity)this), (net.minecraft.entity.Entity)targetEntity);
                    ItemStack itemstack1 = this.shadow$func_184614_ca();
                    net.minecraft.entity.Entity entity = targetEntity;
                    entity = PlatformHooks.INSTANCE.getEntityHooks().getParentPart(entity);
                    if (!this.field_70170_p.field_72995_K && !itemstack1.func_190926_b() && entity instanceof LivingEntity) {
                        itemstack1.func_77961_a((LivingEntity)entity, (PlayerEntity)this);
                        if (itemstack1.func_190926_b()) {
                            PlatformHooks.INSTANCE.getEventHooks().callItemDestroyedEvent((PlayerEntity)this, itemstack1, Hand.MAIN_HAND);
                            this.shadow$func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
                        TransactionalCaptureSupplier transactor = context.getTransactor();
                        transactor.logPlayerInventoryChange((PlayerEntity)this, PlayerInventoryTransaction.EventCreator.STANDARD);
                        this.field_71069_bz.func_75142_b();
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = targetOriginalHealth - ((LivingEntity)targetEntity).func_110143_aJ();
                        this.shadow$func_195067_a(Stats.field_188111_y, Math.round(f5 * 10.0f));
                        if (fireAspectModifier > 0) {
                            targetEntity.func_70015_d(fireAspectModifier * 4);
                        }
                        if (this.field_70170_p instanceof ServerWorld && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((net.minecraft.world.server.ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, targetEntity.func_226277_ct_(), targetEntity.func_226278_cu_() + (double)(targetEntity.func_213302_cg() * 0.5f), targetEntity.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.shadow$func_71020_j(0.1f);
                } else {
                    if (this.bridge$vanishState().createsSounds()) {
                        this.field_70170_p.func_184148_a(null, this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_(), SoundEvents.field_187724_dU, this.shadow$func_184176_by(), 1.0f, 1.0f);
                    }
                    if (litEntityOnFire) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }

    @Override
    @Overwrite
    protected void func_70665_d(DamageSource damageSource, float damage) {
        this.bridge$damageEntity(damageSource, damage);
    }
}

