/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.projectile.explosive.fireball.ExplosiveFireball;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.world.entity.GrieferBridge;
import org.spongepowered.common.bridge.world.entity.projectile.LargeFireballBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.projectile.AbstractHurtingProjectileMixin;

@Mixin(value={FireballEntity.class})
public abstract class LargeFireballMixin
extends AbstractHurtingProjectileMixin
implements LargeFireballBridge,
ExplosiveBridge {
    @Shadow
    public int field_92057_e;

    @Redirect(method={"func_70227_a(Lnet/minecraft/util/math/RayTraceResult;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;func_217398_a(Lnet/minecraft/entity/Entity;DDDFZLnet/minecraft/world/Explosion$Mode;)Lnet/minecraft/world/Explosion;"))
    @Nullable
    public net.minecraft.world.Explosion impl$throwExplosionEventAndExplode(World worldObj, @Nullable Entity nil, double x, double y, double z, float strength, boolean flaming, Explosion.Mode mode) {
        return this.bridge$throwExplosionEventAndExplode(worldObj, nil, x, y, z, strength, flaming, mode);
    }

    @Override
    public net.minecraft.world.Explosion bridge$throwExplosionEventAndExplode(World worldObj, @Nullable Entity nil, double x, double y, double z, float strength, boolean flaming, Explosion.Mode mode) {
        boolean griefer = ((GrieferBridge)((Object)this)).bridge$canGrief();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            ((Projectile)((Object)this)).get(Keys.SHOOTER).ifPresent(shooter -> frame.addContext(EventContextKeys.PROJECTILE_SOURCE, shooter));
            Optional<net.minecraft.world.Explosion> ex = SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().location(ServerLocation.of((ServerWorld)worldObj, x, y, z)).sourceExplosive((ExplosiveFireball)((Object)this)).radius(strength).canCauseFire(flaming && griefer).shouldPlaySmoke(mode != Explosion.Mode.NONE && griefer).shouldBreakBlocks(mode != Explosion.Mode.NONE && griefer));
            net.minecraft.world.Explosion explosion = ex.orElse(null);
            return explosion;
        }
    }

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.field_92057_e);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.field_92057_e = radius == null ? 1 : radius;
    }
}

