/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.util.math.RayTraceResult;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.projectile.ThrowableProjectileMixin;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={EnderPearlEntity.class})
public abstract class ThrownEnderpearlMixin
extends ThrowableProjectileMixin {
    private double impl$damageAmount;

    @ModifyArg(method={"func_70227_a(Lnet/minecraft/util/math/RayTraceResult;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;func_70097_a(Lnet/minecraft/util/DamageSource;F)Z"))
    private float impl$onAttackEntityFromWithDamage(float damage) {
        return (float)this.impl$damageAmount;
    }

    @Inject(method={"func_70227_a(Lnet/minecraft/util/math/RayTraceResult;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;func_70634_a(DDD)V")}, cancellable=true)
    private void impl$callMoveEntityEventForThrower(RayTraceResult result, CallbackInfo ci) {
        if (this.shadow$func_130014_f_().field_72995_K || !ShouldFire.MOVE_ENTITY_EVENT) {
            return;
        }
        Entity entity = this.shadow$func_234616_v_();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entity);
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.ENDER_PEARL);
            MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(frame.currentCause(), (org.spongepowered.api.entity.Entity)entity, VecHelper.toVector3d(entity.func_213303_ch()), VecHelper.toVector3d(this.shadow$func_213303_ch()), VecHelper.toVector3d(this.shadow$func_213303_ch()));
            if (SpongeCommon.post(event)) {
                this.shadow$func_70106_y();
                ci.cancel();
                return;
            }
            Vector3d destinationPosition = event.destinationPosition();
            this.shadow$func_70107_b(destinationPosition.x(), destinationPosition.y(), destinationPosition.z());
        }
    }

    @Override
    @Nullable
    public Entity impl$postProcessChangeDimension(Entity entity) {
        if (entity instanceof EnderPearlEntity) {
            this.shadow$func_212361_a(null);
        }
        return entity;
    }
}

