/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.projectile.explosive.WitherSkull;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.accessor.world.entity.projectile.ProjectileAccessor;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.world.entity.GrieferBridge;
import org.spongepowered.common.bridge.world.entity.projectile.WitherSkullBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.projectile.AbstractHurtingProjectileMixin;

@Mixin(value={WitherSkullEntity.class})
public abstract class WitherSkullMixin
extends AbstractHurtingProjectileMixin
implements WitherSkullBridge,
ExplosiveBridge {
    private int impl$explosionRadius = 1;
    private float impl$damage = 0.0f;
    private boolean impl$damageSet = false;

    @ModifyArg(method={"func_213868_a(Lnet/minecraft/util/math/EntityRayTraceResult;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;func_70097_a(Lnet/minecraft/util/DamageSource;F)Z"))
    private float impl$onAttackEntityFrom(float amount) {
        if (this.impl$damageSet) {
            return this.impl$damage;
        }
        if (((ProjectileAccessor)((Object)this)).accessor$ownerUUID() != null) {
            return 8.0f;
        }
        return 5.0f;
    }

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.impl$explosionRadius);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer explosionRadius) {
        this.impl$explosionRadius = explosionRadius == null ? 1 : explosionRadius;
    }

    @Nullable
    @Redirect(method={"func_70227_a(Lnet/minecraft/util/math/RayTraceResult;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;func_217398_a(Lnet/minecraft/entity/Entity;DDDFZLnet/minecraft/world/Explosion$Mode;)Lnet/minecraft/world/Explosion;"))
    public net.minecraft.world.Explosion impl$CreateAndProcessExplosionEvent(World worldObj, Entity self, double x, double y, double z, float strength, boolean flaming, Explosion.Mode mode) {
        return this.bridge$throwExplosionEventAndExplosde(worldObj, self, x, y, z, strength, flaming, mode);
    }

    @Override
    public net.minecraft.world.Explosion bridge$throwExplosionEventAndExplosde(World worldObj, Entity self, double x, double y, double z, float strength, boolean flaming, Explosion.Mode mode) {
        boolean griefer = ((GrieferBridge)((Object)this)).bridge$canGrief();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            ((Projectile)((Object)this)).get(Keys.SHOOTER).ifPresent(shooter -> {
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, shooter);
                frame.pushCause(shooter);
            });
            net.minecraft.world.Explosion explosion = SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().location(ServerLocation.of((ServerWorld)worldObj, x, y, z)).sourceExplosive((WitherSkull)((Object)this)).radius(this.impl$explosionRadius).canCauseFire(flaming).shouldPlaySmoke(mode != Explosion.Mode.NONE && griefer).shouldBreakBlocks(mode != Explosion.Mode.NONE && griefer)).orElse(null);
            return explosion;
        }
    }
}

