/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.vehicle;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.vehicle.minecart.TNTMinecart;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.vehicle.AbstractMinecartMixin;

@Mixin(value={TNTMinecartEntity.class})
public abstract class MinecartTNTMixin
extends AbstractMinecartMixin
implements FusedExplosiveBridge,
ExplosiveBridge {
    @Shadow
    private int field_94106_a;
    @Nullable
    private Integer impl$explosionRadius = null;
    private int impl$fuseDuration = 80;
    private boolean impl$detonationCancelled;
    @Nullable
    private Object impl$primeCause;

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.ofNullable(this.impl$explosionRadius);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.impl$explosionRadius = radius;
    }

    @Override
    public int bridge$getFuseDuration() {
        return this.impl$fuseDuration;
    }

    @Override
    public void bridge$setFuseDuration(int fuseTicks) {
        this.impl$fuseDuration = fuseTicks;
    }

    @Override
    public int bridge$getFuseTicksRemaining() {
        return this.field_94106_a;
    }

    @Override
    public void bridge$setFuseTicksRemaining(int fuseTicks) {
        this.field_94106_a = fuseTicks;
    }

    @Inject(method={"func_70097_a(Lnet/minecraft/util/DamageSource;F)Z"}, at={@At(value="HEAD")})
    private void impl$onAttackSetPrimeCause(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> ci) {
        this.impl$primeCause = damageSource;
    }

    @Inject(method={"func_96095_a(IIIZ)V"}, at={@At(value="HEAD")})
    private void impl$onActivateSetPrimeCauseNotifier(int x, int y, int z, boolean receivingPower, CallbackInfo ci) {
        if (((LevelBridge)this.field_70170_p).bridge$isFake()) {
            return;
        }
        if (receivingPower) {
            ((ServerWorld)this.field_70170_p).get(x, y, z, Keys.NOTIFIER).ifPresent(notifier -> {
                this.impl$primeCause = notifier;
            });
        }
    }

    @Inject(method={"func_94105_c()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$preIgnite(CallbackInfo ci) {
        if (!this.bridge$shouldPrime()) {
            this.bridge$setFuseTicksRemaining(-1);
            ci.cancel();
        }
    }

    @Inject(method={"func_94105_c()V"}, at={@At(value="RETURN")})
    private void impl$postIgnite(CallbackInfo ci) {
        this.bridge$setFuseTicksRemaining(this.impl$fuseDuration);
        if (this.impl$primeCause != null) {
            PhaseTracker.getCauseStackManager().pushCause(this.impl$primeCause);
        }
        this.bridge$postPrime();
        if (this.impl$primeCause != null) {
            PhaseTracker.getCauseStackManager().popCause();
        }
    }

    @Redirect(method={"func_94103_c(D)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;func_217385_a(Lnet/minecraft/entity/Entity;DDDFLnet/minecraft/world/Explosion$Mode;)Lnet/minecraft/world/Explosion;"))
    @Nullable
    private net.minecraft.world.Explosion impl$useSpongeExplosion(World world, Entity entityIn, double xIn, double yIn, double zIn, float explosionRadius, Explosion.Mode modeIn) {
        return SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().location(ServerLocation.of((ServerWorld)world, xIn, yIn, zIn)).sourceExplosive((TNTMinecart)((Object)this)).radius(this.impl$explosionRadius != null ? (float)this.impl$explosionRadius.intValue() : explosionRadius).shouldPlaySmoke(modeIn.ordinal() > Explosion.Mode.NONE.ordinal()).shouldBreakBlocks(modeIn.ordinal() > Explosion.Mode.NONE.ordinal())).orElseGet(() -> {
            this.impl$detonationCancelled = true;
            return null;
        });
    }

    @Inject(method={"func_94103_c(D)V"}, at={@At(value="RETURN")})
    private void impL$postExplode(CallbackInfo ci) {
        if (this.impl$detonationCancelled) {
            this.field_70128_L = false;
            this.impl$detonationCancelled = false;
        }
    }

    @Inject(method={"func_70097_a(Lnet/minecraft/util/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/minecart/TNTMinecartEntity;func_94103_c(D)V")}, cancellable=true)
    private void impl$postOnAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(source);
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(frame.currentCause(), (TNTMinecart)((Object)this), new ArrayList<DamageFunction>(), 0.0f, amount);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                cir.setReturnValue((Object)true);
            }
        }
    }
}

