/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.explosive.FireworkRocket;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={FireworkRocketItem.class})
public abstract class FireworkRocketItemMixin {
    private FireworkRocketEntity impl$capturedRocket;

    @Inject(method={"func_77659_a(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"}, at={@At(value="NEW", target="Lnet/minecraft/entity/projectile/FireworkRocketEntity;")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void impl$throwPreBeforeSpawning(World worldIn, PlayerEntity playerIn, Hand handIn, CallbackInfoReturnable<ActionResult<ItemStack>> cir, ItemStack stack) {
        if (this.impl$throwConstructPreEvent(worldIn, playerIn, stack)) {
            cir.setReturnValue((Object)new ActionResult(ActionResultType.SUCCESS, (Object)stack));
        }
    }

    @Inject(method={"func_195939_a(Lnet/minecraft/item/ItemUseContext;)Lnet/minecraft/util/ActionResultType;"}, at={@At(value="NEW", target="Lnet/minecraft/entity/projectile/FireworkRocketEntity;")}, cancellable=true)
    private void impl$throwPrimeEventsIfCancelled(ItemUseContext context, CallbackInfoReturnable<ActionResultType> cir) {
        if (this.impl$throwConstructPreEvent(context.func_195991_k(), context.func_195999_j(), context.func_195996_i())) {
            cir.setReturnValue((Object)ActionResultType.SUCCESS);
        }
    }

    private boolean impl$throwConstructPreEvent(World world, PlayerEntity player, ItemStack usedItem) {
        if (ShouldFire.CONSTRUCT_ENTITY_EVENT_PRE && !((LevelBridge)world).bridge$isFake()) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(usedItem));
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, (ProjectileSource)player);
                frame.pushCause(player);
                ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.currentCause(), ServerLocation.of((ServerWorld)world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()), new org.spongepowered.math.vector.Vector3d(0.0f, 0.0f, 0.0f), EntityTypes.FIREWORK_ROCKET.get());
                boolean bl = SpongeCommon.post(event);
                return bl;
            }
        }
        return false;
    }

    @Inject(method={"func_195939_a(Lnet/minecraft/item/ItemUseContext;)Lnet/minecraft/util/ActionResultType;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;func_217376_c(Lnet/minecraft/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void impl$injectPrimeEventAndCancel(ItemUseContext context, CallbackInfoReturnable<ActionResultType> cir, World world, ItemStack usedItem, Vector3d vec3d, Direction direction, FireworkRocketEntity rocket) {
        if (this.impl$throwPrimeEventAndGetCancel(context.func_195991_k(), context.func_195999_j(), rocket, usedItem)) {
            cir.setReturnValue((Object)ActionResultType.SUCCESS);
        }
    }

    @Redirect(method={"func_77659_a(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;func_217376_c(Lnet/minecraft/entity/Entity;)Z"))
    private boolean impl$captureFireworkRocket(World world, Entity p_217376_1_) {
        this.impl$capturedRocket = (FireworkRocketEntity)p_217376_1_;
        return true;
    }

    @Inject(method={"func_77659_a(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;func_217376_c(Lnet/minecraft/entity/Entity;)Z", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void impl$injectPrimeEventAndCancel(World worldIn, PlayerEntity player, Hand handIn, CallbackInfoReturnable<ActionResult<ItemStack>> cir, ItemStack usedItem) {
        if (this.impl$throwPrimeEventAndGetCancel(worldIn, player, this.impl$capturedRocket, usedItem)) {
            this.impl$capturedRocket = null;
            cir.setReturnValue((Object)new ActionResult(ActionResultType.SUCCESS, (Object)usedItem));
        }
        worldIn.func_217376_c((Entity)this.impl$capturedRocket);
        this.impl$capturedRocket = null;
    }

    private boolean impl$throwPrimeEventAndGetCancel(World world, PlayerEntity player, FireworkRocketEntity rocket, ItemStack usedItem) {
        if (((LevelBridge)world).bridge$isFake()) {
            return false;
        }
        ((FireworkRocket)rocket).offer(Keys.SHOOTER, (Player)player);
        if (ShouldFire.PRIME_EXPLOSIVE_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(usedItem));
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, (ProjectileSource)player);
                frame.pushCause(player);
                if (!((FusedExplosiveBridge)rocket).bridge$shouldPrime()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }
}

