/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level;

import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.IWorldInfo;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.projectile.EnderPearl;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.entity.MobAccessor;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DataUtil;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={World.class})
public abstract class LevelMixin
implements LevelBridge,
IWorld {
    @Mutable
    @Shadow
    @Final
    private DimensionType field_234921_x_;
    @Shadow
    protected float field_73003_n;
    @Shadow
    protected float field_73004_o;
    @Shadow
    protected float field_73018_p;
    @Shadow
    protected float field_73017_q;

    @Shadow
    public abstract IWorldInfo shadow$func_72912_H();

    @Shadow
    public abstract void shadow$func_72966_v();

    @Shadow
    public abstract RegistryKey<World> shadow$func_234923_W_();

    @Shadow
    public abstract DimensionType shadow$func_230315_m_();

    @Shadow
    public abstract Chunk shadow$func_175726_f(BlockPos var1);

    @Shadow
    public abstract DifficultyInstance shadow$func_175649_E(BlockPos var1);

    @Shadow
    public abstract boolean shadow$func_72896_J();

    @Shadow
    @javax.annotation.Nullable
    public abstract TileEntity shadow$func_175625_s(BlockPos var1);

    @Shadow
    public abstract WorldBorder shadow$func_175723_af();

    @Override
    public boolean bridge$isFake() {
        return this.func_201670_d();
    }

    @Override
    public void bridge$adjustDimensionLogic(DimensionType dimensionType) {
        this.field_234921_x_ = dimensionType;
    }

    @Override
    public <E extends Entity> E bridge$createEntity(DataContainer dataContainer, @Nullable Vector3d position, @Nullable Predicate<Vector3d> positionCheck) throws IllegalArgumentException, IllegalStateException {
        EntityType<@NonNull ?> type = dataContainer.getRegistryValue(Constants.Entity.TYPE, RegistryTypes.ENTITY_TYPE).orElseThrow(() -> new IllegalArgumentException("DataContainer does not contain a valid entity type."));
        Vector3d proposedPosition = position == null ? DataUtil.getPosition3d(dataContainer, Constants.Sponge.SNAPSHOT_WORLD_POSITION) : position;
        if (positionCheck != null && !positionCheck.test(proposedPosition)) {
            throw new IllegalArgumentException(String.format("Position (%.2f, %.2f, %.2f) is not a valid position in this context.", proposedPosition.x(), proposedPosition.y(), proposedPosition.z()));
        }
        Vector3d rotation = dataContainer.contains(Constants.Entity.ROTATION) ? DataUtil.getPosition3d(dataContainer, Constants.Entity.ROTATION) : null;
        Vector3d scale = dataContainer.contains(Constants.Entity.SCALE) ? DataUtil.getPosition3d(dataContainer, Constants.Entity.SCALE) : null;
        Object createdEntity = this.bridge$createEntity(type, position, false);
        dataContainer.getView(Constants.Sponge.UNSAFE_NBT).map(NBTTranslator.INSTANCE::translate).ifPresent(x -> {
            net.minecraft.entity.Entity e = (net.minecraft.entity.Entity)createdEntity;
            x.func_82580_o("Dimension");
            e.func_70020_e(x);
            e.func_225653_b_(proposedPosition.x(), proposedPosition.y(), proposedPosition.z());
        });
        if (rotation != null) {
            createdEntity.setRotation(rotation);
        }
        if (scale != null) {
            createdEntity.setScale(scale);
        }
        return (E)createdEntity;
    }

    @Override
    public <E extends Entity> E bridge$createEntity(EntityType<E> type, Vector3d position, boolean naturally) throws IllegalArgumentException, IllegalStateException {
        if (type == net.minecraft.entity.EntityType.field_200729_aH) {
            throw new IllegalArgumentException("A Player cannot be created by the API!");
        }
        net.minecraft.entity.Entity entity = null;
        double x = position.x();
        double y = position.y();
        double z = position.z();
        World thisWorld = (World)this;
        if (type == net.minecraft.entity.EntityType.field_200728_aG) {
            entity = net.minecraft.entity.EntityType.field_200728_aG.func_200721_a(thisWorld);
            entity.func_225653_b_(x, y, z);
            ((LightningBoltEntity)entity).func_233623_a_(false);
        }
        if (type == net.minecraft.entity.EntityType.field_200752_ar) {
            ArmorStandEntity tempEntity = new ArmorStandEntity(thisWorld, x, y, z);
            tempEntity.func_70107_b(tempEntity.func_226277_ct_(), tempEntity.func_226278_cu_() - (double)tempEntity.func_70047_e(), tempEntity.func_226281_cx_());
            entity = new EnderPearlEntity(thisWorld, (LivingEntity)tempEntity);
            ((EnderPearl)entity).offer(Keys.SHOOTER, UnknownProjectileSource.UNKNOWN);
        }
        if (type == net.minecraft.entity.EntityType.field_200809_w) {
            entity = new FallingBlockEntity(thisWorld, x, y, z, Blocks.field_150354_m.func_176223_P());
        }
        if (type == net.minecraft.entity.EntityType.field_200765_E) {
            entity = new ItemEntity(thisWorld, x, y, z, new ItemStack((IItemProvider)Blocks.field_150348_b));
        }
        if (entity == null) {
            ResourceKey key = (ResourceKey)Registry.field_212629_r.func_177774_c((Object)((net.minecraft.entity.EntityType)type));
            try {
                entity = ((net.minecraft.entity.EntityType)type).func_200721_a(thisWorld);
                entity.func_225653_b_(x, y, z);
            }
            catch (Exception e) {
                throw new RuntimeException("There was an issue attempting to construct " + key, e);
            }
        }
        if (entity instanceof HangingEntity && !((HangingEntity)entity).func_70518_d()) {
            throw new IllegalArgumentException("Hanging entity does not survive at the given position: " + position);
        }
        if (naturally && entity instanceof MobEntity) {
            DifficultyInstance difficulty = this.shadow$func_175649_E(new BlockPos(x, y, z));
            ((MobAccessor)entity).invoker$populateDefaultEquipmentSlots(difficulty);
        }
        if (entity instanceof PaintingEntity) {
            ((PaintingEntity)entity).field_70522_e = PaintingType.field_200843_b;
        }
        return (E)((Entity)entity);
    }
}

